# Dockerfiles for Windows Integration Tests

## Index

- [About](#about-this-file)
- [Consul Windows](#consul-windows)
- [Consul Windows Local](#consul-windows-local)
- [Consul Windows Dev](#consul-windows-dev)
- [Dockerfile-openzipkin-windows](#dockerfile-openzipkin-windows)

## About this File

In this file you will find which Docker images that need to be pre-built to run the Envoy integration tests on Windows, as well as information on how to run each of these files individually for testing purposes.

## Consul Windows

The Windows/Consul:_{VERSION}_ image is built from the "Dockerfile-windows" file located at the root of the project.
To do this, the official [windows/servercore image](https://hub.docker.com/_/microsoft-windows-servercore) is used as base image.
To build the image, use the following command:

```shell
docker build -t windows/consul -f Dockerfile-windows . --build-arg VERSION=${VERSION}
```

You can test the built file by running the following command:

```shell
docker run --rm -p 8300:8300 -p 8301:8301 -p 8302:8302 -p 8500:8500 -p 8600:8600 --name consul --hostname "consul-primary-server" --network-alias "consul-primary-server" windows/consul agent -dev -datacenter "primary" -grpc-port -1 -client "0.0.0.0" -bind "0.0.0.0"
```

If everything works properly you should openning the browser and check the Consul UI running on: `http://localhost:8500`

## Consul Windows Local

The Windows/Consul:_{VERSION}_-local custom image deployed in the "Dockerfile-consul-local-windows" DockerFile is built from the selected by the shell script _build-consul-local-images.sh_.
When executing it, all the tools required to run the Windows Connect Envoy Integration Tests will be added to the image.
It is necessary that the _"windows/consul"_ image has been built first. This script also takes care of that.  

To build this image you need to run the following command on your terminal:

```shell
./build-consul-local-images.sh
```

> [!NOTE]
> Shell script execution may vary depending on your terminal, we recommend using **Git Bash** for Windows.  

```shell
docker run --rm -p 8300:8300 -p 8301:8301 -p 8302:8302 -p 8500:8500 -p 8600:8600 --name consul-local --hostname "consul-primary-server" --network-alias "consul-primary-server" windows/consul:_{VERSION}_-local agent -dev -datacenter "primary" -grpc-port -1 -client "0.0.0.0" -bind "0.0.0.0"
```

If everything works properly you can use your browser and check the Consul UI running on: `http://localhost:8500`

## Consul Windows Dev

The Windows/Consul:_{VERSION}_-dev custom image deployed in the "Dockerfile-consul-dev-windows" DockerFile is generated by the shell script named _build-consul-dev-image.sh_.
When executing it, the compilation of Consul is carried out and it is saved in the _"dist"_ directory, this file is then copied to the _"windows/consul:_{VERSION}_-dev"_ image.
It is necessary that the _"windows/consul_{VERSION}_-local"_ image has been built first.

To build this image you need to run the following command on your terminal:

```shell
./build-consul-dev-image.sh
```

> [!NOTE]
> Shell script execution may vary depending on your terminal, we recommend using **Git Bash** for Windows.  

You can test the built file by running the following command:

```shell
docker run --rm -p 8300:8300 -p 8301:8301 -p 8302:8302 -p 8500:8500 -p 8600:8600 --name consul-local --hostname "consul-primary-server" --network-alias "consul-primary-server" windows/consul:_{VERSION}_-dev agent -dev -datacenter "primary" -grpc-port -1 -client "0.0.0.0" -bind "0.0.0.0"
```

If everything works properly you can use your browser and check the Consul UI running on: `http://localhost:8500`

## Dockerfile-openzipkin-windows

Due to the unavailability of an official Openzipkin Docker image for Windows, the [openjdk Windows image](https://hub.docker.com/layers/openjdk/library/openjdk/jdk-windowsservercore-1809/images/sha256-b0cc238d2ec5fb58109a0006ff9e1bcaf66a5301f49bcb8dece9599ac5be6331) was used, where the latest self-contained executable Openzipkin .jar file is downloaded.

To build this image you need to run the following command on your terminal:

```shell
docker build -t openzipkin -f Dockerfile-openzipkin-windows .
```

You can test the built file by running the following command:

```shell
docker run --rm --name openzipkin
```

If everything works as it should, you will see the zipkin logo being displayed, along with the current version and port configuration:

```shell
:: version 2.23.18 :: commit 4b71677 ::

20XX-XX-XX XX:XX:XX.XXX  INFO [/] 1252 --- [oss-http-*:9411] c.l.a.s.Server                           : Serving HTTP at /[0:0:0:0:0:0:0:0]:9411 - http://127.0.0.1:9411/
```

# Testing

During development, it may be more convenient to check your work-in-progress by running only the tests which you expect to be affected by your changes, as the full test suite can take several minutes to execute. [Go's built-in test tool](https://golang.org/pkg/cmd/go/internal/test/) allows specifying a list of packages to test and the `-run` option to only include test names matching a regular expression.
The `go test -short` flag can also be used to skip slower tests.

Examples (run from the repository root):

- `go test -v ./connect` will run all tests in the connect package (see `./connect` folder)
- `go test -v -run TestRetryJoin ./command/agent` will run all tests in the agent package (see `./command/agent` folder) with name substring `TestRetryJoin`

When a pull request is opened CI will run all tests and lint to verify the change.

If you want to run the tests on Windows images you must attach the win=true flag.

Example:

```shell
go test -v -timeout=30m -tags integration ./test/integration/connect/envoy -run="TestEnvoy/case-badauthz" -win=true
```
