/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.probsoln;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXPath;
import com.dickimawbooks.texparserlib.latex.CsvList;
import com.dickimawbooks.texparserlib.latex.probsoln.ProbSolnData;
import com.dickimawbooks.texparserlib.latex.probsoln.ProbSolnDatabase;
import com.dickimawbooks.texparserlib.latex.probsoln.ProbSolnSty;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class LoadRandomProblems
extends ControlSequence {
    private ProbSolnSty sty;

    public LoadRandomProblems(ProbSolnSty probSolnSty) {
        this("loadrandomproblems", probSolnSty);
    }

    public LoadRandomProblems(String string, ProbSolnSty probSolnSty) {
        super(string);
        this.sty = probSolnSty;
    }

    @Override
    public Object clone() {
        return new LoadRandomProblems(this.getName(), this.sty);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        String string = this.popOptLabelString(teXParser, teXObjectList);
        if (string == null) {
            string = "default";
        }
        int n = this.popInt(teXParser, teXObjectList);
        TeXObject teXObject = this.popArgExpandFully(teXParser, teXObjectList);
        teXParser.startGroup();
        ProbSolnDatabase probSolnDatabase = this.sty.getTmpDatabase();
        teXParser.putControlSequence(true, new GenericCommand(true, "prob@currentdb", null, teXParser.getListener().createString(probSolnDatabase.getName())));
        CsvList csvList = CsvList.getList(teXParser, teXObject);
        int n2 = csvList.size();
        for (int i = 0; i < n2; ++i) {
            teXParser.getListener().input(new TeXPath(teXParser, csvList.getValue(i).toString(teXParser)), teXObjectList);
        }
        teXParser.putControlSequence(true, new GenericCommand(true, "prob@currentdb", null, teXParser.getListener().createString(string)));
        ProbSolnDatabase probSolnDatabase2 = this.sty.isDatabaseDefined(string) ? this.sty.getDatabase(string) : this.sty.addDatabase(string);
        if (probSolnDatabase2.size() > 0) {
            Vector<String> vector = new Vector<String>(probSolnDatabase2.size());
            Iterator iterator = ((ConcurrentHashMap.KeySetView)probSolnDatabase2.keySet()).iterator();
            while (iterator.hasNext()) {
                vector.add((String)iterator.next());
            }
            Collections.shuffle(vector, this.sty.getRandom());
            int n3 = Integer.min(probSolnDatabase2.size(), n);
            for (int i = 0; i < n3; ++i) {
                String string2 = (String)vector.get(i);
                ProbSolnData probSolnData = (ProbSolnData)probSolnDatabase.get(string2);
                if (probSolnData == null) continue;
                probSolnDatabase2.put(probSolnData.getName(), probSolnData);
            }
        }
        this.sty.clearTmpDatabase();
        teXParser.endGroup();
    }
}

