<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [
	<!ENTITY lowercase "'abcdefghijklmnopqrstuvwxyz'">
	<!ENTITY uppercase "'ABCDEFGHIJKLMNOPQRSTUVWXYZ'">
	<!ENTITY primary 'concat(primary/@sortas, primary[not(@sortas)])'>
	<!ENTITY secondary 'concat(secondary/@sortas, secondary[not(@sortas)])'>
	<!ENTITY tertiary 'concat(tertiary/@sortas, tertiary[not(@sortas)])'>
	<!ENTITY section '(ancestor-or-self::set
                     |ancestor-or-self::book
                     |ancestor-or-self::part
                     |ancestor-or-self::reference
                     |ancestor-or-self::partintro
                     |ancestor-or-self::chapter
                     |ancestor-or-self::appendix
                     |ancestor-or-self::preface
                     |ancestor-or-self::section
                     |ancestor-or-self::sect1
                     |ancestor-or-self::sect2
                     |ancestor-or-self::sect3
                     |ancestor-or-self::sect4
                     |ancestor-or-self::sect5
                     |ancestor-or-self::refsect1
                     |ancestor-or-self::refsect2
                     |ancestor-or-self::refsect3
                     |ancestor-or-self::simplesect
                     |ancestor-or-self::bibliography
                     |ancestor-or-self::glossary
                     |ancestor-or-self::index)[last()]'>
	<!ENTITY section.id 'generate-id(&section;)'>
	<!ENTITY sep '" "'>
]>
<xsl:stylesheet version="1.0" 
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:doc="http://nwalsh.com/xsl/documentation/1.0"
		xmlns:exsl="http://exslt.org/common"
		xmlns:set="http://exslt.org/sets"
		exclude-result-prefixes="doc exsl set">
	<xsl:import href="file:///home/mw/docbook-xsl-1.60.1/htmlhelp/htmlhelp.xsl"/>
	<!-- here come the variables ... -->
	<xsl:param name="use.id.as.filename" select="'1'"/>
	<xsl:param name="section.autolabel" select="'1'"/>
	<xsl:param name="section.label.includes.component.label" select="'1'"/>
	<xsl:param name="chunk.first.sections" select="'1'"/>

	<xsl:param name="chunk.section.depth" select="'3'"/>

	<!--	<xsl:param name="use.extensions" select="'1'"/> -->
	<xsl:param name="suppress.navigation" select="'0'"/>
	<xsl:param name="htmlhelp.autolabel" select="'1'"/>
	<xsl:param name="htmlhelp.chm" select="'tex-refs.chm'"/>
	<xsl:param name="htmlhelp.hhp" select="'tex-refs.hhp'"/>
	<xsl:param name="htmlhelp.hhc" select="'tex-refs.hhc'"/>
	<xsl:param name="htmlhelp.hhp.tail"/>
	<xsl:param name="htmlhelp.enumerate.images" select="'1'"/>
	<!-- my own -->
	<xsl:param name="htmlhelp.hhk.autocreate" select="'1'"/>
	<xsl:param name="htmlhelp.hhk" select="'tex-refs.hhk'"/>

        <xsl:param name="htmlhelp.fulltextsearch" select="'Yes'"/>

	<!--	<xsl:param name="base.dir" select="'out/htmlhelp/'"/> -->
	<!-- ==================================================================== -->
	<!-- Overridden templates -->
	<!-- ==================================================================== -->
	<!-- The entry point (stolen from htmlhelp.xsl and customized) -->
	<xsl:template match="/">
		<xsl:choose>
			<xsl:when test="$rootid != ''">
				<xsl:choose>
					<xsl:when test="count(key('id',$rootid)) = 0">
						<xsl:message terminate="yes">
							<xsl:text>ID '</xsl:text>
							<xsl:value-of select="$rootid"/>
							<xsl:text>' not found in document.</xsl:text>
						</xsl:message>
					</xsl:when>
					<xsl:otherwise>
						<xsl:message>Formatting from <xsl:value-of select="$rootid"/>
						</xsl:message>
						<xsl:apply-templates select="key('id',$rootid)" mode="process.root"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="/" mode="process.root"/>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:call-template name="hhp"/>
		<xsl:call-template name="hhc"/>
		<!-- start new -->
		<xsl:choose>
			<xsl:when test="$htmlhelp.hhk.autocreate != 0">
				<xsl:call-template name="hhk"/>
			</xsl:when>
		</xsl:choose>
		<!-- end new -->
		<xsl:if test="($rootid = '' and //processing-instruction('dbhh')) or
                ($rootid != '' and key('id',$rootid)//processing-instruction('dbhh'))">
			<xsl:call-template name="hh-map"/>
			<xsl:call-template name="hh-alias"/>
		</xsl:if>
	</xsl:template>
<!-- ==================================================================== -->
<!-- overridden template from htmlhelp.xsl-->
<xsl:template name="hhp-main">
<xsl:text>[OPTIONS]
</xsl:text>
<xsl:if test="//indexterm">
<xsl:text>Auto Index=Yes
</xsl:text></xsl:if>
<xsl:text>Compatibility=1.1 or later
Compiled file=</xsl:text><xsl:value-of select="$htmlhelp.chm"/><xsl:text>
Contents file=</xsl:text><xsl:value-of select="$htmlhelp.hhc"/>
<!-- that's new -->
<xsl:if test="$htmlhelp.hhk.autocreate != 0">
	<xsl:text>
Index file=</xsl:text><xsl:value-of select="$htmlhelp.hhk"/>
</xsl:if>
<!-- end of new -->
<xsl:text>
Default topic=</xsl:text>
<xsl:choose>
  <xsl:when test="$htmlhelp.default.topic != ''">
    <xsl:value-of select="$htmlhelp.default.topic"/>
  </xsl:when>
  <xsl:otherwise>
    <xsl:call-template name="make-relative-filename">
      <xsl:with-param name="base.dir" select="$base.dir"/>
      <xsl:with-param name="base.name">
        <xsl:choose>
          <xsl:when test="$rootid != ''">
            <xsl:apply-templates select="key('id',$rootid)" mode="chunk-filename"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:apply-templates select="/" mode="chunk-filename"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:otherwise>
</xsl:choose>
<xsl:text>
Display compile progress=No
Full-text search=</xsl:text><xsl:value-of select="$htmlhelp.fulltextsearch"/>
<xsl:text>
Language=</xsl:text>
<xsl:if test="//@lang">
  <xsl:variable name="lang" select="//@lang[1]"/>
  <xsl:value-of select="document('langcodes.xml')//gentext[@lang=string($lang)]"/>
</xsl:if>
<xsl:if test="not(//@lang)">
  <xsl:text>0x0409 English (United States)</xsl:text>
</xsl:if>
<xsl:text>
Title=</xsl:text>
  <xsl:choose>
    <xsl:when test="$htmlhelp.title = ''">
      <xsl:choose>
        <xsl:when test="$rootid != ''">
          <xsl:apply-templates select="key('id',$rootid)" mode="title.markup"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:apply-templates select="/*" mode="title.markup"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="$htmlhelp.title"/>
    </xsl:otherwise>
  </xsl:choose>
<xsl:text>

[FILES]
</xsl:text>

<xsl:choose>
  <xsl:when test="$rootid != ''">
    <xsl:apply-templates select="key('id',$rootid)" mode="enumerate-files"/>
  </xsl:when>
  <xsl:otherwise>
    <xsl:apply-templates select="/" mode="enumerate-files"/>
  </xsl:otherwise>
</xsl:choose>

<xsl:if test="$htmlhelp.enumerate.images">
  <xsl:variable name="imagelist">
    <xsl:choose>
      <xsl:when test="$rootid != ''">
        <xsl:apply-templates select="key('id',$rootid)" mode="enumerate-images"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates select="/" mode="enumerate-images"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:choose>
    <xsl:when test="function-available('exsl:node-set') and function-available('set:distinct')">
      <xsl:for-each select="set:distinct(exsl:node-set($imagelist)/filename)">
        <xsl:value-of select="."/>
        <xsl:text>&#10;</xsl:text>
      </xsl:for-each>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="$imagelist"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:if>

<xsl:if test="($htmlhelp.force.map.and.alias != 0) or 
              ($rootid = '' and //processing-instruction('dbhh')) or
              ($rootid != '' and key('id',$rootid)//processing-instruction('dbhh'))">
  <xsl:text>
[ALIAS]
#include </xsl:text><xsl:value-of select="$htmlhelp.alias.file"/><xsl:text>

[MAP]
#include </xsl:text><xsl:value-of select="$htmlhelp.map.file"/><xsl:text>
</xsl:text>
</xsl:if>

<xsl:value-of select="$htmlhelp.hhp.tail"/>
</xsl:template>

	<!-- ==================================================================== -->
	<!-- create the hhk-file -->
	<xsl:template name="hhk">
		<xsl:call-template name="write.text.chunk">
			<xsl:with-param name="filename" select="$htmlhelp.hhk"/>
			<xsl:with-param name="method" select="'text'"/>
			<xsl:with-param name="content">
				<xsl:call-template name="hhk-main"/>
			</xsl:with-param>
			<xsl:with-param name="encoding" select="$htmlhelp.encoding"/>
		</xsl:call-template>
	</xsl:template>
	<!-- ==================================================================== -->
	<!-- create the content of the hhk-file -->
	<xsl:template name="hhk-main">
		<xsl:text>&lt;HTML&gt;
&lt;HEAD&gt;
&lt;/HEAD&gt;
&lt;BODY&gt;
&lt;UL&gt;</xsl:text>
		<xsl:choose>
			<xsl:when test="$rootid != ''">
				<xsl:apply-templates select="key('id',$rootid)" mode="hhk"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="." mode="hhk"/>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:text>
&lt;/UL&gt;
&lt;/BODY&gt;
&lt;/HTML&gt;</xsl:text>
	</xsl:template>
	<!-- ==================================================================== -->
	<xsl:template match="*" mode="hhk">
		<xsl:call-template name="generate-index"/>
	</xsl:template>
	<!-- ==================================================================== -->
	<!-- This code is based on code found in 'autoidx.xsl' and 'htmlhelp.xsl' - parts of the 
	original DocBook XSL-Stylesheets. Original comment from there:
	Jeni Tennison gets all the credit for what follows.
     I think I understand it :-) Anyway, I've hacked it a bit, so the
     bugs are mine. -->
	<xsl:key name="hhk.letter" match="indexterm" use="translate(substring(&primary;, 1, 1),&lowercase;,&uppercase;)"/>
	<xsl:key name="hhk.primary" match="indexterm" use="&primary;"/>
	<xsl:key name="hhk.secondary" match="indexterm" use="concat(&primary;, &sep;, &secondary;)"/>
	<xsl:key name="hhk.tertiary" match="indexterm" use="concat(&primary;, &sep;, &secondary;, &sep;, &tertiary;)"/>
	<xsl:key name="hhk.primary-section" match="indexterm[not(secondary) and not(see)]" use="concat(&primary;, &sep;, &section.id;)"/>
	<xsl:key name="hhk.secondary-section" match="indexterm[not(tertiary) and not(see)]" use="concat(&primary;, &sep;, &secondary;, &sep;, &section.id;)"/>
	<xsl:key name="hhk.tertiary-section" match="indexterm[not(see)]" use="concat(&primary;, &sep;, &secondary;, &sep;, &tertiary;, &sep;, &section.id;)"/>
	<xsl:key name="hhk.see-also" match="indexterm[seealso]" use="concat(&primary;, &sep;, &secondary;, &sep;, &tertiary;, &sep;, seealso)"/>
	<xsl:key name="hhk.see" match="indexterm[see]" use="concat(&primary;, &sep;, &secondary;, &sep;, &tertiary;, &sep;, see)"/>
	<xsl:key name="hhk.sections" match="*[@id]" use="@id"/>
	<!-- ................................................................................................................ -->
	<xsl:template name="generate-index">
		<!-- select all indexterm entries -->
		<xsl:variable name="terms" select="//indexterm"/>
		<!-- Which nodes are selected by the following statement?
	&primary;
		... this is the primary element of an indexterm (in sort order)
	 translate(substring(&primary;, 1, 1),&lowercase;,&uppercase;):
		... this translates the first letter to uppercase 
	key('hhk.letter',translate(...))[1]:
		... the first of the nodeset with the same start letter (if used in the context of an indexterm element)
	count(.|key(...)[1]) = 1
		... nodes which are the same as the first entry of the 'key-nodeset' (union of the current and the first node of the key-nodeset)
	//indexterm[count(.|key(...)[1]) = 1]
		indexterms which has this property (one indexterm for every letter, without unused letters) -->
		<!-- select terms (one element for every primary-keyword = no repetition) -->
		<xsl:apply-templates select="$terms[count(.|key('hhk.primary',&primary;)[1]) = 1]" mode="index-primary">
			<xsl:sort select="&primary;"/>
		</xsl:apply-templates>
	</xsl:template>
	<!-- ................................................................................................................ -->
	<!-- handle the primary element-->
	<xsl:template match="indexterm" mode="index-primary">
		<!-- one keyword -->
		<xsl:variable name="key" select="&primary;"/>
		<!-- all indexerms whose primary element match the keyword -->
		<xsl:variable name="refs" select="key('hhk.primary', $key)"/>
		<xsl:variable name="iterms-only-prim" select="$refs[generate-id() = generate-id(key('hhk.primary-section', concat($key, &sep;, &section.id;))[1])]"/>
		<!-- 1. create here an index entry only for indexterms without secondary entry -->
		<xsl:for-each select="$iterms-only-prim">
			<!-- create following html source code 
			<LI><OBJECT type="text/sitemap">
				<param name="Name" value="...">
				<param name="Local" value="...">
			-->
			<xsl:text>
	&lt;LI&gt; &lt;OBJECT type="text/sitemap"&gt;
		&lt;param name="Name" value="</xsl:text>
			<xsl:value-of select="normalize-space(primary)"/>
			<xsl:text>"&gt;</xsl:text>
			<xsl:text>
		&lt;param name="Local" value="</xsl:text>
			<xsl:apply-templates select="." mode="reference"/>
			<xsl:text>"&gt;
	&lt;/OBJECT&gt;</xsl:text>
		</xsl:for-each>
		<!-- 2. if there are secondary, see or seealso elements then build an index entry and a 
		list for the sub entries -->
		<xsl:if test="$refs/secondary or $refs/*[not(secondary) and (self::see or self::seealso)]">
			<!-- 2a. a "blind" entry
			BUT if there was written entries for primary, we don't need this-->
			<xsl:if test="not($iterms-only-prim)">
				<xsl:text>
	&lt;LI&gt; &lt;OBJECT type="text/sitemap"&gt;
		&lt;param name="Name" value="</xsl:text>
				<xsl:value-of select="normalize-space(primary)"/>
				<xsl:text>"&gt;
		&lt;param name="See Also" value="</xsl:text>
				<xsl:value-of select="normalize-space(primary)"/>
				<xsl:text>"&gt;
	&lt;/OBJECT&gt;</xsl:text>
			</xsl:if>
			<!-- 2b. open the ul-list -->
			<xsl:text>
	&lt;UL&gt;</xsl:text>
			<!-- 2c.  the entries for the see elements (there may be more than one) -->
			<xsl:apply-templates select="$refs[generate-id() = generate-id(key('hhk.see', concat(&primary;, &sep;, &sep;, &sep;, see))[1])]" mode="index-see">
				<xsl:sort select="see"/>
			</xsl:apply-templates>
			<!-- 2d.the entries for the seealso elements (there may be more than one) -->
			<xsl:apply-templates select="$refs[generate-id() = generate-id(key('hhk.see-also', concat(&primary;, &sep;, &sep;, &sep;, seealso))[1])]" mode="index-seealso">
				<xsl:sort select="seealso"/>
			</xsl:apply-templates>
			<!-- 2e. the entries for the secondary elements (there may be more than one and may have childs) -->
			<xsl:apply-templates select="$refs[secondary and count(.|key('hhk.secondary', concat($key, &sep;, &secondary;))[1]) = 1]" mode="index-secondary">
				<xsl:sort select="&secondary;"/>
			</xsl:apply-templates>
			<!-- 2f. close the ul-list -->
			<xsl:text>
	&lt;/UL&gt;</xsl:text>
		</xsl:if>
	</xsl:template>
	<!-- ................................................................................................................ -->
	<!-- handle the secondary element-->
	<xsl:template match="indexterm" mode="index-secondary">
		<xsl:variable name="key" select="concat(&primary;, &sep;, &secondary;)"/>
		<xsl:variable name="refs" select="key('hhk.secondary', $key)"/>
		<xsl:variable name="iterms-only-sec" 
					select="$refs[generate-id() = generate-id(key('hhk.secondary-section', concat($key, &sep;, &section.id;))[1])]"/>
		<!-- 1.  -->
		<xsl:for-each select="$iterms-only-sec">
			<xsl:text>
		&lt;LI&gt; &lt;OBJECT type="text/sitemap"&gt;
			&lt;param name="Name" value="</xsl:text>
			<xsl:value-of select="normalize-space(secondary)"/>
			<xsl:text>"&gt;
			&lt;param name="Local" value="</xsl:text>
			<xsl:apply-templates select="." mode="reference"/>
			<xsl:text>"&gt;
		&lt;/OBJECT&gt;</xsl:text>
		</xsl:for-each>
		<!-- 2.  -->
		<xsl:if test="$refs/tertiary or $refs[not(tertiary)]/*[self::see or self::seealso]">
		<!-- 2a.  -->
			<!--  -->
			<xsl:if test="not($iterms-only-sec)">
				<xsl:text>
		&lt;LI&gt; &lt;OBJECT type="text/sitemap"&gt;
			&lt;param name="Name" value="</xsl:text>
				<xsl:value-of select="normalize-space(secondary)"/>
				<xsl:text>"&gt;
			&lt;param name="See Also" value="</xsl:text>
				<xsl:value-of select="normalize-space(primary)"/>
				<xsl:text>, </xsl:text>
				<xsl:value-of select="normalize-space(secondary)"/>
				<xsl:text>"&gt;
		&lt;/OBJECT&gt;</xsl:text>
			</xsl:if>
		<!-- 2b. open the ul-list -->
			<xsl:text>
		&lt;UL&gt;</xsl:text>
		<!-- 2c.  -->
			<xsl:apply-templates select="$refs[generate-id() = generate-id(key('hhk.see', concat(&primary;, &sep;, &secondary;, &sep;, &sep;, see))[1])]" mode="index-see">
				<xsl:sort select="see"/>
			</xsl:apply-templates>
		<!-- 2d.  -->
			<xsl:apply-templates select="$refs[generate-id() = generate-id(key('hhk.see-also', concat(&primary;, &sep;, &secondary;, &sep;, &sep;, seealso))[1])]" mode="index-seealso">
				<xsl:sort select="seealso"/>
			</xsl:apply-templates>
		<!-- 2e.  -->
			<xsl:apply-templates select="$refs[tertiary and count(.|key('hhk.tertiary', concat($key, &sep;, &tertiary;))[1]) = 1]" mode="index-tertiary">
				<xsl:sort select="&tertiary;"/>
			</xsl:apply-templates>
		<!-- 2f.  -->
			<xsl:text>
		&lt;/UL&gt;</xsl:text>
		</xsl:if>
	</xsl:template>
	<!-- ................................................................................................................ -->
	<!-- handle the tertiary element-->
	<xsl:template match="indexterm" mode="index-tertiary">
		<xsl:variable name="key" select="concat(&primary;, &sep;, &secondary;, &sep;, &tertiary;)"/>
		<xsl:variable name="refs" select="key('hhk.tertiary', $key)"/>
		<xsl:variable name="iterms-only-ter" 
					select="$refs[generate-id() = generate-id(key('hhk.tertiary-section', concat($key, &sep;, &section.id;))[1])]"/>
		<!-- 1.  -->
		<xsl:for-each select="$iterms-only-ter">
			<xsl:text>
			&lt;LI&gt; &lt;OBJECT type="text/sitemap"&gt;
				&lt;param name="Name" value="</xsl:text>
			<xsl:value-of select="normalize-space(tertiary)"/>
			<xsl:text>"&gt;
				&lt;param name="Local" value="</xsl:text>
			<xsl:apply-templates select="." mode="reference"/>
			<xsl:text>"&gt;
			&lt;/OBJECT&gt;</xsl:text>
		</xsl:for-each>
		<!-- <xsl:variable name="see" select="$refs/see | $refs/seealso"/> -->
		<!-- 2.  -->
		<xsl:if test="$refs/see | $refs/seealso">
		<!-- 2a.  -->
			<xsl:if test="$iterms-only-ter">
				<xsl:text>
			&lt;LI&gt; &lt;OBJECT type="text/sitemap"&gt;
				&lt;param name="Name" value="</xsl:text>
				<xsl:value-of select="normalize-space(tertiary)"/>
				<xsl:text>"&gt;
				&lt;param name="See Also" value="</xsl:text>
				<xsl:value-of select="normalize-space(primary)"/>
				<xsl:text>, </xsl:text>
				<xsl:value-of select="normalize-space(secondary)"/>
				<xsl:text>, </xsl:text>
				<xsl:value-of select="normalize-space(tertiary)"/>
				<xsl:text>"&gt;
			&lt;/OBJECT&gt;</xsl:text>
			</xsl:if>
		<!-- 2b.  -->
			<xsl:text>
			&lt;UL&gt;</xsl:text>
		<!-- 2c.  -->
			<xsl:apply-templates select="$refs[generate-id() = generate-id(key('hhk.see', concat(&primary;, &sep;, &secondary;, &sep;, &tertiary;, &sep;, see))[1])]" mode="index-see">
				<xsl:sort select="see"/>
			</xsl:apply-templates>
		<!-- 2d.  -->
			<xsl:apply-templates select="$refs[generate-id() = generate-id(key('hhk.see-also', concat(&primary;, &sep;, &secondary;, &sep;, &tertiary;, &sep;, seealso))[1])]" mode="index-seealso">
				<xsl:sort select="seealso"/>
			</xsl:apply-templates>
		<!-- 2f. (there is no 2e because there is no quartary)  -->
			<xsl:text>
			&lt;/UL&gt;</xsl:text>
		</xsl:if>
	</xsl:template>
	<!-- ................................................................................................................ -->
	<!-- print out the target URI for a specified indexterm. -->
	<xsl:template match="indexterm" mode="reference">
		<xsl:choose>
			<xsl:when test="@zone and string(@zone)">
				<xsl:call-template name="reference">
					<xsl:with-param name="zones" select="normalize-space(@zone)"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="href.target">
					<xsl:with-param name="object" select="&section;"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- ................................................................................................................ -->
	<!-- print out the target URI for a specified zone start.
	 i think the zone end brings more trouble then clarification. therefore omitted. -->
	<xsl:template name="reference">
		<xsl:param name="zones"/>
		<xsl:variable name="zone" select="$zones"/>
		<xsl:variable name="target" select="key('hhk.sections', $zone)"/>
		<xsl:call-template name="href.target">
			<xsl:with-param name="object" select="$target[1]"/>
		</xsl:call-template>
	</xsl:template>
	<!-- ................................................................................................................ -->
	<xsl:template match="indexterm" mode="index-see">
		<xsl:text>
	&lt;LI&gt; &lt;OBJECT type="text/sitemap"&gt;
		&lt;param name="Name" value="See: </xsl:text>
		<xsl:value-of select="normalize-space(see)"/>
		<xsl:text>"&gt;
		&lt;param name="See Also" value="</xsl:text>
		<xsl:value-of select="normalize-space(see)"/>
		<xsl:text>"&gt;
&lt;/OBJECT&gt;</xsl:text>
	</xsl:template>
	<!-- ................................................................................................................ -->
	<xsl:template match="indexterm" mode="index-seealso">
		<xsl:for-each select="seealso">
			<xsl:text>
	&lt;LI&gt; &lt;OBJECT type="text/sitemap"&gt;
		&lt;param name="Name" value="See Also: </xsl:text>
			<xsl:value-of select="normalize-space(.)"/>
			<xsl:text>"&gt;
		&lt;param name="See Also" value="</xsl:text>
			<xsl:value-of select="normalize-space(.)"/>
			<xsl:text>"&gt;
	&lt;/OBJECT&gt;</xsl:text>
		</xsl:for-each>
	</xsl:template>
	<!-- ==================================================================== -->
	<!-- override template from htmlhelp.xsl -->
	<xsl:template match="indexterm">
		<xsl:if test="$htmlhelp.hhk.autocreate = 0">
			<xsl:apply-imports />
		</xsl:if>
	</xsl:template>
	<!-- ==================================================================== -->
	<xsl:template name="body.attributes">
		<xsl:attribute name="bgcolor">white</xsl:attribute>
		<xsl:attribute name="text">black</xsl:attribute>
		<xsl:attribute name="link">#0000FF</xsl:attribute>
		<xsl:attribute name="vlink">#840084</xsl:attribute>
		<xsl:attribute name="alink">#0000FF</xsl:attribute>
	</xsl:template>
</xsl:stylesheet>
