/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.ConnectionEvent;
import com.mongodb.ConnectionPoolListenerAdapter;
import com.mongodb.ConnectionPoolOpenedEvent;
import com.mongodb.ConnectionPoolSettings;
import com.mongodb.ConnectionPoolStatisticsMBean;
import com.mongodb.ConnectionPoolWaitQueueEvent;
import com.mongodb.ServerAddress;
import java.util.concurrent.atomic.AtomicInteger;

final class ConnectionPoolStatistics
extends ConnectionPoolListenerAdapter
implements ConnectionPoolStatisticsMBean {
    private final ServerAddress serverAddress;
    private final ConnectionPoolSettings settings;
    private final AtomicInteger size = new AtomicInteger();
    private final AtomicInteger checkedOutCount = new AtomicInteger();
    private final AtomicInteger waitQueueSize = new AtomicInteger();

    public ConnectionPoolStatistics(ConnectionPoolOpenedEvent event) {
        this.serverAddress = event.getServerAddress();
        this.settings = event.getSettings();
    }

    public String getHost() {
        return this.serverAddress.getHost();
    }

    public int getPort() {
        return this.serverAddress.getPort();
    }

    public int getMinSize() {
        return this.settings.getMinSize();
    }

    public int getMaxSize() {
        return this.settings.getMaxSize();
    }

    public int getSize() {
        return this.size.get();
    }

    public int getCheckedOutCount() {
        return this.checkedOutCount.get();
    }

    public int getWaitQueueSize() {
        return this.waitQueueSize.get();
    }

    public void connectionCheckedOut(ConnectionEvent event) {
        this.checkedOutCount.incrementAndGet();
    }

    public void connectionCheckedIn(ConnectionEvent event) {
        this.checkedOutCount.decrementAndGet();
    }

    public void connectionAdded(ConnectionEvent event) {
        this.size.incrementAndGet();
    }

    public void connectionRemoved(ConnectionEvent event) {
        this.size.decrementAndGet();
    }

    public void waitQueueEntered(ConnectionPoolWaitQueueEvent event) {
        this.waitQueueSize.incrementAndGet();
    }

    public void waitQueueExited(ConnectionPoolWaitQueueEvent event) {
        this.waitQueueSize.decrementAndGet();
    }
}

