/*
 * Copyright 1991 - 1994, John F. Haugh II and Chip Rosenthal
 * All rights reserved.
 *
 * Permission is granted to copy and create derivative works for any
 * non-commercial purpose, provided this copyright notice is preserved
 * in all copies of source code, or included in human readable form
 * and conspicuously displayed on all copies of object code or
 * distribution media.
 *
 * This software is provided on an AS-IS basis and the author makes
 * no warrantee of any kind.  The "Artistic License" located in the
 * file LICENSE contains complete licensing information.
 */

#ifndef lint
static	char	sccsid[] = "@(#)tz.c	3.2	20:12:21	08 Feb 1994";
#endif

#include <stdio.h>

extern	char	*getdef_str();

/*
 * tz - return local timezone name
 *
 * Tz() determines the name of the local timezone by reading the
 * contents of the file named by ``fname''.
 */

char *
tz (fname)
char	*fname;
{
	FILE *fp = 0;
	static char tzbuf[BUFSIZ];
	char	*def_tz;

	if ((fp = fopen(fname,"r")) == NULL ||
			fgets (tzbuf, sizeof (tzbuf), fp) == NULL) {
		if (! (def_tz = getdef_str ("ENV_TZ")) || def_tz[0] == '/')
			def_tz = "TZ=CST6CDT";

		strcpy (tzbuf, def_tz);
	} else
		tzbuf[strlen(tzbuf) - 1] = '\0';

	if (fp)
		(void) fclose(fp);

	return tzbuf;
}
