/*
 * Copyright 1990 - 1994, John F. Haugh II
 * All rights reserved.
 *
 * Permission is granted to copy and create derivative works for any
 * non-commercial purpose, provided this copyright notice is preserved
 * in all copies of source code, or included in human readable form
 * and conspicuously displayed on all copies of object code or
 * distribution media.
 *
 * This software is provided on an AS-IS basis and the author makes
 * no warrantee of any kind.  The "Artistic License" located in the
 * file LICENSE contains complete licensing information.
 */

#include <string.h>
#include <stdio.h>
#include "config.h"

#if defined(SHADOWPWD) && defined(NDBM)	/*{*/
#ifndef	lint
static	char	sccsid[] = "@(#)spdbm.c	3.4	20:08:34	08 Feb 1994";
#endif

#include "shadow.h"

#include <ndbm.h>
extern	DBM	*sp_dbm;

/*
 * sp_dbm_update
 *
 * Updates the DBM password files, if they exist.
 */

int
sp_dbm_update (sp)
struct	spwd	*sp;
{
	datum	key;
	datum	content;
	char	data[BUFSIZ];
	int	len;
	static	int	once;

	if (! once) {
		if (! sp_dbm)
			setspent ();

		once++;
	}
	if (! sp_dbm)
		return 0;

	len = spw_pack (sp, data);

	content.dsize = len;
	content.dptr = data;

	key.dsize = strlen (sp->sp_namp);
	key.dptr = sp->sp_namp;
	if (dbm_store (sp_dbm, key, content, DBM_REPLACE))
		return 0;

	return 1;
}

/*
 * sp_dbm_remove
 *
 * Updates the DBM password files, if they exist.
 */

int
sp_dbm_remove (user)
char	*user;
{
	datum	key;
	static	int	once;

	if (! once) {
		if (! sp_dbm)
			setspent ();

		once++;
	}
	if (! sp_dbm)
		return 0;

	key.dsize = strlen (user);
	key.dptr = user;
	if (dbm_delete (sp_dbm, key))
		return 0;

	return 1;
}
#endif	/*} SHADOWPWD && NDBM */
