/*
 * Copyright 1989 - 1994, John F. Haugh II
 * All rights reserved.
 *
 * Permission is granted to copy and create derivative works for any
 * non-commercial purpose, provided this copyright notice is preserved
 * in all copies of source code, or included in human readable form
 * and conspicuously displayed on all copies of object code or
 * distribution media.
 *
 * This software is provided on an AS-IS basis and the author makes
 * no warrantee of any kind.  The "Artistic License" located in the
 * file LICENSE contains complete licensing information.
 */

/*
 * lastlog.h - structure of lastlog file
 *
 *	@(#)lastlog.h	3.1.1.4	12:59:06	26 Feb 1994
 *
 *	This file defines a lastlog file structure which should be sufficient
 *	to hold the information required by login.  It should only be used if
 *	there is no real lastlog.h file.
 */

struct	lastlog	{
	time_t	ll_time;
	char	ll_line[8];
#if defined(SVR4) || defined(__linux__) || defined(SUN4)
	char	ll_host[16];
#endif
};

#ifndef	LASTFILE
#if defined(SVR4) || defined(__linux__)
#define LASTFILE	"/var/adm/lastlog"
#else
#define	LASTFILE	"/usr/adm/lastlog"
#endif
#endif
