/*
 * Copyright 1994, John F. Haugh II
 * All rights reserved.
 *
 * Permission is granted to copy and create derivative works for any
 * non-commercial purpose, provided this copyright notice is preserved
 * in all copies of source code, or included in human readable form
 * and conspicuously displayed on all copies of object code or
 * distribution media.
 *
 * This software is provided on an AS-IS basis and the author makes
 * no warrantee of any kind.  The "Artistic License" located in the
 * file LICENSE contains complete licensing information.
 */

#ifndef	lint
static	char	sccsid[] = "@(#)expiry.c	3.2	11:51:23	26 Feb 1994";
#endif

#include <sys/types.h>
#include <signal.h>
#include <stdio.h>
#include "config.h"
#include "pwd.h"
#ifdef	SHADOWPWD
#include "shadow.h"
#endif

#ifndef	AGING
#if defined(AIX) || defined(SHADOWPWD)
#define	AGING	0
#endif
#endif

#if !defined(SHADOWPWD) && !defined(AGING) /*{*/

/*
 * Not much to do here ...
 */

main ()
{
	exit (0);
}

#else	/*} AGING || SHADOWPWD {*/

/*
 * catch - signal catcher
 */

SIGTYPE
catch (sig)
int	sig;
{
	exit (10);
}

/*
 * usage - print syntax message and exit
 */

void
usage ()
{
	fprintf (stderr, "Usage: expiry { -f | -c }\n");
	exit (10);
}

/* 
 * expiry - check and enforce password expiration policy
 *
 *	expiry checks (-c) the current password expiraction and
 *	forces (-f) changes when required.  It is callable as a
 *	normal user command.
 */

main (argc, argv)
int	argc;
char	**argv;
{
	char	*user;
	struct	passwd	*pwd;
#ifdef	SHADOWPWD
	struct	spwd	*spwd;
#endif

	/* 
	 * Start by disabling all of the keyboard signals.
	 */

	signal (SIGHUP, catch);
	signal (SIGINT, catch);
	signal (SIGQUIT, catch);
#ifdef	SIGTSTP
	signal (SIGTSTP, catch);
#endif

	/*
	 * expiry takes one of two arguments.  The default action
	 * is to give the usage message.
	 */

	if (argc != 2 || (strcmp (argv[1], "-f")  && strcmp (argv[1], "-c")))
		usage ();

	/*
	 * Make sure I am root.  Can't open /etc/shadow without root
	 * authority.
	 */

	if (geteuid () != 0) {
		fprintf (stderr, "%s: WARNING!  Must be set-UID root!\n",
			argv[0]);
		exit (10);
	}

	/*
	 * Get user entries for /etc/passwd and /etc/shadow
	 */

	if (! (pwd = getpwuid (getuid ()))) {
		fprintf (stderr, "unknown user: %s\n", user);
		exit (10);
	}
	user = strdup (pwd->pw_name);
#ifdef	SHADOWPWD
	spwd = getspnam (user);
#endif

	/*
	 * If checking accounts, use agecheck() function.
	 */

	if (strcmp (argv[1], "-c") == 0) {

		/*
		 * Print out number of days until expiration.
		 */

#ifdef	SHADOWPWD
		agecheck (pwd, spwd);
#else
		agecheck (pwd);
#endif

		/*
		 * Exit with status indicating state of account --
		 */

#ifdef	SHADOWPWD
		exit (isexpired (pwd, spwd));
#else
		exit (isexpired (pwd));
#endif
	}

	/*
	 * If forcing password change, use expire() function.
	 */

	if (strcmp (argv[1], "-f") == 0) {

		/*
		 * Just call expire().  It will force the change
		 * or give a message indicating what to do.  And
		 * it doesn't return at all unless the account
		 * is unexpired.
		 */

#ifdef	SHADOWPWD
		expire (pwd, spwd);
#else
		expire (pwd);
#endif
		exit (0);
	}

	/*
	 * Can't get here ...
	 */

	usage ();
}
#endif	/*}*/
