//
// Copyright (C) 1996  Lars Berntzon
//
// Description:
//	Class for handling the creation of columns.
//
extern "C" {
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/AsciiText.h>
}

#include <sadblib.hh>
#include <iostream.h>
#include <xsadb.hh>
#include <Tokenizer.hh>
#include <DBPanel.hh>
#include <DBList.hh>
#include <CreateColumn.hh>
#include <Updateable.hh>

//
// Constructor
//
CreateColumn::CreateColumn(Widget aTopshell, const char *dbName, DBPanel *p) :
    topshell(aTopshell),
    columnNameWidget(0),
    descriptionWidget(0),
    panel(p)
{
    //
    // Make a private copy of the database name.
    //
    databaseName = strdup(dbName);

    top = XtCreatePopupShell(
		    "createColumn",		// Name.
		    transientShellWidgetClass,	// Widget class.
		    topshell,			// Parent.
		    NULL,			// Args.
		    0);				// Num args.

    Widget toplevel = XtCreateManagedWidget(
		    "toplevel",			// Name.
		    boxWidgetClass,		// Widget class.
		    top,			// Parent.
		    NULL,			// Arguments.
		    0);				// Number of arguments.
    
    XtVaCreateManagedWidget(
		    "textLabel",		// Name.
		    labelWidgetClass,		// Widget class.
		    toplevel,			// Parent.
		    0);
    // 
    // And the text.
    //
    columnNameWidget = XtVaCreateManagedWidget(
			"columnName",			// Name.
			asciiTextWidgetClass,		// Widget class.
	  		toplevel,			// Parent.
	  		XtNeditType,
	  		XawtextEdit,
	  		NULL);

    XtVaCreateManagedWidget(
		    "descriptionLabel",		// Name.
		    labelWidgetClass,		// Widget class.
		    toplevel,			// Parent.
		    0);

    descriptionWidget = XtVaCreateManagedWidget(
			"description",			// Name.
			asciiTextWidgetClass,		// Widget class.
	  		toplevel,			// Parent.
	  		XtNeditType,
	  		XawtextEdit,
	  		NULL);


    //
    // Create buttons.
    //
    Widget buttons = XtCreateManagedWidget(
		    "buttons",			// Name.
		    boxWidgetClass,		// Widget class.
		    toplevel,			// Parent.
		    NULL,			// Arguments.
		    0);				// Number of arguments.
    
    Widget ok = XtVaCreateManagedWidget(
			  "ok",				// Name.
			  commandWidgetClass,		// Widget class.
			  buttons,			// Parent.
			  NULL);			// Args.
    XtAddCallback(ok, XtNcallback, hdl_ok, (XtPointer *)this);

    Widget cancel = XtVaCreateManagedWidget(
			  "cancel",			// Name.
			  commandWidgetClass,		// Widget class.
			  buttons,			// Parent.
			  NULL);			// Args.
    XtAddCallback(cancel, XtNcallback, hdl_cancel, (XtPointer *)this);

}

//
// Reset the dbadmin panel.
//
CreateColumn:: ~CreateColumn(void)
{
    if (databaseName) free(databaseName);
    databaseName = 0;
    panel = 0;
}

void
CreateColumn::popup(void)
{
    XtPopup(top, XtGrabNone);
}

void
CreateColumn::popdown(void)
{
    XtPopdown(top);
}

void
CreateColumn::ok(void)
{
    const char *colName;
    const char *desc;
    int rc;

    XtVaGetValues(columnNameWidget, "string", &colName, NULL);
    if (colName == 0 || colName[0] == 0) {
    	cout << "No column name specified\n";
	popdown();
	return;
    }

    XtVaGetValues(descriptionWidget, "string", &desc, NULL);
    if (desc == 0 || desc[0] == 0) {
    	cout << "No description specified\n";
	popdown();
	return;
    }


    SADB &db = dbList[databaseName];

    rc = db.store("description.text", colName, desc);
    if (rc != 0) {
    	cout << "failed to store column description\n";
    	popdown();
    	return;
    }

    //
    // And pop down myself.
    //
    popdown();
    
    //
    // Ask panel to remake itself.
    //
    update();
}

void
CreateColumn::cancel(void)
{
    popdown();
}

//
//---------- Beginning of X11 helper routines -----------------
//

void CreateColumn::hdl_ok(Widget w, XtPointer appData, XtPointer callData)
{
    ((CreateColumn *)appData)->ok();
}

void CreateColumn::hdl_cancel(Widget w, XtPointer appData, XtPointer callData)
{
    ((CreateColumn *)appData)->cancel();
}

//
// History of changes:
// $Log: CreateColumn.cc,v $
// Revision 1.4  1996/09/14 18:33:41  lasse
// Added some things to the TODO and added pargs
//
// Revision 1.3  1996/03/21 18:57:57  lasse
// Backup
//
// Revision 1.2  1996/03/12 19:43:18  lasse
// Checking in from remote.
//
// Revision 1.1  1996/01/22  20:17:22  lasse
// Checking in from mobile
//
//
