//
// Copyright (C) 1996 Lars Berntzon
//
#ifndef _SETLIST_HH
#define _SETLIST_HH
//
// SetList is a set of lists. The set is indexed by a name.
// The set operation adds an entry to a list index by name.
// Otherwise the base class operations are used as is.
//
class SetList : public ListList
{
public:
    Pix set(const char *name, const TextEntry &e)
    {
    	Pix i;
    	for(i = first(); i; next(i))
    	{
    	    if (strcmp(operator()(i).name(), name) == 0) {
    	    	break;
    	    }
    	}
    	if (!i)
    	{
	    i =  append(ListEntry(name));
    	}
    	return operator()(i).list().append(e);
    }
};
#endif

//
// History of changes:
// $Log: SetList.hh,v $
// Revision 1.1  1996/10/20 20:36:27  lasse
// Added
//
//
