#include <sadbconfig.hh>
#include <sadblib.hh>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#include <iostream.h>

//
// Copyright (C) 1995  Lars Berntzon
//
DB *DB::first = NULL;

DB::DB() : next(0), error(0)
{
}

int
DB::ok(void)
{
    return (error == 0);
}

DB::~DB()
{
}

#ifdef USE_NDBM
NDBM::NDBM(const char *fileName, int mode) :
	dbmData(0),
	buf(0),
	bufLen(0)

{
    char tmp[PATH_MAX];
    error = 0;

    // Open database.
    // HACKMARK: what should theese integers be??
    if (mode == 1) {
	//
	// Make sure the file exist.
	//
	sprintf(tmp, "%s.pag", fileName);
	if (access(tmp, F_OK) != 0) {
	    close(open(tmp, O_RDWR | O_CREAT, 0666));
	    sprintf(tmp, "%s.dir", fileName);
	    close(open(tmp, O_RDWR | O_CREAT, 0666));
	}
	dbmData = dbm_open((char *)fileName, O_RDWR, 0666);
    }
    else if (mode == 2) {
	dbmData = dbm_open((char *)fileName, O_RDWR | O_CREAT, 0666);
    }
    else {
	dbmData = dbm_open((char *)fileName, O_RDONLY, 0666);
    }

    if (dbmData == 0) {
    	error = 1;
    }
}

NDBM::~NDBM()
{
    error = 0;
    if (dbmData) {
	dbm_close(dbmData);
    	dbmData = 0;
    }
    if (buf) {
	free(buf);
    	buf = 0;
    }
}

const char *
NDBM::fetch(const char *k)
{
    error = 0;

    datum key;
    datum value;

    key.dptr = (char *)k;
    key.dsize = strlen(k);

    value = dbm_fetch(dbmData, DATUMREF key);
    if (value.dptr == 0) {
	error = 1;
	return NULL;
    }

    //
    // Make sure buf is long enough and
    // save value there, null terminated.
    //
    store_in_buf(value);

    return buf;
}

int
NDBM::store(const char *k, const char *v, Mode mode)
{
    datum key;
    datum value;

    key.dptr = (char *)k;
    key.dsize = strlen(k);

    value.dptr = (char *)v;
    value.dsize = strlen(v);

    error =  dbm_store(dbmData, DATUMREF key, DATUMREF value, mode == insert_t ? DBM_INSERT : DBM_REPLACE);

    return error;
}

int
NDBM::remove(const char *k)
{
    datum key;

    key.dptr = (char *)k;
    key.dsize = strlen(k);

    error =  dbm_delete(dbmData, DATUMREF key);

    return error;
}

const char *
NDBM::firstkey(void)
{
    error = 0;

    datum value = dbm_firstkey(dbmData);

    if (value.dptr == 0) {
	error = 1;
	return NULL;
    }

    //
    // Make sure buf is long enough and
    // save value there, null terminated.
    //
    store_in_buf(value);

    return buf;
}

const char *
NDBM::nextkey(void)
{
    error = 0;

    datum value = dbm_nextkey(dbmData);

    if (value.dptr == 0) {
	error = 1;
	return NULL;
    }

    //
    // Make sure buf is long enough and
    // save value there, null terminated.
    //
    store_in_buf(value);

    return buf;
}

void
NDBM::store_in_buf(datum value)
{
    //
    // Make sure buf is long enough.
    //
    if (bufLen <= value.dsize) {
    	bufLen = value.dsize + 200;
    	if (buf == 0) {
	    buf = (char *)malloc(bufLen);
	} else {
	    buf = (char *)realloc(buf, bufLen);
	}
	if (buf == 0) {
	    cerr << "failed to allocate memory\n";
	    exit(1);
	}
    }
    memcpy(buf, value.dptr, value.dsize);
    buf[value.dsize] = 0;
}

#endif // USE_NDBM

#ifdef USE_GDBM

GDBM::GDBM(const char *fileName, int mode) :
	dbf(0),
	buf(0),
	bufLen(0)
{
    error = 0;

    // Open database.
    switch(mode)
    {
    case 0:
    	mode = GDBM_READER;
    	break;

    case 1:
    	mode = GDBM_WRCREAT;
    	break;

    case 2:
    	mode = GDBM_NEWDB;
    	break;
    }



    dbf = gdbm_open((char *)fileName, 0, mode, 0666, 0);
    if (dbf == 0) {
    	error = 1;
    }
}

GDBM::~GDBM()
{
    error = 0;
    if (dbf) {
	gdbm_close(dbf);
    	dbf = 0;
    }
    if (buf) {
	free(buf);
    	buf = 0;
    }
}

const char *
GDBM::fetch(const char *k)
{
    error = 0;

    datum key;
    datum value;

    key.dptr = (char *)k;
    key.dsize = strlen(k);

    value = gdbm_fetch(dbf, key);
    if (value.dptr == 0) {
	error = 1;
	return NULL;
    }

    //
    // Make sure buf is long enough and
    // save value there, null terminated.
    //
    store_in_buf(value);

    return buf;
}

int
GDBM::store(const char *k, const char *v, Mode mode)
{
    datum key;
    datum value;

    key.dptr = (char *)k;
    key.dsize = strlen(k);

    value.dptr = (char *)v;
    value.dsize = strlen(v);

    error =  gdbm_store(dbf,
    			key,
    			value,
    			(mode == insert_t) ? GDBM_INSERT : GDBM_REPLACE);
    if (error < 0) {
    	cerr << gdbm_strerror(gdbm_errno) << endl;
    }

    return error < 0;
}

int
GDBM::remove(const char *k)
{
    datum key;

    key.dptr = (char *)k;
    key.dsize = strlen(k);

    error =  gdbm_delete(dbf, key);

    return error;
}

const char *
GDBM::firstkey(void)
{
    error = 0;

    datum value = gdbm_firstkey(dbf);
    prev_key = value;

    if (value.dptr == 0) {
	error = 1;
	return NULL;
    }

    //
    // Make sure buf is long enough and
    // save value there, null terminated.
    //
    store_in_buf(value);

    return buf;
}

const char *
GDBM::nextkey(void)
{
    error = 0;

    datum value = gdbm_nextkey(dbf, prev_key);

    if (value.dptr == 0) {
	error = 1;
	return NULL;
    }

    prev_key = value;

    //
    // Make sure buf is long enough and
    // save value there, null terminated.
    //
    store_in_buf(value);

    return buf;
}

void
GDBM::store_in_buf(datum value)
{
    //
    // Make sure buf is long enough.
    //
    if (bufLen <= value.dsize) {
    	bufLen = value.dsize + 200;
    	if (buf == 0) {
	    buf = (char *)malloc(bufLen);
	} else {
	    buf = (char *)realloc(buf, bufLen);
	}
	if (buf == 0) {
	    cerr << "failed to allocate memory\n";
	    exit(1);
	}
    }
    memcpy(buf, value.dptr, value.dsize);
    buf[value.dsize] = 0;
}

#endif // USE_GDBM

//
// History of changes:
// -------------------
// $Log: DB.cc,v $
// Revision 1.19  1996/09/14 18:33:30  lasse
// Added some things to the TODO and added pargs
//
// Revision 1.18  1996/07/30 20:41:17  lasse
// corrected bug with GDBM databases.
//
// Revision 1.17  1996/01/22  20:17:21  lasse
// Checking in from mobile
//
// Revision 1.16  1995/10/22  22:18:03  lasse
// Backup
//
// Revision 1.15  1995/09/23  13:46:04  lasse
// Imported from remote
//
// Revision 1.1.1.1  1995/09/11  09:23:00  qdtlarb
// THis is version 0.6
//
// Revision 1.14  1995/09/10  20:43:21  lasse
// Added copyright everywhere
//
// Revision 1.13  1995/09/10  19:03:39  lasse
// Corrected removed Log keyword
//
// Revision 1.2  1995/07/19  14:09:27  qdtlarb
// Solaris modifications
//
// Revision 1.1.1.1  1995/07/17  07:51:29  qdtlarb
// Original V0_3
//
// Revision 1.11  1995/07/16  16:27:08  lasse
// Backup
//
//
// revision 1.10 date: 1995/07/16 16:19:33   author: lasse
// sahostinfo a whole lot better.
//
// revision 1.9 date: 1995/07/16 13:42:25   author: lasse
// removed merging differences
//
// revision 1.8 date: 1995/07/05 17:32:23;  author: lasse
// branches:  1.8.2;
//
// added environment variable SADBDIR
// revision 1.7 date: 1995/06/13 10:31:18   author: lasse
//
// fixed bug with store
// revision 1.6 date: 1995/05/13 16:23:14   author: lasse
//
// It was the stupid free of DBM-data that did it. phew
// revision 1.5 date: 1995/05/13 15:55:38   author: lasse
//
// backup
// revision 1.4 date: 1995/05/12 11:21:47   author: lasse
//
// added support for gdbm
// revision 1.3 date: 1995/05/09 19:41:56   author: lasse
//
// backup
// revision 1.2 date: 1995/05/09 19:25:07   author: lasse
//
// Backup
// revision 1.1 date: 1995/05/02 22:18:18   author: lasse

