//
// Copyright (C) 1995  Lars Berntzon
//
#ifndef _SADBCMD_HH
#define _SADBCMD_HH
#include <stdio.h>

class List;
class SADB;

//
// Output mode for the sadbcmd command.
//
typedef enum {normal, shell, semi, export } OutputMode;

extern void sadb_usage(SADB &database);
extern const char *strupper(const char *str);
extern void show_entries(ListList &entries,
			 TextList &showList,
			 int singleMachine,
			 int unique,
			 OutputMode mode,
			 FILE *out);
char *shell_escape(const char *str);
char *quote_escape(const char *str);

extern char *prog;

#endif // _SADBCMD_HH

//
// History of changes:
// $Log: sadbcmd.hh,v $
// Revision 1.11  1997/03/18 20:13:56  lasse
// Created quote_escape.cc
//
// Revision 1.10  1996/09/14 18:33:28  lasse
// Added some things to the TODO and added pargs
//
// Revision 1.9  1995/09/23  13:46:03  lasse
// Imported from remote
//
// Revision 1.1.1.1  1995/09/11  09:22:59  qdtlarb
// THis is version 0.6
//
// Revision 1.8  1995/09/10  20:43:16  lasse
// Added copyright everywhere
//
// Revision 1.7  1995/09/10  19:03:37  lasse
// Corrected removed Log keyword
//
