#!/bin/sh
#
# Copyright (C) 1997 Lars Berntzon
#
##################################################################
#
#		M A C H I N E S . S H
#		---------------------
# Description:
#	Script for searching in the machines database via a WWW interface.
#	This script must be in a http-server cgi directory.
#
# By:
#	Lars Olsson and modified Lars Berntzon
#
#
# Ident:
#	$Header: /home/lasse/.CVSROOT/src/satools/contrib/www/machines.sh,v 1.1 1997/07/18 21:10:30 lasse Exp $
#
#
##################################################################
SAHOME=/EDIT PATH TO SA HOME HERE
PATH=$PATH:$SABINDIR/bin
export PATH SABINDIR SAHOME


if [ -n "$QUERY_STRING" ]; then
	eval `echo $QUERY_STRING | sed -e 's/'"'"'/%27/g' -e 's/%2F/\//g' -e 's/%3A/:/g' -e 's/%5C/\\\/g' -e 's/%E5/\/g' -e 's/%E4/\/g' -e 's/%F6/\/g' -e 's/%C5/\/g' -e 's/%C4/\/g' -e 's/%D6/\/g' -e 's/%5B/\[/g' -e 's/%5D/\]/g' -e 's/%5E/\^/g' -e 's/+/ /g' | \
     awk 'BEGIN{RS="&";FS="="}
		      $1~/^[a-zA-Z][a-zA-Z0-9_]*$/ {
		      printf "QS_%s=%c%s%c\n",$1,39,$2,39}' `
fi

# Build the page...

cat << EOM
Content-type: text/html; level=3

EOM

# Make the HTML

#### Main

echo "<HTML>"
echo "<HEAD>"
echo "<TITLE>Machine list</TITLE>"
echo "</HEAD>"
echo "<BODY BGCOLOR="#FFFFFF">"
echo "<TABLE BORDER="1" CELLPADDING="5">"
echo "<CENTER><FONT SIZE=+1><B>Machines Report</B></FONT></CENTER>"
echo "<BR>"

#
#	Generate list
#	-------------

# Get all match columns.
match_columns="`set | sed -e '/^QS_match_.*=/!d' -e 's/=.*//'  -e 's/QS_match_//'`"
lista=""
for m in $match_columns
do
    value="`eval echo \\\$QS_match_$m`"
    if [ -n "$value" ]; then
	lista="`machines -show $m $lista | awk '$2 ~ /'"$value"'/{print $1}'`"
    fi
done
lista="`machines -exist true $lista`"

#
# Check to see which columns to show.
#
COLS=""
show_0=key
for c in show_0 QS_show_1 QS_show_2 QS_show_3 QS_show_4 QS_show_5 QS_show_6
do
    column_name=`eval echo \\\$$c`
    if [ -n "$column_name" ]; then
	COLS="$COLS `echo $column_name | tr a-z A-Z`"
	show_switch="$show_switch -show $column_name"
    fi
done

ROWBOLD="<B>"
ROWUNBOLD="</B>"
for NAME in description.text `echo $lista | tr ' ' '\012' | sort` ; do
	eval `machines -shell -show key_date $show_switch "$NAME"`
	echo "<TR>"
	BOLD="<B>"
	UNBOLD="</B>"
	for C in $COLS
	do
	    eval echo "\"<TD ALIGN=LEFT VALIGN=TOP>$BOLD\$$C$UNBOLD</TD>\""
	    BOLD="$ROWBOLD"
	    UNBOLD="$ROWUNBOLD"
	done
	echo "</TR>"
	ROWBOLD=""
	ROWUNBOLD=""
done

echo "</TABLE>"
echo "<BR>"
antal=`echo $lista | wc -w`
echo "Number of machines matched: $antal"
echo "<br>"
echo "Report generated: `date '+%Y-%m-%d %H:%M:%S'`"
echo "</BODY>"
echo "</HTML>"

exit 0

#
# History of changes:
# $Log: machines.sh,v $
# Revision 1.1  1997/07/18 21:10:30  lasse
# Created
#
#
