/** \file util.h - headers for utility functions
 * \author Matthias Andree
 * \copyright 2025. GPLv2+
 */

#ifndef FM_UTIL_H
#define FM_UTIL_H

#include <assert.h>
#include <stdbool.h>
#include <stddef.h>

#ifdef __cplusplus
extern "C" {
#endif

/* util.c */
/** This function will use \ref strtok_r to thread-safely split the writable
 * string \a str (writing \0 characters into it)
 * according to any of the delimiter characters in the string \a delim,
 * place the resulting pointer into \a outarray
 * and extract at most \a maxsplit components. \a maxsplit must not be larger than the amount of character pointers in \a outarray.
 * If there are fewer delimiters in the input string, it will
 * write a NULL pointer into array. \returns number of splits, i. e. number of time strtok_r returned a pointer. May be 0 if delim isn't found.
 */
size_t str_split(char *str /** input string. Must not be NULL, and must be writable because strtok_r needs to embed \0 characters. */,
        const char *delim /** delimiters, passed to strtok_r verbatim */,
        char *outarray[] /** output array */,
        size_t maxsplit /** maximum number of components, must not be larger than number of elements in \a outarray */,
        char **remainder /** If non-NULL, copies the pointer to the remainder of the string to \a *remainder. */);

/** This function checks if \a str begins with \a prefix. \return true if it does. */
bool str_startswith(const char *str /** string to check for \a prefix */, 
        const char *prefix /** prefix of string to check */);


#ifdef __cplusplus
}
#endif

#endif
