/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_brx extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "आराबिक";
        final String metaValue_hy = "आर्मेनियान";
        final String metaValue_ae = "अवस्तन्";
        final String metaValue_bn = "बांला";
        final String metaValue_ccp = "चाकमा";
        final String metaValue_ka = "जर्जियान";
        final String metaValue_el = "ग्रीक";
        final String metaValue_gu = "गुजराती";
        final String metaValue_ja = "जापानीज";
        final String metaValue_km = "ख्मेर";
        final String metaValue_la = "लेटीन";
        final String metaValue_mn = "मंगलियान";
        final String metaValue_MM = "म्यानमार";
        final String metaValue_nqo = "नंक’";
        final String metaValue_ta = "तामिल";
        final String metaValue_te = "तेलुगु";
        final String metaValue_th = "थाई";
        final String metaValue_vai = "भाई";
        final Object[][] data = new Object[][] {
            { "001", "बुहुम" },
            { "002", "आफ्रिका" },
            { "003", "साहा आमेरिका" },
            { "005", "खोला आमेरिका" },
            { "009", "ओशेआनिया" },
            { "011", "सोनाबारि आफ्रिका" },
            { "013", "मिरु आमेरिका" },
            { "014", "सानजायारि आफ्रिका" },
            { "015", "साहायारि आफ्रिका" },
            { "017", "गेजेरारि आफ्रिका" },
            { "018", "खोलायारि आफ्रिका" },
            { "019", "आमेरिकानि" },
            { "021", "साहायारि आमेरिका" },
            { "029", "केरिबियान" },
            { "030", "सानजायारि एसिया" },
            { "034", "खोलायारि एसिया" },
            { "035", "खोला-सानजा एसिया" },
            { "039", "खोलायारि यूरोप" },
            { "053", "अस्ट्रेलएसिया" },
            { "054", "मेलानेसिया" },
            { "057", "माईक्र’नेसियायारि ओनसोल" },
            { "061", "पलिनेसिया" },
            { "142", "एसिया" },
            { "143", "मिरु एसिया" },
            { "145", "सोनाबारि एसिया" },
            { "150", "यूरोप" },
            { "151", "सानजायारि यूरोप" },
            { "154", "साहायारि यूरोप" },
            { "155", "सोनाबारि यूरोप" },
            { "202", "साहारायारि लोब्बा गोनां आफ्रिका" },
            { "419", "लेटीन आमेरिका" },
            { "AC", "एसेनसिअन द्वीप" },
            { "AD", "एन्डर्रा" },
            { "AE", "जथाय आराब एमिरेत" },
            { "AF", "आफगानिस्तान" },
            { "AG", "एन्टिगुआ आरो बारबुडा" },
            { "AI", "एंगुइल्ला" },
            { "AL", "आल्बानिया" },
            { "AM", "आर्मेनिया" },
            { "AO", "आंगला" },
            { "AQ", "एन्टार्कटिका" },
            { "AR", "आर्जेन्टिना" },
            { "AS", "आमेरिकान सामआ" },
            { "AT", "अस्ट्रिया" },
            { "AU", "अस्ट्रेलिया" },
            { "AW", "आरूबा" },
            { "AX", "आलाण्ड द्वीपफोर" },
            { "AZ", "आजेरबाईजान" },
            { "BA", "बसनिया आरो होर्जेगभिना" },
            { "BB", "बारबाड’स" },
            { "BD", "बांलादेश" },
            { "BE", "बेलजियाम" },
            { "BF", "बुर्किना फास’" },
            { "BG", "बुल्गारिया" },
            { "BH", "बाहरैन" },
            { "BI", "बुरूण्डी" },
            { "BJ", "बेनिन" },
            { "BL", "सैन्ट बार्थेलेमी" },
            { "BM", "बारमूडा" },
            { "BN", "ब्रूने" },
            { "BO", "बलिभिया" },
            { "BQ", "केरिबियान नेदारलेण्डस" },
            { "BR", "ब्राजील" },
            { "BS", "बाहामास" },
            { "BT", "भूटान" },
            { "BV", "बूभेट द्वीप" },
            { "BW", "बत्स्वाना" },
            { "BY", "बेलारूस" },
            { "BZ", "बेलिज" },
            { "CA", "केनाडा" },
            { "CC", "कक’स द्वीपफोर" },
            { "CD", "कंग’-किनशासा" },
            { "CF", "मिरु आफ्रिका सुबुंखुंथाय" },
            { "CG", "कंग’- ब्राज्जाभील" },
            { "CH", "सुईजारलेण्ड" },
            { "CI", "कट दिभवेर" },
            { "CK", "कुक द्वीप" },
            { "CL", "चिले" },
            { "CM", "केमेरून" },
            { "CN", "चाइना" },
            { "CO", "कलम्बिया" },
            { "CP", "क्लिप्पार्टन द्वीप" },
            { "CR", "कस्टा रिका" },
            { "CU", "क्यूबा" },
            { "CV", "केप भेर्दे" },
            { "CW", "कुरासाव" },
            { "CX", "ख्रिसमास द्वीपफोर" },
            { "CY", "साइप्रास" },
            { "CZ", "चेखिया" },
            { "DE", "जार्मानी" },
            { "DG", "दियेग’ गार्सिया" },
            { "DJ", "जिबौति" },
            { "DK", "डेनमार्क" },
            { "DM", "दमिनिका" },
            { "DO", "दमिनिकान सुबुंखुंथाय" },
            { "DZ", "आल्जेरिया" },
            { "EA", "किउता आरो मेलिल्ला" },
            { "EC", "एक्वाड’र" },
            { "EE", "एस्ट’निया" },
            { "EG", "ईजिप्त" },
            { "EH", "सोनाबारि साहारा" },
            { "ER", "एरिट्रिया" },
            { "ES", "स्पैन" },
            { "ET", "इथिय’पिया" },
            { "EU", "यूरोपनि जथाय" },
            { "EZ", "यूरो ओनसोल" },
            { "FI", "फिनलेण्ड" },
            { "FJ", "फिजी" },
            { "FK", "फकलेण्ड द्वीपफोर" },
            { "FM", "माइक्रनेशिया" },
            { "FO", "फेर’ द्वीपफोर" },
            { "FR", "फ्रान्स" },
            { "GA", "गाबन" },
            { "GB", "जथाय ब्रिटिश हादोर" },
            { "GD", "ग्रेनादा" },
            { "GE", "जर्जिया" },
            { "GF", "फ्रेन्च गिआना" },
            { "GG", "गोर्नसि" },
            { "GH", "घाना" },
            { "GI", "जिब्राल्टार" },
            { "GL", "ग्रीनलेण्ड" },
            { "GM", "गाम्बिया" },
            { "GN", "गिनीया" },
            { "GP", "ग्वादेल्यूप" },
            { "GQ", "बिसुबारि गिनीया" },
            { "GR", "ग्रीस" },
            { "GS", "खोला जर्जिया आरो खोला सेण्डवीच द्वीपफोर" },
            { "GT", "गुवाटेमाला" },
            { "GU", "गुआम" },
            { "GW", "गिनीया- बिसाऊ" },
            { "GY", "गुयाना" },
            { "HK", "हंकं एस.ए.आर चाइना" },
            { "HM", "होर्द आरो मेकद’नाल्ड द्वीपफोर" },
            { "HN", "हण्डूरास" },
            { "HR", "क्रवेशिया" },
            { "HT", "हाइती" },
            { "HU", "हांगारी" },
            { "IC", "कानारि द्वीपफोर" },
            { "ID", "इण्ड’नेशिया" },
            { "IE", "आयारलेण्ड" },
            { "IL", "इज्राईल" },
            { "IM", "आयोल अफ मेन" },
            { "IN", "भारत" },
            { "IO", "ब्रिटिशनि भारतारि लैथो बाहागो" },
            { "IQ", "ईराक" },
            { "IR", "ईरान" },
            { "IS", "आइसलेण्ड" },
            { "IT", "इटाली" },
            { "JE", "जोर्सि" },
            { "JM", "जामाइका" },
            { "JO", "जर्डान" },
            { "JP", "जापान" },
            { "KE", "केनिया" },
            { "KG", "किर्गीस्तान" },
            { "KH", "कम्ब’डिया" },
            { "KI", "किरिबाती" },
            { "KM", "कम’र’ज" },
            { "KN", "सैन्ट कीत्स आरो नेभिस" },
            { "KP", "साहा करिया" },
            { "KR", "खोला करिया" },
            { "KW", "कुवैत" },
            { "KY", "कैमेन द्वीपफोर" },
            { "KZ", "काजाखस्तान" },
            { "LA", "लाओस" },
            { "LB", "लेबान’न" },
            { "LC", "सैन्ट लुसिया" },
            { "LI", "लिक्तोनस्ताईन" },
            { "LK", "श्रीलंका" },
            { "LR", "लाइबेरिया" },
            { "LS", "लेस’थ’" },
            { "LT", "लिथुआनिया" },
            { "LU", "लाक्जेमबुर्ग" },
            { "LV", "लाटभीया" },
            { "LY", "लीबिया" },
            { "MA", "मरक्क’" },
            { "MC", "मनाक’" },
            { "MD", "मल्ड’भा" },
            { "ME", "मन्टेनेग्र’" },
            { "MF", "सैन्ट मार्तिन" },
            { "MG", "मादागास्कार" },
            { "MH", "मार्शेल द्वीप" },
            { "MK", "साहा मेसेड’निया" },
            { "ML", "माली" },
            { "MM", metaValue_MM },
            { "MN", "मंगलिया" },
            { "MO", "माकाउ एस.ए.आर चाइना" },
            { "MP", "साहायारि मारियाना द्वीप" },
            { "MQ", "मार्तिनिक" },
            { "MR", "माउरिटानिया" },
            { "MS", "मनत्सेरात" },
            { "MT", "माल्टा" },
            { "MU", "मरिसियास" },
            { "MV", "मालदीव" },
            { "MW", "मालावी" },
            { "MX", "मेक्सिक’" },
            { "MY", "मालेशिया" },
            { "MZ", "मजाम्बिक" },
            { "NA", "नामीबिया" },
            { "NC", "निउ केलेडनिया" },
            { "NE", "नाइजेर" },
            { "NF", "नर्फ’क द्वीप" },
            { "NG", "नाइजेरिया" },
            { "NI", "निकारागुआ" },
            { "NL", "नेदारलेण्ड" },
            { "NO", "नरवै" },
            { "NP", "नेपाल" },
            { "NR", "नाउरू" },
            { "NU", "नीयूए" },
            { "NZ", "न्यूजीलेण्ड" },
            { "OM", "ओमान" },
            { "PA", "पानामा" },
            { "PE", "पेरू" },
            { "PF", "फ्रेन्च पलिनेशिया" },
            { "PG", "पापुआ निउ गिनी" },
            { "PH", "फिलीपिन्स" },
            { "PK", "पाकिस्तान" },
            { "PL", "पलेण्ड" },
            { "PM", "सैन्ट. पिएर आरो मिकैलन" },
            { "PN", "पिटकाईर्न द्वीप" },
            { "PR", "पुवेर्ट’ रीक’" },
            { "PS", "पेलेस्ताइननि ओनसोलफोर" },
            { "PT", "पर्तुगाल" },
            { "PW", "पालाऊ" },
            { "PY", "पारागुए" },
            { "QA", "कातार" },
            { "QO", "बायजोआरि असियानिया" },
            { "RE", "रेयूनियन" },
            { "RO", "रमानिया" },
            { "RS", "सार्बिया" },
            { "RU", "रासिया" },
            { "RW", "रूआण्डा" },
            { "SA", "साउदि आराबिया" },
            { "SB", "सल’मन द्वीप" },
            { "SC", "सैशेल्लेस" },
            { "SD", "सूदान" },
            { "SE", "स्वीडेन" },
            { "SG", "सिंंगाप’र" },
            { "SH", "सैन्ट हेलेना" },
            { "SI", "स्ल’भेनिया" },
            { "SJ", "स्भालबार्ड आरो जान मायेन" },
            { "SK", "स्लभाकिया" },
            { "SL", "सियेरा लेओन" },
            { "SM", "सान मेरिन’" },
            { "SN", "सेनेगाल" },
            { "SO", "समालिया" },
            { "SR", "सुरिनाम" },
            { "SS", "खोला सुदान" },
            { "ST", "साऊ तमे आरो प्रिन्सिप" },
            { "SV", "एल साल्भाड’र" },
            { "SX", "सिन्त मार्तेन" },
            { "SY", "सीरिया" },
            { "SZ", "एस्वातिनि" },
            { "TA", "त्रिस्तान दा कुन्हा" },
            { "TC", "तुर्की आरो काईक’ज द्वीपफोर" },
            { "TD", "चाड" },
            { "TF", "फ्रान्सनि खोलायारि बाहागोफोर" },
            { "TG", "टग’" },
            { "TH", "थाइलेण्ड" },
            { "TJ", "ताजिकिस्तान" },
            { "TK", "टकेलाऊ" },
            { "TL", "तिमर-लेस्ते" },
            { "TM", "तुर्कमेनीस्तान" },
            { "TN", "त्युनिशिया" },
            { "TO", "टंगा" },
            { "TR", "तुर्की" },
            { "TT", "त्रिनिडाड आरो तबेग’" },
            { "TV", "तुभालु" },
            { "TW", "ताइवान" },
            { "TZ", "तान्जानिया" },
            { "UA", "यूक्रेन" },
            { "UG", "उगाण्डा" },
            { "UM", "इउ.एस नि बायजोआरि द्वीपफोर" },
            { "UN", "जथाय हादोरफोर" },
            { "US", "जथाय हादोर आमेरिका" },
            { "UY", "ऊरुगुवे" },
            { "UZ", "उजबेकिस्तान" },
            { "VA", "भेटिकान नोगोर" },
            { "VC", "सैन्ट भिन्सेन्ट आरो ग्रेनादीन्स" },
            { "VE", "भेनेजुवेला" },
            { "VG", "ब्रिटिश भार्जिन द्वीपफोर" },
            { "VI", "इउ. एस भार्जिन द्वीपफोर" },
            { "VN", "भियेतनाम" },
            { "VU", "भानुआटु" },
            { "WF", "वालिस आरो फ्युचुना" },
            { "WS", "सामआ" },
            { "XA", "नंखाइ-गारांबोलो" },
            { "XB", "नंखाइ- बिदि" },
            { "XK", "कस’भ’" },
            { "YE", "येमेन" },
            { "YT", "मायत्ते" },
            { "ZA", "खोला आफ्रिका" },
            { "ZM", "जाम्बिया" },
            { "ZW", "जिम्बाब्वे" },
            { "ZZ", "मिथियै ओनसोल" },
            { "ab", "आब्खाजियान" },
            { "ae", metaValue_ae },
            { "af", "आफ्रिकान्स" },
            { "ak", "आकान" },
            { "am", "आम्हारिक" },
            { "an", "आरागनिस" },
            { "ar", metaValue_ar },
            { "as", "असमिया" },
            { "av", "आभारिक" },
            { "ay", "आयमारा" },
            { "az", "आजारबायजानि" },
            { "ba", "बाशकिर" },
            { "be", "बेलारुसियान" },
            { "bg", "बुल्गारियान" },
            { "bi", "बिस्लामा" },
            { "bm", "बाम्बारा" },
            { "bn", metaValue_bn },
            { "bo", "तिब्बती" },
            { "br", "ब्रेट’न" },
            { "bs", "बस्नियान" },
            { "ca", "कातालान" },
            { "ce", "चेचेन" },
            { "ch", "चामोर्रो" },
            { "co", "कर्सिकान" },
            { "cr", "क्री" },
            { "cs", "चैक" },
            { "cu", "चर्च स्लाविक्" },
            { "cv", "चुभास" },
            { "cy", "वैल्श" },
            { "da", "डानिश" },
            { "de", "जार्मान" },
            { "dv", "दीवेही" },
            { "dz", "झंखा" },
            { "ee", "एवे" },
            { "el", metaValue_el },
            { "en", "इंराजी" },
            { "eo", "एस्पेरान्त’" },
            { "es", "स्पेनिश" },
            { "et", "एस्ट’नियान" },
            { "eu", "बास्क" },
            { "fa", "फार्सी" },
            { "ff", "फुलाह" },
            { "fi", "फिन्निस" },
            { "fj", "फिजियान" },
            { "fo", "फेर’वीज" },
            { "fr", "फ्रेन्च" },
            { "fy", "सोनाबारि फ्रिजियान" },
            { "ga", "आईरिश" },
            { "gd", "स्कटिस गैलिक" },
            { "gl", "गेलिसियान" },
            { "gn", "गुआरानी" },
            { "gu", metaValue_gu },
            { "gv", "मेनक्स" },
            { "ha", "हाउसा" },
            { "he", "हिब्रिउ" },
            { "hi", "हिन्दी" },
            { "ho", "हीरी मोटु" },
            { "hr", "क्रवेशियान" },
            { "ht", "हाईटियान क्रिअल" },
            { "hu", "हांगारियान" },
            { "hy", metaValue_hy },
            { "hz", "हेरेर’" },
            { "ia", "ईन्टरलिंग्वा" },
            { "id", "ईण्डनेसियान" },
            { "ie", "ईन्टरलिंग्वे" },
            { "ig", "ईग्ब’" },
            { "ii", "शीचुआन यी" },
            { "ik", "इनुपियाक़्" },
            { "io", "ईड’" },
            { "is", "आइस्लेन्डिक" },
            { "it", "इटालियान" },
            { "iu", "इनुक्टीटुत" },
            { "ja", metaValue_ja },
            { "jv", "जाभानीस" },
            { "ka", metaValue_ka },
            { "kg", "कॉंगो" },
            { "ki", "किकुयु" },
            { "kj", "कुआनयामा" },
            { "kk", "काजाख" },
            { "kl", "कलालीसुत" },
            { "km", metaValue_km },
            { "kn", "कन्नड" },
            { "ko", "करियान" },
            { "kr", "कनुरी" },
            { "ks", "काश्मिरी" },
            { "ku", "कुर्दीश" },
            { "kv", "क’मी" },
            { "kw", "कर्निस" },
            { "ky", "किरगीज" },
            { "la", metaValue_la },
            { "lb", "लाक्जेमबुर्गीश" },
            { "lg", "गान्डा" },
            { "li", "लीम्बुर्गिस" },
            { "ln", "लिंगाला" },
            { "lo", "लाऊ" },
            { "lt", "लिथुवानियान" },
            { "lu", "लुबा-काटाङा" },
            { "lv", "लाटभियान" },
            { "mg", "मालागासी" },
            { "mh", "मार्शेलिस" },
            { "mi", "माऔरि" },
            { "mk", "मेसेड’नियान" },
            { "ml", "मालायालम" },
            { "mn", metaValue_mn },
            { "mr", "माराथी" },
            { "ms", "मलै" },
            { "mt", "माल्टीज" },
            { "my", "बार्मिस" },
            { "na", "नाऊरू" },
            { "nb", "नरवैजियान बकमाल" },
            { "nd", "साहा न्देबेले" },
            { "ne", "नेपाली" },
            { "ng", "न्डोंगा" },
            { "nl", "डात्च" },
            { "nn", "नरवैजियान निनर्स्क" },
            { "no", "नरवैजियान" },
            { "nr", "खोला न्देबेले" },
            { "nv", "नावाहो" },
            { "ny", "न्यान्जा" },
            { "oc", "अक्सितान" },
            { "oj", "ओहीबवा" },
            { "om", "अरम’" },
            { "or", "उरीया" },
            { "os", "अस्सेटीक" },
            { "pa", "पान्जाबी" },
            { "pi", "पाली" },
            { "pl", "पलिश" },
            { "ps", "पाश्त’" },
            { "pt", "पर्टुगिज" },
            { "qu", "क्वेचुआ" },
            { "rm", "रमान्श" },
            { "rn", "रुन्दी" },
            { "ro", "रमानीयान" },
            { "ru", "रासियान" },
            { "rw", "किन्यार्वान्दा" },
            { "sa", "संस्कृत" },
            { "sc", "सार्दीनीयान" },
            { "sd", "सिन्धी" },
            { "se", "साहायारि सामी" },
            { "sg", "साङ’" },
            { "sh", "सर्बो-क्रोएशन्" },
            { "si", "सींहाला" },
            { "sk", "स्ल’भाक" },
            { "sl", "स्लोभेनियान" },
            { "sm", "साम’वान" },
            { "sn", "शना" },
            { "so", "स’माली" },
            { "sq", "आल्बानियान" },
            { "sr", "सार्बियान" },
            { "ss", "स्वाटि" },
            { "st", "खोलायारि सथ’" },
            { "su", "सुन्दानी" },
            { "sv", "स्वीडिश" },
            { "sw", "स्वाहिली" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "ताजिक" },
            { "th", metaValue_th },
            { "ti", "तिग्रीन्या" },
            { "tk", "तुर्कमेन" },
            { "tl", "तागालोग" },
            { "tn", "त्स्वाना" },
            { "to", "टंगान" },
            { "tr", "तुर्कीस" },
            { "ts", "त्संगा" },
            { "tt", "टाटार" },
            { "tw", "ट्वी" },
            { "ty", "टाहीटियान" },
            { "ug", "उईघुर" },
            { "uk", "युक्रेनियान" },
            { "ur", "ऊर्दु" },
            { "uz", "उजबेक" },
            { "ve", "भेन्डा" },
            { "vi", "भियेतनामिस" },
            { "vo", "वोलापोक" },
            { "wa", "वाल्लुन" },
            { "wo", "वल’फ" },
            { "xh", "ख’सा" },
            { "yi", "यीद्दीश" },
            { "yo", "यरूबा" },
            { "za", "ज़ुआंग" },
            { "zh", "चाइनीज" },
            { "zu", "जुलू" },
            { "ace", "एचेनिज" },
            { "ach", "अकोली" },
            { "ada", "एडांगमे" },
            { "ady", "अदिघे" },
            { "afh", "अफ्रीहीली" },
            { "agq", "आघेम" },
            { "ain", "ऐनू" },
            { "akk", "अकाडिनी" },
            { "ale", "आलेउट" },
            { "alt", "खोलायारि आल्टाई" },
            { "ang", "पुरानी अंग्रेज़ी" },
            { "ann", "अबल’" },
            { "anp", "आङिका" },
            { "arc", "अरामाईक" },
            { "arn", "मापुचे" },
            { "arp", "आरापाह’" },
            { "ars", "नाजडी आराबिक" },
            { "arw", "अरावाक" },
            { "asa", "आसु" },
            { "ast", "आस्तुरियान" },
            { "atj", "आतिकामेको" },
            { "awa", "अवधी" },
            { "bal", "बलूची" },
            { "ban", "बालिनिस" },
            { "bas", "बासा" },
            { "bej", "बेजा" },
            { "bem", "बेम्बा" },
            { "bez", "बेना" },
            { "bho", "भजपुरी" },
            { "bik", "बिकोल्" },
            { "bin", "बिनी" },
            { "bla", "सीकसीका" },
            { "bra", "ब्रज" },
            { "brx", "बर’" },
            { "bua", "बुरियात" },
            { "bug", "बुगिनीज" },
            { "byn", "ब्लीन" },
            { "cad", "काद्दौ" },
            { "car", "कारीब्" },
            { "cay", "कायुगा" },
            { "cch", "आत्सम" },
            { "ccp", metaValue_ccp },
            { "ceb", "चेबुआनो" },
            { "cgg", "चीगा" },
            { "chb", "चीबचा" },
            { "chg", "चगताई" },
            { "chk", "चुकेसे" },
            { "chm", "मारि" },
            { "chn", "चीनूक् जार्गन्" },
            { "cho", "चक्टाऊ" },
            { "chp", "चिपेव्यान" },
            { "chr", "चेरकी" },
            { "chy", "चेयेण" },
            { "ckb", "मिरु कुर्दिस" },
            { "clc", "चिल्कटिन" },
            { "cop", "कॉप्टीक्" },
            { "crg", "मिचिफ" },
            { "crh", "तुर्की क्रिमिया" },
            { "crj", "खोलायारि सानजा क्री" },
            { "crk", "हायेनारि क्री" },
            { "crl", "साहायारि सानजा क्री" },
            { "crm", "मूज क्री" },
            { "crr", "केर’लिना एल्गंक्यान" },
            { "csb", "काशुबियान्" },
            { "csw", "स्वाम्पी क्री" },
            { "dak", "डाक’टा" },
            { "dar", "दर्गवा" },
            { "dav", "टाइटा" },
            { "del", "दलावार्" },
            { "den", "स्लेव्" },
            { "dgr", "डोगरीब" },
            { "din", "डींगका" },
            { "dje", "जार्मा" },
            { "doi", "डोगरी" },
            { "dsb", "गाहायसिन सर्बियान" },
            { "dua", "डुआला" },
            { "dum", "मध्य डच" },
            { "dyo", "जला- फन्यी" },
            { "dyu", "द्युआला" },
            { "dzg", "डाजागा" },
            { "ebu", "इम्बु" },
            { "efi", "एफिक" },
            { "egy", "प्राचीन मिस्री" },
            { "eka", "एकाजुक" },
            { "elx", "एलामी" },
            { "enm", "मध्य अंग्रेज़ी" },
            { "ewo", "एव’न्द’" },
            { "fan", "फाँग्" },
            { "fat", "फाँटी" },
            { "fil", "फिलिपिन’" },
            { "fon", "फ’न" },
            { "frc", "काजुन फ्रेन्च" },
            { "frm", "मध्य फ्रांसीसी" },
            { "fro", "पुरानी फ्रांसीसी" },
            { "frr", "उत्तरी फ्रीज़ियन्" },
            { "frs", "पूर्वी फ्रीज़ियन्" },
            { "fur", "फ्रिउलियान" },
            { "gaa", "गा" },
            { "gay", "गायो" },
            { "gba", "ग्बाया" },
            { "gez", "गीज" },
            { "gil", "गील्बर्टिस" },
            { "gmh", "मध्य उच्चस्तरी जर्मन" },
            { "goh", "पुरानी उच्चस्तरी जर्मन" },
            { "gon", "गाँडी" },
            { "gor", "गर’न्टाल’" },
            { "got", "गॉथिक" },
            { "grb", "ग्रेबो" },
            { "grc", "प्राचीन यूनानी" },
            { "gsw", "स्वीस जार्मान" },
            { "guz", "गुशि" },
            { "gwi", "ग्वीचलीन" },
            { "hai", "हाईडा" },
            { "haw", "हावाईयान" },
            { "hax", "खोलायारि हाईडा" },
            { "hil", "हिलीगैन’न" },
            { "hit", "हीत्ती" },
            { "hmn", "ह्मंग" },
            { "hsb", "गोजौआरि सर्बियान" },
            { "hup", "हूपा" },
            { "hur", "हाल्क’मेलेम" },
            { "iba", "ईबान" },
            { "ibb", "ईबिबिय’" },
            { "ikt", "सोनाबारि कानाडियान इनुक्तितुत" },
            { "ilo", "इल’क’" },
            { "inh", "ईंगुष" },
            { "jbo", "ल’जबान" },
            { "jgo", "न्गम्बा" },
            { "jmc", "मेचामे" },
            { "jpr", "यहुदी फ़ारसी" },
            { "jrb", "यहुदी अरबी" },
            { "kaa", "कारा कलपक" },
            { "kab", "काबील" },
            { "kac", "काचीन" },
            { "kaj", "झु" },
            { "kam", "काम्बा" },
            { "kaw", "कावी" },
            { "kbd", "काबार्डीयानि" },
            { "kcg", "त्याप" },
            { "kde", "माक’ण्डे" },
            { "kea", "काबुभेर्डीयानु" },
            { "kfo", "कर’" },
            { "kgp", "काईङां" },
            { "kha", "खासि" },
            { "kho", "ख़ोतानी" },
            { "khq", "कईरा चीनि" },
            { "kkj", "काक’" },
            { "kln", "कालेनजिन" },
            { "kmb", "किम्बुन्डु" },
            { "kok", "कोंकणी" },
            { "kos", "कोस्राईयन्" },
            { "kpe", "क्पेले" },
            { "krc", "कराचय-बलकार" },
            { "krl", "करेलियान" },
            { "kru", "कुरुख" },
            { "ksb", "शामबाला" },
            { "ksf", "बाफिया" },
            { "ksh", "कलगन्यान" },
            { "kum", "कुमीक" },
            { "kut", "कुतेनाई" },
            { "kwk", "क्वाकवाला" },
            { "lad", "लाडीन’" },
            { "lag", "लाङि" },
            { "lah", "लाह्डां" },
            { "lam", "लांबा" },
            { "lez", "लेजघीयान" },
            { "lil", "लिल्लुवेत" },
            { "lkt", "लाक’ता" },
            { "lol", "मोंगो" },
            { "lou", "लुईसियाना क्रेवल" },
            { "loz", "ल’जी" },
            { "lrc", "साहायारि लुरी" },
            { "lsm", "सामीया" },
            { "lua", "लुबा लुलुआ" },
            { "lui", "लुईसेनो" },
            { "lun", "लुण्डा" },
            { "luo", "लुअ’" },
            { "lus", "लुशाई" },
            { "luy", "लुईया" },
            { "mad", "मादुरीज" },
            { "mag", "मगाही" },
            { "mai", "मैथीली" },
            { "mak", "माकासार" },
            { "man", "मांडींगो" },
            { "mas", "मासाई" },
            { "mdf", "मोक्षा" },
            { "mdr", "मंदार" },
            { "men", "मेन्दे" },
            { "mer", "मेरु" },
            { "mfe", "मरिछ्येन" },
            { "mga", "मध्य आईरीश भाषा" },
            { "mgh", "माखुवा- मीट्ट’" },
            { "mgo", "मेता" },
            { "mic", "मिईकमाक" },
            { "min", "मिनांकाबाऊ" },
            { "mnc", "मांचु" },
            { "mni", "मनिपुरी" },
            { "moe", "इन्नु-आइमुन" },
            { "moh", "महाउक" },
            { "mos", "मस्सी" },
            { "mua", "मुन्दां" },
            { "mul", "गोबां रावफोर" },
            { "mus", "मुस्क’गी" },
            { "mwl", "मिराण्डीज" },
            { "mwr", "मारवाड़ी" },
            { "myv", "एर्जीया" },
            { "mzn", "माजान्देरानि" },
            { "nap", "नियापलिटान" },
            { "naq", "नामा" },
            { "nds", "गाहाय जार्मान" },
            { "new", "नेवारी" },
            { "nia", "नियास" },
            { "niu", "नियुइआन" },
            { "nmg", "क्वासिअ’" },
            { "nnh", "न्गीएम्बून" },
            { "nog", "न’गाई" },
            { "non", "पुरानी नॉर्स्" },
            { "nqo", metaValue_nqo },
            { "nso", "साहायारि सथ’" },
            { "nus", "नूवेर" },
            { "nwc", "पुरानी नेवारी" },
            { "nym", "न्यामवेज़ी" },
            { "nyn", "न्यानकोले" },
            { "nyo", "न्यौरो" },
            { "nzi", "न्ज़ीमा" },
            { "ojb", "साहा-सोनाबारि अजिब्वा" },
            { "ojc", "मिरु अजिब्वा" },
            { "ojs", "अजि क्री" },
            { "ojw", "सोनाबारि अजिब्वा" },
            { "oka", "अकानागान" },
            { "osa", "ओसेज" },
            { "ota", "तुर्की ओटोमान" },
            { "pag", "पाङासिनान" },
            { "pal", "पहलवी" },
            { "pam", "पाम्पाङा" },
            { "pap", "पापीआमेन्तो" },
            { "pau", "पालाऊवान" },
            { "pcm", "नाइजेरियान पिदजीन" },
            { "peo", "पुरानी फ़ारसी" },
            { "phn", "फीनीसी" },
            { "pis", "पिजिन" },
            { "pon", "पोहनपी" },
            { "pqm", "मालिसीत- पास्सामक्वद्दी" },
            { "pro", "पुरानी प्रोवाँसाल" },
            { "raj", "राजस्थानी" },
            { "rap", "रापानुई" },
            { "rar", "रार’टंगान" },
            { "rhg", "रहिंगीया" },
            { "rof", "रम्ब’" },
            { "rom", "रुमानी" },
            { "rup", "आरोमानियान" },
            { "rwk", "र्वा" },
            { "sad", "साण्डावे" },
            { "sah", "साखा" },
            { "sam", "समारीती आरामाईक़" },
            { "saq", "साम्बुरू" },
            { "sas", "सासक" },
            { "sat", "सान्थाली" },
            { "sba", "न्गाम्बै" },
            { "sbp", "साङु" },
            { "scn", "सिसिलियान" },
            { "sco", "स्क’टस" },
            { "seh", "सेना" },
            { "sel", "सेलकुप" },
            { "ses", "कईराबर’ सेन्नि" },
            { "sga", "पुरानी आईरीश" },
            { "shi", "ताचेल्हीट" },
            { "shn", "शान" },
            { "sid", "सीदामो" },
            { "slh", "खोलायारि लाशुतसीद" },
            { "sma", "पश्चीमी सामी" },
            { "smj", "लुले सामी" },
            { "smn", "ईनारी सामी" },
            { "sms", "स्कल्ट सामी" },
            { "snk", "स’निन्के" },
            { "sog", "सोगडीयन" },
            { "srn", "स्रानान टंग’" },
            { "srr", "सेरेर" },
            { "str", "स्ट्रैत्स सालिश" },
            { "suk", "सुकुमा" },
            { "sus", "सुसु" },
            { "sux", "सुमेरिअन" },
            { "swb", "कमरियान" },
            { "syc", "पारंपरीक सिरिआक" },
            { "syr", "सिरिआक" },
            { "tce", "खोलायारि तात्चने" },
            { "tem", "तीमने" },
            { "teo", "तेस’" },
            { "ter", "तेरेनो" },
            { "tet", "तेतुम" },
            { "tgx", "तागीश" },
            { "tht", "टाहल्टान" },
            { "tig", "टीग्रे" },
            { "tiv", "टीव्" },
            { "tkl", "टोकेलौ" },
            { "tlh", "क्लिङ’न" },
            { "tli", "त्लिङीत" },
            { "tmh", "तमाशेक" },
            { "tog", "न्यासा टॉंगा" },
            { "tok", "टकि पना" },
            { "tpi", "ट’क पिसीन" },
            { "trv", "तार’क’" },
            { "tsi", "त्सीमशीआन्" },
            { "ttm", "साहायारि तात्च’ने" },
            { "tum", "तुम्बुका" },
            { "tvl", "टुभालु" },
            { "twq", "तेसावाक" },
            { "tyv", "तुभिनियान" },
            { "tzm", "सेन्ट्रेल आटलास तामाजाईट" },
            { "udm", "उडमुर्त" },
            { "uga", "उगारिती" },
            { "umb", "उम्बुन्डु" },
            { "und", "मिथियै राव" },
            { "vai", metaValue_vai },
            { "vot", "वोटीक" },
            { "vun", "भुन्ज’" },
            { "wae", "वाल्सार" },
            { "wal", "वलाईत्ता" },
            { "war", "वारै" },
            { "was", "वाशो" },
            { "wuu", "वु चाइनीज" },
            { "xal", "कालमीक" },
            { "xog", "स’गा" },
            { "yao", "याओ" },
            { "yap", "यापीज़" },
            { "yav", "यांबेन" },
            { "ybb", "येम्बा" },
            { "yrl", "न्हीगातू" },
            { "yue", "केन्टनिज" },
            { "zap", "ज़ापोतेक" },
            { "zbl", "ब्लीस चिन्ह" },
            { "zen", "ज़ेनागा" },
            { "zgh", "स्टेन्दार्द मरक्कान तामाजाईट" },
            { "zun", "जुनी" },
            { "zxx", "रावआरि आयदाफोर जेबो गैया" },
            { "zza", "जाजा" },
            { "Adlm", "आदलाम" },
            { "Arab", metaValue_ar },
            { "Aran", "नास्तालिक" },
            { "Armi", "शहनशाही आरामाईक" },
            { "Armn", metaValue_hy },
            { "Avst", metaValue_ae },
            { "Bali", "बाली" },
            { "Batk", "बटकी" },
            { "Beng", metaValue_bn },
            { "Blis", "ब्लीस चीन्ह" },
            { "Bopo", "बप’मफ’" },
            { "Brah", "ब्रह्मी" },
            { "Brai", "ब्रैल" },
            { "Bugi", "बुगीनी" },
            { "Buhd", "बुहीद" },
            { "Cakm", metaValue_ccp },
            { "Cans", "जथाय कानाडीयान थागिबियारि रिंसार हानजा" },
            { "Cari", "कारियन" },
            { "Cham", "कॅम" },
            { "Cher", "चेर’की" },
            { "Cirt", "सिर्थ" },
            { "Copt", "कॉप्ट" },
            { "Cprt", "सीप्रीओट्" },
            { "Cyrl", "सिरिल्लिक" },
            { "Cyrs", "पुरानी चर्च सिरिलिक्" },
            { "Deva", "देबनागिरि" },
            { "Dsrt", "देसेरट्" },
            { "Egyd", "मीस्री डैमोटीक्" },
            { "Egyh", "मीस्री हैरैटीक्" },
            { "Egyp", "मीस्री हैरोग्लीफ़्" },
            { "Ethi", "ईथियपिक" },
            { "Geok", "जोर्जीयन खुतसुरी" },
            { "Geor", metaValue_ka },
            { "Glag", "ग्लैगोलिटीक" },
            { "Goth", "गौथीक" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "गुरमुखी" },
            { "Hanb", "बप’मफ’ थानाय हान" },
            { "Hang", "हांगुल" },
            { "Hani", "हान" },
            { "Hano", "हानुनु" },
            { "Hans", "गोरलै खालामना होनाय" },
            { "Hant", "आसार-खान्थिनि" },
            { "Hebr", "हिब्रिऊ" },
            { "Hira", "हीरागाना" },
            { "Hmng", "पाहवाह ह्मौंग" },
            { "Hrkt", "जापानीज रिंसारथिफोर/हांखोफोर" },
            { "Hung", "पुरानी हंगैरीयन" },
            { "Inds", "सिन्धु" },
            { "Ital", "पुरानी इटैलियन" },
            { "Jamo", "जाम’" },
            { "Java", "जावानीस" },
            { "Jpan", metaValue_ja },
            { "Kali", "कायाह ली" },
            { "Kana", "काताकाना" },
            { "Khar", "खरोष्टी" },
            { "Khmr", metaValue_km },
            { "Knda", "कण्णडा" },
            { "Kore", "क’रीयान" },
            { "Lana", "लाना" },
            { "Laoo", "लाओ" },
            { "Latf", "फ्रैक्तुर लैटिन" },
            { "Latg", "गैलीक लैटिन" },
            { "Latn", metaValue_la },
            { "Lepc", "लेपचा" },
            { "Limb", "लिम्बु" },
            { "Lina", "लीनीयर ए" },
            { "Linb", "लीनीयर बी" },
            { "Lyci", "लीसीयन" },
            { "Lydi", "लीडीयन" },
            { "Mand", "मांडे" },
            { "Mani", "मानीकी" },
            { "Maya", "माया हीरोग्लीफ्" },
            { "Mero", "मेरोईटीक्" },
            { "Mlym", "मलयालम" },
            { "Mong", metaValue_mn },
            { "Moon", "मुन्" },
            { "Mtei", "मैतेई मायेक" },
            { "Mymr", metaValue_MM },
            { "Nkoo", metaValue_nqo },
            { "Ogam", "ओगहैम" },
            { "Olck", "अल चीकी" },
            { "Orkh", "ओरखोन" },
            { "Orya", "उड़िया" },
            { "Osma", "ओस्मानिया" },
            { "Perm", "पुरानी पर्मीक्" },
            { "Phag", "फाग्स पा" },
            { "Phlv", "बुक (सालटर) पहलवी" },
            { "Phnx", "फोनीशीयन" },
            { "Plrd", "पौलार्ड़ फोनेटीक" },
            { "Rjng", "रेजेंग" },
            { "Rohg", "हानिफि" },
            { "Roro", "रोंगोरोंगो" },
            { "Runr", "रूनिक" },
            { "Samr", "समारती" },
            { "Sara", "सराती" },
            { "Saur", "सौराष्ट्र" },
            { "Sgnw", "सांकेतिक लेख" },
            { "Shaw", "शेवियन" },
            { "Sinh", "सिंहाली" },
            { "Sund", "सून्डानीज" },
            { "Sylo", "सील्होटी नागरी" },
            { "Syrc", "सीरीआक" },
            { "Syre", "एस्ट्रांगलो सीरीआक" },
            { "Syrj", "पश्चीमी सीरीआक" },
            { "Syrn", "पूर्वी सीरीआक" },
            { "Tagb", "तागबानवा" },
            { "Tale", "ताई ले" },
            { "Talu", "नया ताई लुए" },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Teng", "तेंगवार" },
            { "Tfng", "तिफिनाघ" },
            { "Tglg", "टागालॉग" },
            { "Thaa", "थाना" },
            { "Thai", metaValue_th },
            { "Tibt", "तिबेतान" },
            { "Ugar", "ऊगारीटीक" },
            { "Vaii", metaValue_vai },
            { "Visp", "वीज़ीबल बोली" },
            { "Xpeo", "पुरानी फारसी" },
            { "Xsux", "सुमेरो अक्काड़ी कुनेईफॉर्म" },
            { "Yiii", "यी" },
            { "Zinh", "विरासत" },
            { "Zmth", "सानखान्थियारि दैदेन्नाय हांखोफोर" },
            { "Zsye", "ईम’जी" },
            { "Zsym", "नेर्सोनफोर" },
            { "Zxxx", "लिरै" },
            { "Zyyy", "साधारन" },
            { "Zzzz", "मिथियै हांखो" },
            { "de_AT", "अस्ट्रेयाआरि जार्मान" },
            { "de_CH", "सुइस गोजौ जार्मान" },
            { "en_AU", "अस्ट्रेलियानि इंराजी" },
            { "en_CA", "कानाडानि इंराजी" },
            { "en_GB", "ब्रिटिश इंराजी" },
            { "en_US", "आमेरिकानि इंराजी" },
            { "es_ES", "युरोपनि स्पेनिश" },
            { "es_MX", "मेक्सिक’नि स्पेनिश" },
            { "fa_AF", "डारी" },
            { "fr_CA", "कानाडानि फ्रेन्च" },
            { "fr_CH", "सुइस फ्रेन्च" },
            { "nl_BE", "फ्लेमिस" },
            { "pt_BR", "ब्राजिलनि पर्टुगिज" },
            { "pt_PT", "युरोपनि पर्टुगिज" },
            { "ro_MD", "मोल्डेवियन्" },
            { "%%1901", "पारम्पारिक जर्मन वर्तनी 1901" },
            { "%%1994", "पारम्पारिक रेसीयन वर्तनी 1994" },
            { "%%1996", "जर्मन वर्तनी 1996" },
            { "ar_001", "गोदान मानथाखोआरि आराबिक" },
            { "es_419", "लेटीन आमेरिकानि स्पेनिश" },
            { "key.ca", "केलेण्डार/फान्जामुथि" },
            { "key.cf", "मुद्रानि नुथाय" },
            { "key.co", "रान्नायनि फारि" },
            { "key.cu", "मुद्रा" },
            { "key.hc", "घन्टानि गिदिंफिन्नाय ( 12 बेरेखा 24)" },
            { "key.lb", "हांखो सिफायनाय दह‘ङ" },
            { "key.ms", "जखा लानाय आदब" },
            { "key.nu", "अनजिमाफोर" },
            { "%%BISKE", "सान जीओर्जीओ / बीला डायलेक्ट" },
            { "%%BOONT", "बुन्तलींग" },
            { "%%LIPAW", "रेज़ीयन की लीपोवाज़ डायलेक्ट" },
            { "%%NEDIS", "नाटीसोन डायलेक्ट" },
            { "%%NJIVA", "ग्नीवा या न्जीवा डायलेक्ट" },
            { "%%OSOJS", "ओसेआको ओसोजाने डायलेक्ट" },
            { "%%POSIX", "कम्प्यूटर" },
            { "%%ROZAJ", "रेज़ीयन" },
            { "%%SAAHO", "साहो" },
            { "%%SOLBA", "श्टोलविज़्ज़ा या सोलबीका डायलेक्ट" },
            { "zh_Hans", "गोरलै खालामनाय चाइनीज" },
            { "zh_Hant", "आसार-खान्थियारि चाइनीज" },
            { "%%FONIPA", "आईपीए फ़ोनेटीक्स" },
            { "%%FONUPA", "युपीए फ़ोनेटीक्स" },
            { "%%SCOUSE", "स्काउज़" },
            { "%%TARASK", "तारास्कीएवीचा वर्तनी" },
            { "%%AREVELA", "पूर्वी अर्मेनियाई" },
            { "%%MONOTON", "एकस्वरीय" },
            { "%%POLYTON", "बहुस्वरीय" },
            { "%%REVISED", "संशोधित वर्तनी" },
            { "%%1606NICT", "मध्य फ्रांसीसी 1606 तक" },
            { "%%BAKU1926", "युनीफाईड तुर्की लैटीनी वर्तनी" },
            { "%%SCOTLAND", "मानक स्कॉट अंग्रेज़ी" },
            { "type.ca.roc", "मिंगुव’ फान्जामुथि" },
            { "type.hc.h11", "12 घन्टानि आदब (0–11)" },
            { "type.hc.h12", "12 घन्टानि आदब (1–12)" },
            { "type.hc.h23", "24 घन्टानि आदब ( 0–23)" },
            { "type.hc.h24", "24 घन्टानि आदब ( 1–24)" },
            { "type.nu.arab", "आराबिक-इण्डिक अनजिमाफोर" },
            { "type.nu.armn", "आर्मेनियानि अनजिमा दिन्थिनाय हांखो" },
            { "type.nu.beng", "बांला अनजिमाफोर" },
            { "type.nu.cakm", "चाकमा अनजिमाफोर" },
            { "type.nu.deva", "देबनागिरि अनजिमाफोर" },
            { "type.nu.ethi", "इथिय’पियानि अनजिमाफोर" },
            { "type.nu.geor", "जर्जियान अनजिमा दिन्थिनाय हांखोफोर" },
            { "type.nu.grek", "ग्रीक अनजिमा दिन्थिनाय हांखोफोर" },
            { "type.nu.gujr", "गुजराती अनजिमाफोर" },
            { "type.nu.guru", "गुरमुखी अनजिमाफोर" },
            { "type.nu.hans", "गोरलै खालामनाय चाइनीज अनजिमा दिन्थिनाय हांखोफोर" },
            { "type.nu.hant", "आसार-खान्थियारि चाइनीज अनजिमा दिन्थिनाय हांखोफोर" },
            { "type.nu.hebr", "हिब्रिउ अनजिमा दिन्थिनाय हांखोफोर" },
            { "type.nu.java", "जाभानीज अनजिमा दिन्थिनाय हांखोफोर" },
            { "type.nu.jpan", "जापानीज अनजिमा दिन्थिनाय हांखोफोर" },
            { "type.nu.khmr", "ख्मेर अनजिमाफोर" },
            { "type.nu.knda", "कान्नाडा अनजिमाफोर" },
            { "type.nu.laoo", "लाव अनजिमाफोर" },
            { "type.nu.latn", "सोनाबारी अनजिमाफोर" },
            { "type.nu.mlym", "मालायालम अनजिमाफोर" },
            { "type.nu.mtei", "मितै मायेक अनजिमाफोर" },
            { "type.nu.mymr", "म्यानमारनि अनजिमाफोर" },
            { "type.nu.olck", "अल चिकि अनजिमाफोर" },
            { "type.nu.orya", "अरिया अनजिमाफोर" },
            { "type.nu.taml", "आसार खान्थियारि तामिल अनजिमा दिन्थिनाय हांखोफोर" },
            { "type.nu.telu", "तेलुगु अनजिमाफोर" },
            { "type.nu.thai", "थाई अनजिमाफोर" },
            { "type.nu.tibt", "तिब्बति अनजिमाफोर" },
            { "type.nu.vaii", "भाई अनजिमाफोर" },
            { "type.ca.dangi", "दांगि फान्जामुथि" },
            { "type.co.ducet", "गरहाजिर इउनिकड रान्नायनि फारि" },
            { "type.lb.loose", "गुरै हांखो सिफायनाय दह‘ङ" },
            { "type.nu.roman", "रमान अनजिमा दिन्थिनाय हांखोफोर" },
            { "type.ca.coptic", "कप्तिक फान्जामुथि" },
            { "type.ca.hebrew", "हिब्रिउ फान्जामुथि" },
            { "type.ca.indian", "भारतनि हादोरनां फान्जामुथि" },
            { "type.co.pinyin", "पिनयीन वर्गीकरण" },
            { "type.co.search", "सादारन-जाहोननि नायगिरनाय" },
            { "type.co.stroke", "स्ट्रोक वर्गीकरण" },
            { "type.lb.normal", "जासिमा हांखो सिफायनाय दह‘ङ" },
            { "type.lb.strict", "गोख्रों हांखो सिफायनाय दह‘ङ" },
            { "type.ms.metric", "मेट्रिक आदब" },
            { "type.ca.chinese", "चाइनिज फान्जामुथि" },
            { "type.ca.islamic", "इस्लामिक फान्जामुथि" },
            { "type.ca.iso8601", "आइ.एस.अ-8601 फान्जामुथि" },
            { "type.ca.persian", "पार्सियान फान्जामुथि" },
            { "type.cf.account", "मुद्रानि नुथायखौ हिसाब लाखिनाय" },
            { "type.nu.arabext", "फोलावनाय आराबिक-इण्डिक अनजिमाफोर" },
            { "type.nu.armnlow", "आर्मेनियानि अनजिमा दिन्थिनाय फिसा हांखो" },
            { "type.nu.greklow", "ग्रीक अनजिमा दिन्थिनाय फिसा हांखोफोर" },
            { "type.nu.hanidec", "चाइनीज दशमिक अनजिमा दिन्थिनाय हांखोफोर" },
            { "type.nu.hansfin", "गोरलै खालामनाय चाइनीज रांआरि अनजिमा दिन्थिनाय हांखोफोर" },
            { "type.nu.hantfin", "आसार-खान्थियारि चाइनीज रांआरि अनजिमा दिन्थिनाय हांखोफोर" },
            { "type.nu.jpanfin", "जापानीज रांआरि अनजिमा दिन्थिनाय हांखोफोर" },
            { "type.nu.tamldec", "तामिल अनजिमाफोर" },
            { "type.ca.buddhist", "बौद्ध फान्जामुथि" },
            { "type.ca.ethiopic", "इथिय’पियानि फान्जामुथि" },
            { "type.ca.japanese", "जापानीज फान्जामुथि" },
            { "type.cf.standard", "थाखोआरि मुद्रानि नुथाय" },
            { "type.co.standard", "थाखोआरि रोखोम फारि" },
            { "type.ms.uksystem", "ब्रिटिसा गनायनाय जखा लानाय आदब" },
            { "type.ms.ussystem", "इउ.एस नि जखा लानाय आदब" },
            { "type.nu.fullwide", "आबुं-गुवारथिनि अनजिमाफोर" },
            { "type.nu.romanlow", "रमान अनजिमा दिन्थिनाय फिसा हांखोफोर" },
            { "type.ca.gregorian", "ग्रेग’रियान फान्जामुथि" },
            { "type.co.phonebook", "दूरभाष निर्देशिका वर्गीकरण" },
            { "type.co.traditional", "पारम्पारिक वर्गीकरण" },
            { "type.ca.islamic-civil", "इस्लामिक फान्जामुथि ( फारि, हादोरारि मुगा)" },
            { "ListCompositionPattern", "{0},{1}" },
            { "type.ca.islamic-umalqura", "इस्लामिक फान्जामुथि( ऊम आल-कूरा)" },
            { "type.ca.ethiopic-amete-alem", "इथिय’पिक आमेते आलेम फान्जामुथि" },
        };
        return data;
    }
}
