/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdi;

import com.jetbrains.jdi.ExactClassNotLoadedException;
import com.jetbrains.jdi.JDWP;
import com.jetbrains.jdi.JDWPException;
import com.jetbrains.jdi.JNITypeParser;
import com.jetbrains.jdi.ObjectReferenceImpl;
import com.jetbrains.jdi.VirtualMachineImpl;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ClassLoaderReferenceImpl
extends ObjectReferenceImpl
implements ClassLoaderReference {
    private final Set<ReferenceType> cachedVisible = Collections.synchronizedSet(new HashSet());
    static final ClassLoaderReferenceImpl NULL = new ClassLoaderReferenceImpl();

    @Override
    protected ObjectReferenceImpl.Cache newCache() {
        return new Cache();
    }

    ClassLoaderReferenceImpl(VirtualMachine aVm, long ref) {
        super(aVm, ref);
        this.vm.state().addListener(this);
    }

    private ClassLoaderReferenceImpl() {
        super(null, -1L);
    }

    @Override
    protected String description() {
        return "ClassLoaderReference " + this.uniqueID();
    }

    @Override
    public List<ReferenceType> definedClasses() {
        ArrayList<ReferenceType> definedClasses = new ArrayList<ReferenceType>();
        this.vm.forEachClass(type -> {
            if (type.isPrepared() && this.equals(type.classLoader())) {
                definedClasses.add((ReferenceType)type);
            }
        });
        return definedClasses;
    }

    @Override
    public List<ReferenceType> visibleClasses() {
        List<ReferenceType> classes = null;
        try {
            Cache local = (Cache)this.getCache();
            if (local != null) {
                classes = local.visibleClasses;
            }
            if (classes == null) {
                JDWP.ClassLoaderReference.VisibleClasses.ClassInfo[] jdwpClasses = JDWP.ClassLoaderReference.VisibleClasses.process((VirtualMachineImpl)this.vm, (ClassLoaderReferenceImpl)this).classes;
                classes = new ArrayList<ReferenceType>(jdwpClasses.length);
                for (JDWP.ClassLoaderReference.VisibleClasses.ClassInfo jdwpClass : jdwpClasses) {
                    classes.add(this.vm.referenceType(jdwpClass.typeID, jdwpClass.refTypeTag));
                }
                this.cachedVisible.addAll(classes);
                classes = Collections.unmodifiableList(classes);
                if (local != null) {
                    local.visibleClasses = classes;
                    if ((this.vm.traceFlags & 0x10) != 0) {
                        this.vm.printTrace(this.description() + " temporarily caching visible classes (count = " + classes.size() + ")");
                    }
                }
            }
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
        return classes;
    }

    Type findType(String signature) throws ClassNotLoadedException {
        List<ReferenceType> typesByName = this.vm.classesBySignature(signature);
        for (ReferenceType referenceType : typesByName) {
            if (!this.cachedVisible.contains(referenceType)) continue;
            return referenceType;
        }
        List<ReferenceType> visibleTypes = this.visibleClasses();
        for (ReferenceType type : typesByName) {
            if (!this.cachedVisible.contains(type)) continue;
            return type;
        }
        for (ReferenceType type : visibleTypes) {
            if (!type.signature().equals(signature)) continue;
            return type;
        }
        String string = new JNITypeParser(signature).typeName();
        throw new ExactClassNotLoadedException(string, "Class " + string + " not loaded", this);
    }

    @Override
    byte typeValueKey() {
        return 108;
    }

    public boolean isVisible(ReferenceType type) {
        if (this.cachedVisible.contains(type)) {
            return true;
        }
        this.visibleClasses();
        return this.cachedVisible.contains(type);
    }

    public void addVisible(ReferenceType type) {
        this.cachedVisible.add(type);
    }

    @Override
    public void referenceTypeRemoved(ReferenceType type) {
        this.cachedVisible.remove(type);
    }

    private static class Cache
    extends ObjectReferenceImpl.Cache {
        List<ReferenceType> visibleClasses = null;

        private Cache() {
        }
    }
}

