/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.editor.ui;

import com.intellij.jupyter.core.core.api.actions.NotebookCellLinesEditHelper;
import com.intellij.jupyter.core.core.impl.actions.NotebookCellLinesDocumentUtils;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.editor.NotebookMarkdownEditorManagerKt;
import com.intellij.jupyter.core.editor.handlers.DataInputCodeGenerationContext;
import com.intellij.jupyter.core.editor.handlers.TableDataFileDropHandler;
import com.intellij.jupyter.core.editor.handlers.TableDataFileDropHandlerContext;
import com.intellij.jupyter.core.editor.ui.JupyterFileDropHandler;
import com.intellij.jupyter.core.fus.DataDropHandlerCollector;
import com.intellij.jupyter.core.jupyter.actions.utils.JupyterRunner;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputSettings;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.notebooks.jupyter.core.jupyter.JupyterLanguageKt;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.NotebookVisualizationUiUtilKt;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FileDropEvent;
import com.intellij.openapi.editor.FileDropHandler;
import com.intellij.openapi.editor.FileDropManager;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.PathUtil;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\bJ \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u0012H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/jupyter/core/editor/ui/JupyterFileDropHandler;", "Lcom/intellij/openapi/editor/FileDropHandler;", "<init>", "()V", "handleDrop", "", "e", "Lcom/intellij/openapi/editor/FileDropEvent;", "(Lcom/intellij/openapi/editor/FileDropEvent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "insertAndRunCells", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "project", "Lcom/intellij/openapi/project/Project;", "generatedCells", "", "canHandle", "Lcom/intellij/openapi/editor/Editor;", "Manager", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterFileDropHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterFileDropHandler.kt\ncom/intellij/jupyter/core/editor/ui/JupyterFileDropHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,152:1\n14#2:153\n30#3,2:154\n*S KotlinDebug\n*F\n+ 1 JupyterFileDropHandler.kt\ncom/intellij/jupyter/core/editor/ui/JupyterFileDropHandler\n*L\n58#1:153\n63#1:154,2\n*E\n"})
public final class JupyterFileDropHandler
implements FileDropHandler {
    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object handleDrop(@NotNull FileDropEvent e, @NotNull Continuation<? super Boolean> $completion) {
        if (!($completion instanceof handleDrop.1)) ** GOTO lbl-1000
        var13_3 = $completion;
        if ((var13_3.label & -2147483648) != 0) {
            var13_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ JupyterFileDropHandler this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.handleDrop(null, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var14_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var5_6 = e.getEditor();
                v0 = var5_6 instanceof EditorImpl != false ? (EditorImpl)var5_6 : null;
                if (v0 == null) {
                    return Boxing.boxBoolean((boolean)false);
                }
                editor = v0;
                if (JupyterDataInputSettings.INSTANCE.inputCellsEnabled((Editor)editor)) {
                    return Boxing.boxBoolean((boolean)false);
                }
                v1 = editor.getProject();
                if (v1 == null) {
                    return Boxing.boxBoolean((boolean)false);
                }
                project = v1;
                $continuation.L$0 = e;
                $continuation.L$1 = editor;
                $continuation.L$2 = project;
                $continuation.label = 1;
                v2 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, handleDrop$lambda$0(com.intellij.jupyter.core.editor.ui.JupyterFileDropHandler com.intellij.openapi.editor.FileDropEvent ), ()Ljava/lang/Boolean;)((JupyterFileDropHandler)this, (FileDropEvent)e), (Continuation)$continuation);
                if (v2 == var14_5) {
                    return var14_5;
                }
                ** GOTO lbl37
            }
            case 1: {
                project = (Project)$continuation.L$2;
                editor = (EditorImpl)$continuation.L$1;
                e = (FileDropEvent)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl37:
                // 2 sources

                if (!((Boolean)v2).booleanValue()) {
                    return Boxing.boxBoolean((boolean)false);
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)e);
                $continuation.L$1 = editor;
                $continuation.L$2 = project;
                $continuation.label = 2;
                v3 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, handleDrop$lambda$1(com.intellij.openapi.editor.FileDropEvent com.intellij.openapi.editor.impl.EditorImpl ), ()Lkotlin/Pair;)((FileDropEvent)e, (EditorImpl)editor), (Continuation)$continuation);
                if (v3 == var14_5) {
                    return var14_5;
                }
                ** GOTO lbl53
            }
            case 2: {
                project = (Project)$continuation.L$2;
                editor = (EditorImpl)$continuation.L$1;
                e = (FileDropEvent)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl53:
                // 2 sources

                var5_6 = (Pair)v3;
                generatedCells = (List)var5_6.component1();
                othersFiles = (List)var5_6.component2();
                if (generatedCells.isEmpty()) {
                    return Boxing.boxBoolean((boolean)false);
                }
                try {
                    this.insertAndRunCells(editor, project, CollectionsKt.joinToString$default((Iterable)generatedCells, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
                    var9_11 = true;
                }
                catch (Exception e) {
                    $i$f$logger = false;
                    v4 = Logger.getInstance(JupyterFileDropHandler.class);
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getInstance(...)");
                    v4.warn("Error during cells creation on drag and drop with code " + generatedCells, (Throwable)e);
                    var9_11 = false;
                }
                result = var9_11;
                if (((Collection)othersFiles).isEmpty() == false) {
                    $this$service$iv = (ComponentManager)project;
                    $i$f$service = false;
                    serviceClass$iv = FileDropManager.class;
                    v5 = $this$service$iv.getService(serviceClass$iv);
                    if (v5 == null) {
                        throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                    }
                    FileDropManager.openFilesInTab$default((FileDropManager)((FileDropManager)v5), (Editor)((Editor)editor), (List)othersFiles, null, (int)4, null);
                }
                return Boxing.boxBoolean((boolean)(result != false));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void insertAndRunCells(EditorImpl editor, Project project, String generatedCells) {
        int currentLine = editor.getCaretModel().getCurrentCaret().getLogicalPosition().line;
        NotebookCellLines cellLines = NotebookCellLines.Companion.get((Editor)editor);
        int cellsBefore = ((Collection)NotebookVisualizationUiUtilKt.getCells((Editor)((Editor)editor), (IntRange)new IntRange(0, currentLine))).size();
        NotebookCellLines.Interval interval = (NotebookCellLines.Interval)SequencesKt.firstOrNull((Sequence)NotebookVisualizationUiUtilKt.getCells((NotebookCellLines)cellLines, (IntRange)new IntRange(currentLine, currentLine)));
        if (interval == null) {
            throw new IllegalStateException("Can't find cell insertion position");
        }
        int lastCellOrdinal = interval.getOrdinal();
        WriteCommandAction.writeCommandAction((Project)project).withName(JupyterFileDropHandler.class.getName()).run(() -> JupyterFileDropHandler.insertAndRunCells$lambda$2(editor, cellLines, generatedCells, lastCellOrdinal, project, cellsBefore));
    }

    private final boolean canHandle(Project project, Editor editor) {
        if (editor.isDisposed()) {
            return false;
        }
        if (!editor.getDocument().isWritable()) {
            return false;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (file == null) {
            return false;
        }
        FileType fileType = file.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        return JupyterLanguageKt.isJupyterLanguage((FileType)fileType);
    }

    private static final boolean handleDrop$lambda$0(JupyterFileDropHandler this$0, FileDropEvent $e) {
        Project project = $e.getProject();
        Editor editor = $e.getEditor();
        Intrinsics.checkNotNull((Object)editor);
        return this$0.canHandle(project, editor);
    }

    private static final Pair handleDrop$lambda$1(FileDropEvent $e, EditorImpl $editor) {
        return Manager.INSTANCE.proceedFiles($e.getFiles(), $editor);
    }

    private static final void insertAndRunCells$lambda$2(EditorImpl $editor, NotebookCellLines $cellLines, String $generatedCells, int $lastCellOrdinal, Project $project, int $cellsBefore) {
        DocumentEx documentEx = $editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        int cellCountToExecute = NotebookCellLinesDocumentUtils.insertCells$default(NotebookCellLinesDocumentUtils.INSTANCE, (Document)documentEx, $cellLines, $generatedCells, $lastCellOrdinal + 1, false, 8, null).size();
        PsiDocumentManager.getInstance((Project)$project).commitDocument((Document)$editor.getDocument());
        List<NotebookIntervalPointer> cellPointers = NotebookMarkdownEditorManagerKt.getAllIntervalPointers((Editor)$editor).subList($cellsBefore, $cellsBefore + cellCountToExecute);
        VirtualFile virtualFile2 = $editor.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
        BackedNotebookVirtualFile notebookVirtualFile2 = BackedNotebookVirtualFile.Companion.takeBackend(virtualFile2);
        JupyterRunner.runCells$default(JupyterRunner.INSTANCE, $project, cellPointers, (Editor)$editor, notebookVirtualFile2, null, 16, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0004\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00060\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lcom/intellij/jupyter/core/editor/ui/JupyterFileDropHandler$Manager;", "", "<init>", "()V", "proceedFiles", "Lkotlin/Pair;", "", "", "Ljava/io/File;", "fileListData", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "intellij.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nJupyterFileDropHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterFileDropHandler.kt\ncom/intellij/jupyter/core/editor/ui/JupyterFileDropHandler$Manager\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,152:1\n996#2:153\n1025#2,3:154\n1028#2,3:164\n382#3,7:157\n1#4:167\n1573#5:168\n1604#5,4:169\n*S KotlinDebug\n*F\n+ 1 JupyterFileDropHandler.kt\ncom/intellij/jupyter/core/editor/ui/JupyterFileDropHandler$Manager\n*L\n112#1:153\n112#1:154,3\n112#1:164,3\n112#1:157,7\n132#1:168\n132#1:169,4\n*E\n"})
    private static final class Manager {
        @NotNull
        public static final Manager INSTANCE = new Manager();

        private Manager() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Pair<List<String>, List<File>> proceedFiles(@NotNull Collection<? extends File> fileListData, @NotNull EditorImpl editor) {
            void $this$groupByTo$iv$iv;
            Intrinsics.checkNotNullParameter(fileListData, (String)"fileListData");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Sequence $this$groupBy$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)fileListData), Manager::proceedFiles$lambda$0);
            boolean $i$f$groupBy = false;
            Sequence sequence = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                String string;
                File it = (File)element$iv$iv;
                boolean bl = false;
                String string2 = PathUtil.getFileExtension((String)it.getPath());
                if (string2 != null) {
                    String string3 = string2.toLowerCase(Locale.ROOT);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                } else {
                    string = null;
                }
                String key$iv$iv = string;
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map extensionByFile = destination$iv$iv;
            List generatedCells = new ArrayList();
            NotebookCellLinesEditHelper notebookCellLinesEditHelper = NotebookCellLinesEditHelper.Companion.getOrNull((Editor)editor);
            Intrinsics.checkNotNull((Object)notebookCellLinesEditHelper);
            NotebookCellLinesEditHelper cellEditHelper = notebookCellLinesEditHelper;
            List othersFiles = new ArrayList();
            for (Map.Entry entry : extensionByFile.entrySet()) {
                void $this$mapIndexedTo$iv$iv;
                void $this$mapIndexed$iv;
                TableDataFileDropHandler tableDataFileDropHandler;
                BackedNotebookVirtualFile it;
                String ext = (String)entry.getKey();
                List files = (List)entry.getValue();
                if (ext == null) {
                    othersFiles.addAll(files);
                    continue;
                }
                if (JupyterEditorExtensionsKt.getNotebookFileOrNull((Editor)editor) != null) {
                    boolean bl = false;
                    v5 = TableDataFileDropHandler.Companion.findApplicable(it.getNotebook(), ext);
                } else {
                    v5 = tableDataFileDropHandler = null;
                }
                if (tableDataFileDropHandler == null) {
                    othersFiles.addAll(files);
                    continue;
                }
                int n = files.size();
                FileType fileType = editor.getVirtualFile().getFileType();
                Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
                DataDropHandlerCollector.INSTANCE.readingTableDataCellCreated(tableDataFileDropHandler, n, fileType);
                Iterable bl = files;
                List list = generatedCells;
                boolean $i$f$mapIndexed = false;
                it = $this$mapIndexed$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    void index;
                    void file;
                    int n2;
                    if ((n2 = index$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    File file2 = (File)item$iv$iv;
                    int n3 = n2;
                    Collection collection = destination$iv$iv2;
                    boolean bl3 = false;
                    BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterEditorExtensionsKt.getNotebookFile((Editor)editor);
                    Project project = editor.getProject();
                    Intrinsics.checkNotNull((Object)project);
                    String code = tableDataFileDropHandler.generateCellCode(new TableDataFileDropHandlerContext(backedNotebookVirtualFile, ext, project, (File)file, DataInputCodeGenerationContext.ON_DROP, (int)index, null, 64, null));
                    String string = NotebookCellLinesEditHelper.makeCell$default(cellEditHelper, ((Object)StringsKt.trim((CharSequence)code)).toString(), NotebookCellLines.CellType.CODE, null, 4, null);
                    Intrinsics.checkNotNull((Object)string);
                    collection.add(string);
                }
                list.addAll((List)destination$iv$iv2);
            }
            return new Pair((Object)generatedCells, (Object)othersFiles);
        }

        private static final boolean proceedFiles$lambda$0(File it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.isFile();
        }
    }
}

