/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.maven.resolver;

import java.util.Collection;
import java.util.List;
import javax.inject.Named;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.internal.impl.DefaultArtifactResolver;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.jfrog.build.extractor.maven.resolver.ArtifactoryEclipseResolversHelper;
import org.jfrog.build.extractor.maven.resolver.ResolutionHelper;

@Named
@Component(role=ArtifactoryEclipseArtifactResolver.class)
public class ArtifactoryEclipseArtifactResolver
extends DefaultArtifactResolver {
    @Requirement
    private ResolutionHelper resolutionHelper;
    @Requirement
    private Logger logger;
    @Requirement
    private ArtifactoryEclipseResolversHelper helper;

    public void initResolutionRepositories(RepositorySystemSession session) {
        this.helper.initResolutionRepositories(session);
    }

    private void enforceResolutionRepositories(RepositorySystemSession session, ArtifactRequest request) {
        List<RemoteRepository> repositories = this.helper.getResolutionRepositories(session);
        if (repositories != null && !repositories.isEmpty()) {
            request.setRepositories(repositories);
        }
    }

    @Override
    public List<ArtifactResult> resolveArtifacts(RepositorySystemSession session, Collection<? extends ArtifactRequest> requests) throws ArtifactResolutionException {
        for (ArtifactRequest artifactRequest : requests) {
            this.enforceResolutionRepositories(session, artifactRequest);
        }
        return super.resolveArtifacts(session, requests);
    }

    public RemoteRepository getSnapshotRepository(RepositorySystemSession session) {
        return this.helper.getSnapshotRepository(session);
    }

    public RemoteRepository getReleaseRepository(RepositorySystemSession session) {
        return this.helper.getReleaseRepository(session);
    }
}

