/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.api.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.jfrog.build.api.Artifact;
import org.jfrog.build.api.Dependency;
import org.jfrog.build.api.Module;
import org.jfrog.build.api.builder.ModuleType;

public class ModuleBuilder {
    private ModuleType type;
    private String id;
    private String repository;
    private String sha1;
    private String md5;
    private List<Artifact> artifacts;
    private List<Artifact> excludedArtifacts;
    private List<Dependency> dependencies;
    private Properties properties;

    public Module build() {
        if (this.id == null || this.id.trim().length() == 0) {
            throw new IllegalArgumentException("Cannot build module entity without Module ID value");
        }
        Module module = new Module();
        if (this.type != null) {
            module.setType(this.type.name().toLowerCase());
        }
        module.setId(this.id.trim());
        module.setRepository(this.repository);
        module.setSha1(this.sha1);
        module.setMd5(this.md5);
        module.setArtifacts(this.artifacts);
        module.setDependencies(this.dependencies);
        module.setProperties(this.properties);
        module.setExcludedArtifacts(this.excludedArtifacts);
        return module;
    }

    public ModuleBuilder type(ModuleType type) {
        this.type = type;
        return this;
    }

    public ModuleBuilder id(String id) {
        this.id = id;
        return this;
    }

    public ModuleBuilder repository(String repository) {
        this.repository = repository;
        return this;
    }

    public ModuleBuilder sha1(String sha1) {
        this.sha1 = sha1;
        return this;
    }

    public ModuleBuilder md5(String md5) {
        this.md5 = md5;
        return this;
    }

    public ModuleBuilder artifacts(List<Artifact> artifacts) {
        this.artifacts = artifacts;
        return this;
    }

    public ModuleBuilder excludedArtifacts(List<Artifact> excludedArtifacts) {
        this.excludedArtifacts = excludedArtifacts;
        return this;
    }

    public ModuleBuilder addArtifact(Artifact artifact) {
        if (this.artifacts == null) {
            this.artifacts = new ArrayList<Artifact>();
        }
        this.artifacts.add(artifact);
        return this;
    }

    public ModuleBuilder addExcludedArtifact(Artifact artifact) {
        if (this.excludedArtifacts == null) {
            this.excludedArtifacts = new ArrayList<Artifact>();
        }
        this.excludedArtifacts.add(artifact);
        return this;
    }

    public ModuleBuilder dependencies(List<Dependency> dependencies) {
        this.dependencies = dependencies;
        return this;
    }

    public ModuleBuilder addDependency(Dependency dependency) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<Dependency>();
        }
        this.dependencies.add(dependency);
        return this;
    }

    public ModuleBuilder properties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public ModuleBuilder addProperty(Object key, Object value) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.put(key, value);
        return this;
    }
}

