/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.ssh.util;

import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.rd.util.BackgroundProgressCoroutineUtilKt;
import com.intellij.openapi.rd.util.ProgressCoroutineScope;
import com.intellij.openapi.rd.util.ProgressIndocatorExKt;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.ui.SshPasswordPrompt;
import com.intellij.util.ExceptionUtil;
import com.jetbrains.gateway.GatewayBundle;
import com.jetbrains.gateway.internal.GatewayCoreRegistry;
import com.jetbrains.gateway.ssh.dialogs.GatewaySshPasswordPrompt;
import com.jetbrains.gateway.ssh.util.SshConnectStatus;
import com.jetbrains.gateway.ssh.util.SshConnectionCheckUtil;
import com.jetbrains.gateway.statistics.GatewayUsagesCollector;
import java.time.Duration;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0086@\u00a2\u0006\u0002\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/gateway/ssh/util/SshConnectionCheckUtil;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "checkSshConnection", "Lcom/jetbrains/gateway/ssh/util/SshConnectStatus;", "credentials", "Lcom/intellij/remote/RemoteCredentials;", "allowDialogs", "", "checkSshConnectionUnderModalProgress", "(Lcom/intellij/remote/RemoteCredentials;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.gateway.core"})
@SourceDebugExtension(value={"SMAP\nSshConnectionCheckUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshConnectionCheckUtil.kt\ncom/jetbrains/gateway/ssh/util/SshConnectionCheckUtil\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,79:1\n13#2:80\n*S KotlinDebug\n*F\n+ 1 SshConnectionCheckUtil.kt\ncom/jetbrains/gateway/ssh/util/SshConnectionCheckUtil\n*L\n25#1:80\n*E\n"})
public final class SshConnectionCheckUtil {
    @NotNull
    public static final SshConnectionCheckUtil INSTANCE = new SshConnectionCheckUtil();
    @NotNull
    private static final Logger logger;

    private SshConnectionCheckUtil() {
    }

    @NotNull
    public final SshConnectStatus checkSshConnection(@NotNull RemoteCredentials credentials, boolean allowDialogs) {
        SshConnectStatus sshConnectStatus;
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        long timeoutRegistryValue = GatewayCoreRegistry.INSTANCE.getSshConnectionCheckTimeout();
        Duration timeout = Duration.ofSeconds(timeoutRegistryValue);
        logger.info("sshConnectionCheckTimeout=" + timeoutRegistryValue + "s");
        StructuredIdeActivity onCheckConnectionStartedActivity = GatewayUsagesCollector.INSTANCE.onCheckConnectionStarted();
        try {
            Intrinsics.checkNotNull((Object)timeout);
            boolean isSucceeded = RemoteCredentialsUtil.checkConnection((RemoteCredentials)credentials, (Duration)timeout, (ProgressIndicator)ProgressManager.getInstance().getProgressIndicator(), (SshPasswordPrompt)new GatewaySshPasswordPrompt(), (boolean)allowDialogs);
            sshConnectStatus = !isSucceeded ? new SshConnectStatus(false, GatewayBundle.INSTANCE.message("ssh.credentials.error", new Object[0])) : new SshConnectStatus(true, null);
        }
        catch (RuntimeException t) {
            sshConnectStatus = new SshConnectStatus(false, ExceptionUtil.getRootCause((Throwable)t).getMessage());
        }
        catch (TimeoutException t) {
            sshConnectStatus = new SshConnectStatus(false, ExceptionUtil.getRootCause((Throwable)t).getMessage());
        }
        SshConnectStatus connectionStatus = sshConnectStatus;
        GatewayUsagesCollector.INSTANCE.onCheckConnectionFinished(onCheckConnectionStartedActivity, connectionStatus.isSucceeded());
        return connectionStatus;
    }

    public static /* synthetic */ SshConnectStatus checkSshConnection$default(SshConnectionCheckUtil sshConnectionCheckUtil, RemoteCredentials remoteCredentials, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return sshConnectionCheckUtil.checkSshConnection(remoteCredentials, bl);
    }

    @Nullable
    public final Object checkSshConnectionUnderModalProgress(@NotNull RemoteCredentials credentials, @NotNull Continuation<? super SshConnectStatus> $completion) {
        CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
        ModalityState modalityState = ModalityState.current();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"current(...)");
        return BuildersKt.withContext((CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super SshConnectStatus>, Object>(credentials, null){
            int label;
            final /* synthetic */ RemoteCredentials $credentials;
            {
                this.$credentials = $credentials;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = BackgroundProgressCoroutineUtilKt.withModalProgressContext$default((String)GatewayBundle.INSTANCE.message("ssh.deploy.checkingConnection.title", new Object[0]), (boolean)false, null, (Function2)((Function2)new Function2<ProgressCoroutineScope, Continuation<? super SshConnectStatus>, Object>(this.$credentials, null){
                            int label;
                            private /* synthetic */ Object L$0;
                            final /* synthetic */ RemoteCredentials $credentials;
                            {
                                this.$credentials = $credentials;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                ProgressCoroutineScope progressCoroutineScope = (ProgressCoroutineScope)this.L$0;
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void $this$withModalProgressContext;
                                        ResultKt.throwOnFailure((Object)$result);
                                        ProgressIndicator progressIndicator = $this$withModalProgressContext.getIndicator();
                                        ProgressIndicatorEx progressIndicatorEx = progressIndicator instanceof ProgressIndicatorEx ? (ProgressIndicatorEx)progressIndicator : null;
                                        if (progressIndicatorEx != null) {
                                            ProgressIndocatorExKt.subscribeOnCancel((ProgressIndicatorEx)progressIndicatorEx, checkSshConnectionUnderModalProgress.1::invokeSuspend$lambda$0);
                                        }
                                        return SshConnectionCheckUtil.checkSshConnection$default(SshConnectionCheckUtil.INSTANCE, this.$credentials, false, 2, null);
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(ProgressCoroutineScope p1, Continuation<? super SshConnectStatus> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }

                            private static final Unit invokeSuspend$lambda$0() {
                                GatewayUsagesCollector.INSTANCE.onCheckSshConnectionCanceled();
                                return Unit.INSTANCE;
                            }
                        }), (Continuation)((Continuation)this), (int)6, null);
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super SshConnectStatus> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SshConnectionCheckUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        SshConnectionCheckUtil.logger = logger;
    }
}

