/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.handler.singular;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import de.plushnikov.intellij.plugin.processor.handler.BuilderHandler;
import de.plushnikov.intellij.plugin.processor.handler.BuilderInfo;
import de.plushnikov.intellij.plugin.processor.handler.singular.BuilderElementHandler;
import de.plushnikov.intellij.plugin.psi.LombokLightFieldBuilder;
import de.plushnikov.intellij.plugin.psi.LombokLightMethodBuilder;
import de.plushnikov.intellij.plugin.psi.LombokLightParameter;
import de.plushnikov.intellij.plugin.thirdparty.CapitalizationStrategy;
import de.plushnikov.intellij.plugin.thirdparty.LombokAddNullAnnotations;
import de.plushnikov.intellij.plugin.thirdparty.LombokCopyableAnnotations;
import de.plushnikov.intellij.plugin.thirdparty.LombokUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NonSingularHandler
implements BuilderElementHandler {
    NonSingularHandler() {
    }

    @Override
    public Collection<PsiField> renderBuilderFields(@NotNull BuilderInfo info) {
        if (info == null) {
            NonSingularHandler.$$$reportNull$$$0(0);
        }
        ArrayList<PsiField> result = new ArrayList<PsiField>();
        result.add((PsiField)new LombokLightFieldBuilder(info.getManager(), info.renderFieldName(), info.getFieldType()).withContainingClass(info.getBuilderClass()).withModifier("private").withNavigationElement((PsiElement)info.getVariable()));
        if (info.hasBuilderDefaultAnnotation()) {
            result.add((PsiField)new LombokLightFieldBuilder(info.getManager(), info.renderFieldDefaultSetName(), (PsiType)PsiTypes.booleanType()).withContainingClass(info.getBuilderClass()).withModifier("private").withNavigationElement((PsiElement)info.getVariable()));
        }
        return result;
    }

    @Override
    public Collection<PsiMethod> renderBuilderMethod(@NotNull BuilderInfo info, Map<String, List<List<PsiType>>> alreadyExistedMethods) {
        if (info == null) {
            NonSingularHandler.$$$reportNull$$$0(1);
        }
        if (BuilderHandler.matchMethodWithParams(alreadyExistedMethods, this.calcBuilderMethodName(info), List.of(info.getFieldType()))) {
            return Collections.emptyList();
        }
        String blockText = NonSingularHandler.getAllMethodBody(info);
        String methodName = this.calcBuilderMethodName(info);
        LombokLightMethodBuilder methodBuilder = new LombokLightMethodBuilder(info.getManager(), methodName).withContainingClass(info.getBuilderClass()).withMethodReturnType(info.getBuilderType()).withParameter(info.getFieldName(), info.getFieldType()).withNavigationElement((PsiElement)info.getVariable()).withModifier(info.getVisibilityModifier()).withAnnotations(info.getAnnotations()).withWriteAccess().withBodyText(blockText);
        LombokLightParameter setterParameter = methodBuilder.getParameterList().getParameter(0);
        PsiVariable psiVariable = info.getVariable();
        if (psiVariable instanceof PsiField) {
            PsiField psiField = (PsiField)psiVariable;
            if (null != setterParameter) {
                LombokCopyableAnnotations.copyCopyableAnnotations(psiField, setterParameter.getModifierList(), LombokCopyableAnnotations.BASE_COPYABLE);
            }
            LombokCopyableAnnotations.copyCopyableAnnotations(psiField, methodBuilder.getModifierList(), LombokCopyableAnnotations.COPY_TO_SETTER);
        } else {
            if (null != setterParameter) {
                LombokCopyableAnnotations.copyCopyableAnnotations((PsiModifierListOwner)info.getVariable(), info.getBuilderClass(), setterParameter.getModifierList(), LombokCopyableAnnotations.BASE_COPYABLE);
            }
            LombokCopyableAnnotations.copyCopyableAnnotations((PsiModifierListOwner)info.getVariable(), info.getBuilderClass(), methodBuilder.getModifierList(), LombokCopyableAnnotations.COPY_TO_SETTER);
        }
        LombokAddNullAnnotations.createRelevantNonNullAnnotation(info.getNullAnnotationLibrary(), methodBuilder);
        return Collections.singleton(methodBuilder);
    }

    @Override
    public List<String> getBuilderMethodNames(@NotNull String fieldName, @NotNull String prefix, @Nullable PsiAnnotation singularAnnotation, CapitalizationStrategy capitalizationStrategy) {
        if (fieldName == null) {
            NonSingularHandler.$$$reportNull$$$0(2);
        }
        if (prefix == null) {
            NonSingularHandler.$$$reportNull$$$0(3);
        }
        return Collections.singletonList(LombokUtils.buildAccessorName(prefix, fieldName, capitalizationStrategy));
    }

    @Override
    public String createSingularName(PsiAnnotation singularAnnotation, String psiFieldName) {
        return psiFieldName;
    }

    private static String getAllMethodBody(@NotNull BuilderInfo info) {
        if (info == null) {
            NonSingularHandler.$$$reportNull$$$0(4);
        }
        StringBuilder codeBlockTemplate = new StringBuilder("this.{0} = {1};\n");
        if (info.hasBuilderDefaultAnnotation()) {
            codeBlockTemplate.append("this.{2} = true;\n");
        }
        codeBlockTemplate.append("return {3};");
        return MessageFormat.format(codeBlockTemplate.toString(), info.renderFieldName(), info.getFieldName(), info.renderFieldDefaultSetName(), info.getBuilderChainResult());
    }

    @Override
    public String renderBuildPrepare(@NotNull BuilderInfo info) {
        if (info == null) {
            NonSingularHandler.$$$reportNull$$$0(5);
        }
        if (info.hasBuilderDefaultAnnotation()) {
            return MessageFormat.format("{0} {1} = this.{1};\nif (!this.{2}) '{'\n  {1} = {4}.{3}();\n'}'", info.getFieldType().getCanonicalText(false), info.renderFieldName(), info.renderFieldDefaultSetName(), info.renderFieldDefaultProviderName(), info.getBuilderClass().getContainingClass().getName());
        }
        return "";
    }

    @Override
    public String renderBuildCall(@NotNull BuilderInfo info) {
        if (info == null) {
            NonSingularHandler.$$$reportNull$$$0(6);
        }
        if (info.hasBuilderDefaultAnnotation()) {
            return info.renderFieldName();
        }
        return "this." + info.renderFieldName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
        }
        objectArray2[1] = "de/plushnikov/intellij/plugin/processor/handler/singular/NonSingularHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "renderBuilderFields";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "renderBuilderMethod";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getBuilderMethodNames";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getAllMethodBody";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "renderBuildPrepare";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "renderBuildCall";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

