/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi;

import com.intellij.freemarker.psi.FtlResolveResult;
import com.intellij.freemarker.psi.directives.FtlAssignmentDeclaration;
import com.intellij.freemarker.psi.directives.FtlAssignmentType;
import com.intellij.freemarker.psi.variables.FtlVariable;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.resolve.JavaMethodResolveHelper;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class FtlAssignmentResolver {
    private final Map<String, List<FtlResolveResult>> myNewMap = new HashMap<String, List<FtlResolveResult>>();
    private final Map<String, List<FtlResolveResult>> myOldMap = new HashMap<String, List<FtlResolveResult>>();

    public void addAssignment(FtlVariable declaration, boolean error, FtlAssignmentType type) {
        if (this.myOldMap.containsKey(declaration.getName())) {
            return;
        }
        SmartList list = this.myNewMap.get(declaration.getName());
        if (list == null) {
            list = new SmartList();
            this.myNewMap.put(declaration.getName(), (List<FtlResolveResult>)list);
        }
        Iterator<FtlResolveResult> iterator = list.iterator();
        while (iterator.hasNext()) {
            FtlResolveResult resolveResult = iterator.next();
            FtlVariable variable = (FtlVariable)resolveResult.getElement();
            FtlAssignmentType oldOrdinal = variable instanceof FtlAssignmentDeclaration ? ((FtlAssignmentDeclaration)variable).getDirective().getType() : FtlAssignmentType.LOCAL;
            int result = oldOrdinal.compareTo(type);
            if (result < 0) {
                return;
            }
            if (result == 0 && (error || resolveResult.getResolveError() == JavaMethodResolveHelper.ErrorType.NONE)) {
                return;
            }
            iterator.remove();
        }
        list.add(new FtlResolveResult(declaration, error ? JavaMethodResolveHelper.ErrorType.RESOLVE : JavaMethodResolveHelper.ErrorType.NONE, PsiSubstitutor.EMPTY));
    }

    public void handleLevelChange() {
        this.myOldMap.putAll(this.myNewMap);
        this.myNewMap.clear();
    }

    public Collection<FtlResolveResult> getResults() {
        this.handleLevelChange();
        return ContainerUtil.concat(this.myOldMap.values());
    }
}

