/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssSupportLoader;
import com.intellij.psi.css.browse.BrowseCssStylesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;

public class ShowAppliedStylesAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ShowAppliedStylesAction.$$$reportNull$$$0(0);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (file == null) {
            return;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return;
        }
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
        BrowseCssStylesManager browseCssStylesManager = BrowseCssStylesManager.getInstance(project);
        if (browseCssStylesManager != null && tag != null) {
            browseCssStylesManager.addStylesTab(tag);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        boolean enabled;
        if (e == null) {
            ShowAppliedStylesAction.$$$reportNull$$$0(1);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        boolean bl = enabled = project != null && file != null && CssSupportLoader.isInFileThatSupportsEmbeddedCss((PsiElement)file);
        if (enabled) {
            enabled = false;
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            if (editor != null) {
                XmlTag tag;
                int offset = editor.getCaretModel().getOffset();
                PsiElement element = InjectedLanguageManager.getInstance((Project)project).findInjectedElementAt(file, offset);
                if (element == null) {
                    element = file.findElementAt(offset);
                }
                if ((tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class)) != null && tag.getContainingFile() instanceof XmlFile) {
                    TextRange textRange = tag.getValue().getTextRange();
                    enabled = !textRange.contains(offset);
                }
            }
        }
        e.getPresentation().setEnabledAndVisible(enabled);
        e.getPresentation().setText(CssBundle.messagePointer((String)"show.applied.styles.for.tag.action.name", (Object[])new Object[0]));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ShowAppliedStylesAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/actions/ShowAppliedStylesAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/actions/ShowAppliedStylesAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

