/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.repository;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jpa.jpb.model.core.backend.LibraryModificationTracker;
import com.intellij.jpa.jpb.model.core.multilanguage.SupportedLanguagesManager;
import com.intellij.jpa.jpb.model.util.EntityUtil;
import com.intellij.jpa.jpb.model.util.HPsiUtil;
import com.intellij.jpa.jpb.model.util.QueryUtil;
import com.intellij.lang.jvm.annotation.JvmAnnotationAttribute;
import com.intellij.lang.jvm.annotation.JvmAnnotationAttributeValue;
import com.intellij.lang.jvm.annotation.JvmAnnotationClassValue;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.EmptyQuery;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 $2\u00020\u0001:\u0001$B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nJ\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ&\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\bJ\u001e\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0014\u0010\u0015\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u00170\u0016J\u000e\u0010\u0019\u001a\u0004\u0018\u00010\b*\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u0014H\u0002J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u0014H\u0002J&\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\b0!H\u0002J\u001c\u0010\"\u001a\b\u0012\u0004\u0012\u00020\b0#2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/jpa/jpb/model/repository/RepositorySearch;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getRepositories", "", "Lcom/intellij/psi/PsiClass;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "entityFqn", "", "includeNoRepositoryBeans", "", "getRepositoriesByParent", "parentRepoFqn", "getDomainClass", "repositoryClass", "getDomainType", "Lcom/intellij/psi/PsiClassType;", "superTypesOwner", "Lkotlin/Function0;", "", "Lcom/intellij/psi/PsiType;", "classAttributeValue", "Lcom/intellij/lang/jvm/annotation/JvmAnnotationAttribute;", "isRepositoryDefinition", "classType", "isRepositoryType", "walkRepositoryClasses", "", "processor", "Lcom/intellij/util/Processor;", "getRepositoriesQuery", "Lcom/intellij/util/Query;", "Companion", "intellij.javaee.jpa.jpb.model"})
@SourceDebugExtension(value={"SMAP\nRepositorySearch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RepositorySearch.kt\ncom/intellij/jpa/jpb/model/repository/RepositorySearch\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,186:1\n295#2,2:187\n19#3:189\n19#3:190\n13#4:191\n*S KotlinDebug\n*F\n+ 1 RepositorySearch.kt\ncom/intellij/jpa/jpb/model/repository/RepositorySearch\n*L\n131#1:187,2\n147#1:189\n149#1:190\n174#1:191\n*E\n"})
public final class RepositorySearch {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    public static final String REPOSITORY_DEFINITION = "org.springframework.data.repository.RepositoryDefinition";
    @NotNull
    public static final String SPRING_DATA_REPOSITORY_FQN = "org.springframework.data.repository.Repository";
    @NotNull
    public static final String JPA_REPOSITORY_FQN = "org.springframework.data.jpa.repository.JpaRepository";
    @NotNull
    public static final String MONGODB_REPOSITORY_FQN = "org.springframework.data.mongodb.repository.MongoRepository";
    @NotNull
    private static final Map<String, Key<CachedValue<SmartPsiElementPointer<PsiClass>>>> cacheKeysMap = new ConcurrentHashMap();

    public RepositorySearch(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Collection<PsiClass> getRepositories(@NotNull GlobalSearchScope scope, @NotNull String entityFqn) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)entityFqn, (String)"entityFqn");
        List result = new ArrayList();
        this.walkRepositoryClasses(scope, SPRING_DATA_REPOSITORY_FQN, (Processor<PsiClass>)((Processor)arg_0 -> RepositorySearch.getRepositories$lambda$0(this, entityFqn, result, arg_0)));
        return result;
    }

    @NotNull
    public final Collection<PsiClass> getRepositories(@NotNull GlobalSearchScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return this.getRepositories(scope, true);
    }

    @NotNull
    public final Collection<PsiClass> getRepositories(@NotNull GlobalSearchScope scope, boolean includeNoRepositoryBeans) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return this.getRepositoriesByParent(scope, SPRING_DATA_REPOSITORY_FQN, includeNoRepositoryBeans);
    }

    @NotNull
    public final Collection<PsiClass> getRepositoriesByParent(@NotNull GlobalSearchScope scope, @NotNull String parentRepoFqn, boolean includeNoRepositoryBeans) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)parentRepoFqn, (String)"parentRepoFqn");
        List result = new ArrayList();
        this.walkRepositoryClasses(scope, parentRepoFqn, (Processor<PsiClass>)((Processor)arg_0 -> RepositorySearch.getRepositoriesByParent$lambda$0(includeNoRepositoryBeans, result, arg_0)));
        return result;
    }

    public static /* synthetic */ Collection getRepositoriesByParent$default(RepositorySearch repositorySearch, GlobalSearchScope globalSearchScope, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return repositorySearch.getRepositoriesByParent(globalSearchScope, string, bl);
    }

    @Nullable
    public final PsiClass getDomainClass(@NotNull PsiClass repositoryClass) {
        Intrinsics.checkNotNullParameter((Object)repositoryClass, (String)"repositoryClass");
        PsiClassType psiClassType = this.getDomainType((Function0<? extends PsiType[]>)((Function0)() -> RepositorySearch.getDomainClass$lambda$0(repositoryClass)));
        if (psiClassType == null) {
            return null;
        }
        PsiClassType domainType = psiClassType;
        return domainType.resolve();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final PsiClassType getDomainType(@NotNull Function0<? extends PsiType[]> superTypesOwner) {
        Intrinsics.checkNotNullParameter(superTypesOwner, (String)"superTypesOwner");
        for (PsiType classType : (PsiType[])superTypesOwner.invoke()) {
            block8: {
                Iterable iterable;
                block10: {
                    block9: {
                        Object v1;
                        block7: {
                            void $this$firstOrNull$iv;
                            List list;
                            String interfaceName;
                            if (!(classType instanceof PsiClassType)) continue;
                            Intrinsics.checkNotNullExpressionValue((Object)((PsiClassType)classType).getName(), (String)"getName(...)");
                            if (Intrinsics.areEqual((Object)"Object", (Object)interfaceName)) continue;
                            if (this.isRepositoryType((PsiClassType)classType)) {
                                if (((PsiClassType)classType).getParameterCount() <= 0) continue;
                                PsiType psiType = ((PsiClassType)classType).getParameters()[0];
                                return psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
                            }
                            if (!this.isRepositoryDefinition((PsiClassType)classType)) break block8;
                            PsiClass psiClass = ((PsiClassType)classType).resolve();
                            if (psiClass == null) {
                                return null;
                            }
                            PsiClass psiClass2 = psiClass;
                            PsiAnnotation psiAnnotation = psiClass2.getAnnotation(REPOSITORY_DEFINITION);
                            if (psiAnnotation == null || (list = psiAnnotation.getAttributes()) == null) break block9;
                            iterable = list;
                            boolean $i$f$firstOrNull = false;
                            for (Object element$iv : $this$firstOrNull$iv) {
                                JvmAnnotationAttribute it = (JvmAnnotationAttribute)element$iv;
                                boolean bl = false;
                                if (!Intrinsics.areEqual((Object)it.getAttributeName(), (Object)"domainClass")) continue;
                                v1 = element$iv;
                                break block7;
                            }
                            v1 = null;
                        }
                        JvmAnnotationAttribute jvmAnnotationAttribute = v1;
                        if (jvmAnnotationAttribute != null && (iterable = this.classAttributeValue(jvmAnnotationAttribute)) != null) break block10;
                    }
                    return null;
                }
                Iterable domainClass = iterable;
                return PsiTypesUtil.getClassType((PsiClass)domainClass);
            }
            PsiClassType type = this.getDomainType((Function0<? extends PsiType[]>)((Function0)() -> RepositorySearch.getDomainType$lambda$1(classType)));
            if (type == null) continue;
            return type;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final PsiClass classAttributeValue(JvmAnnotationAttribute $this$classAttributeValue) {
        void $this$asSafely$iv;
        JvmAnnotationClassValue jvmAnnotationClassValue;
        void $this$asSafely$iv2;
        JvmAnnotationAttributeValue jvmAnnotationAttributeValue = $this$classAttributeValue.getAttributeValue();
        if (jvmAnnotationAttributeValue == null) return null;
        JvmAnnotationAttributeValue jvmAnnotationAttributeValue2 = jvmAnnotationAttributeValue;
        boolean $i$f$asSafely22 = false;
        Object v0 = $this$asSafely$iv2;
        if (!(v0 instanceof JvmAnnotationClassValue)) {
            v0 = null;
        }
        if ((jvmAnnotationClassValue = (JvmAnnotationClassValue)v0) == null) return null;
        jvmAnnotationAttributeValue2 = jvmAnnotationClassValue.getClazz();
        if (jvmAnnotationAttributeValue2 == null) return null;
        JvmAnnotationAttributeValue $i$f$asSafely22 = jvmAnnotationAttributeValue2;
        boolean $i$f$asSafely = false;
        Object v1 = $this$asSafely$iv;
        if (!(v1 instanceof PsiClass)) {
            v1 = null;
        }
        PsiClass psiClass = v1;
        return psiClass;
    }

    private final boolean isRepositoryDefinition(PsiClassType classType) {
        PsiClass psiClass = classType.resolve();
        if (psiClass == null) {
            return false;
        }
        PsiClass psiClass2 = psiClass;
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)psiClass2), (String)REPOSITORY_DEFINITION, (int)1);
    }

    private final boolean isRepositoryType(PsiClassType classType) {
        if (!Intrinsics.areEqual((Object)classType.getClassName(), (Object)"Repository")) {
            return false;
        }
        PsiClass resolved = classType.resolve();
        return resolved != null && Intrinsics.areEqual((Object)SPRING_DATA_REPOSITORY_FQN, (Object)resolved.getQualifiedName());
    }

    private final void walkRepositoryClasses(GlobalSearchScope scope, String parentRepoFqn, Processor<PsiClass> processor) {
        EntityUtil.ra(() -> RepositorySearch.walkRepositoryClasses$lambda$0(this, scope, parentRepoFqn, processor));
    }

    @NotNull
    public final Query<PsiClass> getRepositoriesQuery(@NotNull GlobalSearchScope scope, @NotNull String parentRepoFqn) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)parentRepoFqn, (String)"parentRepoFqn");
        PsiClass psiClass = Companion.getSpringDataRepositoryPsiClass(this.project, parentRepoFqn);
        if (psiClass == null) {
            Query query = EmptyQuery.getEmptyQuery();
            Intrinsics.checkNotNullExpressionValue((Object)query, (String)"getEmptyQuery(...)");
            return query;
        }
        PsiClass repositoryClass = psiClass;
        Query query = ClassInheritorsSearch.search((PsiClass)repositoryClass, (SearchScope)((SearchScope)scope), (boolean)true, (boolean)true, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"search(...)");
        Query baseQuery = query;
        Query<PsiClass> query2 = QueryUtil.uniqueByFqn((Query<PsiClass>)baseQuery);
        Intrinsics.checkNotNullExpressionValue(query2, (String)"uniqueByFqn(...)");
        return query2;
    }

    private static final boolean getRepositories$lambda$0(RepositorySearch this$0, String $entityFqn, List $result, PsiClass it) {
        PsiClassType repositoryDomainType = this$0.getDomainType((Function0<? extends PsiType[]>)((Function0)() -> RepositorySearch.getRepositories$lambda$0$0(it)));
        if (repositoryDomainType != null && repositoryDomainType.equalsToText($entityFqn)) {
            Intrinsics.checkNotNull((Object)it);
            $result.add(it);
        }
        return true;
    }

    private static final PsiType[] getRepositories$lambda$0$0(PsiClass $it) {
        PsiClassType[] psiClassTypeArray = $it.getSuperTypes();
        Intrinsics.checkNotNullExpressionValue((Object)psiClassTypeArray, (String)"getSuperTypes(...)");
        return (PsiType[])psiClassTypeArray;
    }

    private static final boolean getRepositoriesByParent$lambda$0(boolean $includeNoRepositoryBeans, List $result, PsiClass it) {
        if ($includeNoRepositoryBeans || !it.hasAnnotation("org.springframework.data.repository.NoRepositoryBean")) {
            Intrinsics.checkNotNull((Object)it);
            $result.add(it);
        }
        return true;
    }

    private static final PsiType[] getDomainClass$lambda$0(PsiClass $repositoryClass) {
        PsiClassType[] psiClassTypeArray = $repositoryClass.getSuperTypes();
        Intrinsics.checkNotNullExpressionValue((Object)psiClassTypeArray, (String)"getSuperTypes(...)");
        return (PsiType[])psiClassTypeArray;
    }

    private static final PsiType[] getDomainType$lambda$1(PsiType $classType) {
        PsiType[] psiTypeArray = ((PsiClassType)$classType).getSuperTypes();
        Intrinsics.checkNotNullExpressionValue((Object)psiTypeArray, (String)"getSuperTypes(...)");
        return psiTypeArray;
    }

    private static final void walkRepositoryClasses$lambda$0(RepositorySearch this$0, GlobalSearchScope $scope, String $parentRepoFqn, Processor $processor) {
        try {
            this$0.getRepositoriesQuery($scope, $parentRepoFqn).forEach($processor);
        }
        catch (IndexNotReadyException e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(RepositorySearch.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Index not ready exception during repositories search", (Throwable)e);
        }
    }

    @JvmStatic
    @NotNull
    public static final RepositorySearch getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @JvmStatic
    public static final boolean isRepository(@NotNull PsiFile file) {
        return Companion.isRepository(file);
    }

    @JvmStatic
    public static final boolean isRepository(@NotNull PsiClass repositoryClass) {
        return Companion.isRepository(repositoryClass);
    }

    @JvmStatic
    @Nullable
    public static final PsiClass getRepositoryClass(@Nullable PsiFile file) {
        return Companion.getRepositoryClass(file);
    }

    @JvmStatic
    @Nullable
    public static final PsiClass getSpringDataRepositoryPsiClass(@NotNull Project project, @NotNull String fqn) {
        return Companion.getSpringDataRepositoryPsiClass(project, fqn);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u000eH\u0007J\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0007J\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u001a\u001a\u00020\u0005H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R.\u0010\t\u001a\"\u0012\u0004\u0012\u00020\u0005\u0012\u0018\u0012\u0016\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r0\f0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/jpa/jpb/model/repository/RepositorySearch$Companion;", "", "<init>", "()V", "REPOSITORY_DEFINITION", "", "SPRING_DATA_REPOSITORY_FQN", "JPA_REPOSITORY_FQN", "MONGODB_REPOSITORY_FQN", "cacheKeysMap", "", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/psi/util/CachedValue;", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiClass;", "getInstance", "Lcom/intellij/jpa/jpb/model/repository/RepositorySearch;", "project", "Lcom/intellij/openapi/project/Project;", "isRepository", "", "file", "Lcom/intellij/psi/PsiFile;", "repositoryClass", "getRepositoryClass", "getSpringDataRepositoryPsiClass", "fqn", "intellij.javaee.jpa.jpb.model"})
    @SourceDebugExtension(value={"SMAP\nRepositorySearch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RepositorySearch.kt\ncom/intellij/jpa/jpb/model/repository/RepositorySearch$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,186:1\n30#2,2:187\n1#3:189\n382#4,7:190\n*S KotlinDebug\n*F\n+ 1 RepositorySearch.kt\ncom/intellij/jpa/jpb/model/repository/RepositorySearch$Companion\n*L\n43#1:187,2\n65#1:190,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final RepositorySearch getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<RepositorySearch> serviceClass$iv = RepositorySearch.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (RepositorySearch)object;
        }

        @JvmStatic
        public final boolean isRepository(@NotNull PsiFile file) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            PsiClass psiClass = this.getRepositoryClass(file);
            if (psiClass != null) {
                PsiClass it = psiClass;
                boolean bl2 = false;
                bl = Companion.isRepository(it);
            } else {
                bl = false;
            }
            return bl;
        }

        @JvmStatic
        public final boolean isRepository(@NotNull PsiClass repositoryClass) {
            Intrinsics.checkNotNullParameter((Object)repositoryClass, (String)"repositoryClass");
            if (!SupportedLanguagesManager.Companion.isElementSupported((PsiElement)repositoryClass)) {
                return false;
            }
            Project project = repositoryClass.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            PsiClass psiClass = com.intellij.jpa.jpb.model.repository.RepositorySearch$Companion.getSpringDataRepositoryPsiClass$default(this, project, null, 2, null);
            if (psiClass == null) {
                return false;
            }
            PsiClass springDataRepository = psiClass;
            return repositoryClass.isInheritor(springDataRepository, true);
        }

        @JvmStatic
        @Nullable
        public final PsiClass getRepositoryClass(@Nullable PsiFile file) {
            PsiClass psiClass = HPsiUtil.getFirstClass(file);
            return psiClass != null && this.isRepository(psiClass) ? psiClass : null;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @Nullable
        public final PsiClass getSpringDataRepositoryPsiClass(@NotNull Project project, @NotNull String fqn) {
            SmartPsiElementPointer pointer;
            Object object;
            void $this$getOrPut$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)fqn, (String)"fqn");
            Map map = cacheKeysMap;
            String key$iv = fqn;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                Key key = Key.create((String)fqn);
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
                Key answer$iv = key;
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            Key key = (Key)object;
            SmartPsiElementPointer smartPsiElementPointer = pointer = (SmartPsiElementPointer)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, key, () -> Companion.getSpringDataRepositoryPsiClass$lambda$1(project, fqn), false);
            return smartPsiElementPointer != null ? (PsiClass)smartPsiElementPointer.getElement() : null;
        }

        public static /* synthetic */ PsiClass getSpringDataRepositoryPsiClass$default(Companion companion, Project project, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = RepositorySearch.SPRING_DATA_REPOSITORY_FQN;
            }
            return companion.getSpringDataRepositoryPsiClass(project, string);
        }

        private static final CachedValueProvider.Result getSpringDataRepositoryPsiClass$lambda$1(Project $project, String $fqn) {
            PsiClass psiClass;
            PsiClass psiClass2 = psiClass = JavaPsiFacade.getInstance((Project)$project).findClass($fqn, GlobalSearchScope.allScope((Project)$project));
            Object[] objectArray = new Object[]{LibraryModificationTracker.Companion.getInstance($project)};
            return CachedValueProvider.Result.create((Object)(psiClass2 != null ? SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)psiClass2)) : null), (Object[])objectArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

