/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.backend.ed.annotation.attr;

import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.AbstractDynamicAttributeAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.JpaAttributeAnnotation;
import com.intellij.jpa.jpb.model.core.backend.ed.annotation.AnnotationModel;
import com.intellij.jpa.jpb.model.core.backend.ed.annotation.AnnotationModelBuilder;
import com.intellij.jpa.jpb.model.core.backend.ed.annotation.ArrayParameter;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.util.annotation.JoinColumn;
import com.intellij.openapi.project.Project;
import com.jgoodies.common.base.Strings;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/jpa/jpb/model/backend/ed/annotation/attr/CollectionTableAnnotation;", "Lcom/intellij/jpa/jpb/model/backend/ed/annotation/attr/AbstractDynamicAttributeAnnotation;", "<init>", "()V", "isInsert", "", "attribute", "Lcom/intellij/jpa/jpb/model/model/EntityAttribute;", "entity", "Lcom/intellij/jpa/jpb/model/model/Entity;", "generateModel", "Lcom/intellij/jpa/jpb/model/core/backend/ed/annotation/AnnotationModel;", "attr", "project", "Lcom/intellij/openapi/project/Project;", "knownAttributes", "", "", "intellij.javaee.jpa.jpb.model"})
public final class CollectionTableAnnotation
extends AbstractDynamicAttributeAnnotation {
    public CollectionTableAnnotation() {
        super(JpaAttributeAnnotation.CollectionTable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isInsert(@NotNull EntityAttribute attribute, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (!attribute.isElementCollection()) return false;
        List<JoinColumn> list = attribute.getCollectionTableJoinColumns();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getCollectionTableJoinColumns(...)");
        if (!((Collection)list).isEmpty()) {
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        if (Strings.isEmpty((String)attribute.getCollectionTable())) return false;
        return true;
    }

    @Override
    @NotNull
    public AnnotationModel generateModel(@NotNull EntityAttribute attr, @NotNull Entity entity, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)attr, (String)"attr");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        AnnotationModelBuilder builder = new AnnotationModelBuilder(((JpaAttributeAnnotation)this.getDescriptor()).getFqn(project, entity.getModule()));
        Object object = attr.getCollectionTable();
        if (!(object == null || object.length() == 0)) {
            AnnotationModelBuilder.add$default(builder, "name", attr.getCollectionTable(), false, 4, null);
        }
        if (!((object = (Collection)attr.getCollectionTableJoinColumns()) == null || object.isEmpty())) {
            EntityAttribute idAttribute = entity.getIdAttributeOrNull();
            if (attr.getCollectionTableJoinColumns().size() == 1 && idAttribute != null && !idAttribute.isCompKeyType() && !idAttribute.isEmbedded()) {
                List<JoinColumn> list = attr.getCollectionTableJoinColumns();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getCollectionTableJoinColumns(...)");
                JoinColumn joinColumn = (JoinColumn)CollectionsKt.firstOrNull(list);
                if (joinColumn == null) {
                    return builder.build();
                }
                JoinColumn joinColumn2 = joinColumn;
                AnnotationModelBuilder jcBuilder = new AnnotationModelBuilder(JpaAttributeAnnotation.JoinColumn.getFqn(project, entity.getModule()));
                AnnotationModel joinColumnAnn = AnnotationModelBuilder.add$default(jcBuilder, "name", joinColumn2.getName(), false, 4, null).build();
                builder.add("joinColumns", new ArrayParameter(CollectionsKt.listOf((Object)joinColumnAnn)));
            }
        }
        return builder.build();
    }

    @Override
    @NotNull
    public List<String> knownAttributes(@Nullable EntityAttribute attribute) {
        Object[] objectArray = new String[]{"name", "joinColumns"};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }
}

