/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.js;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.ide.CommandLineInspectionProjectConfigurator;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.execution.NodeTargetRunOptions;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.packageJson.PackageJsonFileManager;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunProfileState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.js.JsProjectConfiguratorKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0012\u0010\u0006\u001a\f0\u0005\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\"\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J8\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u0015H\u0002J\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u00112\b\u0010\u001e\u001a\u0004\u0018\u00010\u0011H\u0002J\u0014\u0010\u001f\u001a\u00020 *\u00020\u00112\u0006\u0010!\u001a\u00020\u0005H\u0002\u00a8\u0006\""}, d2={"Lorg/jetbrains/qodana/js/JsProjectConfigurator;", "Lcom/intellij/ide/CommandLineInspectionProjectConfigurator;", "<init>", "()V", "getName", "", "getDescription", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "preConfigureProject", "", "project", "Lcom/intellij/openapi/project/Project;", "context", "Lcom/intellij/ide/CommandLineInspectionProjectConfigurator$ConfiguratorContext;", "installDependency", "packageJson", "Lcom/intellij/openapi/vfs/VirtualFile;", "command", "Lcom/intellij/lang/javascript/buildTools/npm/rc/NpmCommand;", "configureCommandLine", "Lcom/intellij/javascript/nodejs/execution/NodeTargetRun;", "nodeInterpreter", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreter;", "npmPackageRef", "Lcom/intellij/javascript/nodejs/util/NodePackageRef;", "packageJsonPath", "prepareCommandLineYarnLock", "targetRun", "detectPackageManagerRefInDirectory", "dir", "exists", "", "filename", "intellij.qodana.js"})
@SourceDebugExtension(value={"SMAP\nJsProjectConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsProjectConfigurator.kt\norg/jetbrains/qodana/js/JsProjectConfigurator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n2423#2,14:102\n*S KotlinDebug\n*F\n+ 1 JsProjectConfigurator.kt\norg/jetbrains/qodana/js/JsProjectConfigurator\n*L\n44#1:102,14\n*E\n"})
public final class JsProjectConfigurator
implements CommandLineInspectionProjectConfigurator {
    @NotNull
    public String getName() {
        return "qodanaJsProjectConfigurator";
    }

    @NotNull
    public String getDescription() {
        String string = QodanaBundle.message("progress.message.qodana.js.npm.configuring", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void preConfigureProject(@NotNull Project project, @NotNull CommandLineInspectionProjectConfigurator.ConfiguratorContext context) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Registry.Companion.is("static.analysis.use.js.configurator")) {
            VirtualFile lockJsonFile = this.detectPackageManagerRefInDirectory(ProjectUtil.guessProjectDir((Project)project));
            if (lockJsonFile != null) {
                if (Intrinsics.areEqual((Object)lockJsonFile.getName(), (Object)"yarn.lock")) {
                    this.installDependency(project, lockJsonFile, NpmCommand.INSTALL);
                } else {
                    this.installDependency(project, lockJsonFile, NpmCommand.CI);
                }
            } else {
                Object v1;
                Set set = PackageJsonFileManager.getInstance((Project)project).getValidPackageJsonFiles();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getValidPackageJsonFiles(...)");
                Iterable $this$minByOrNull$iv = set;
                boolean $i$f$minByOrNull = false;
                Iterator iterator$iv = $this$minByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v1 = null;
                } else {
                    Object minElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v1 = minElem$iv;
                    } else {
                        VirtualFile it = (VirtualFile)minElem$iv;
                        boolean bl = false;
                        String string = it.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                        Comparable minValue$iv = (Comparable)((Object)string);
                        do {
                            Object e$iv = iterator$iv.next();
                            VirtualFile it2 = (VirtualFile)e$iv;
                            $i$a$-minByOrNull-JsProjectConfigurator$preConfigureProject$packageJson$1 = false;
                            String string2 = it2.getPath();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                            Comparable v$iv = (Comparable)((Object)string2);
                            if (minValue$iv.compareTo(v$iv) <= 0) continue;
                            minElem$iv = e$iv;
                            minValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v1 = minElem$iv;
                    }
                }
                VirtualFile packageJson = v1;
                this.installDependency(project, packageJson, NpmCommand.INSTALL);
            }
        }
    }

    private final void installDependency(Project project, VirtualFile packageJson, NpmCommand command) {
        if (packageJson == null) {
            return;
        }
        JsProjectConfiguratorKt.access$getLOG$p().info("Running install js dependency...");
        NodeJsInterpreter nodeJsInterpreter = NodeJsInterpreterManager.getInstance((Project)project).getInterpreterRef().resolveNotNull(project);
        Intrinsics.checkNotNullExpressionValue((Object)nodeJsInterpreter, (String)"resolveNotNull(...)");
        NodeJsInterpreter interpreter = nodeJsInterpreter;
        NodePackageRef nodePackageRef = NpmManager.getInstance((Project)project).getPackageRef();
        Intrinsics.checkNotNullExpressionValue((Object)nodePackageRef, (String)"getPackageRef(...)");
        NodePackageRef npmPkgRef = nodePackageRef;
        String string = packageJson.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        NodeTargetRun targetRun = this.configureCommandLine(interpreter, npmPkgRef, string, command, project, packageJson);
        CapturingProcessRunner runner = new CapturingProcessRunner(targetRun.startProcess());
        runner.runProcess();
        packageJson.getParent().refresh(false, true);
    }

    private final NodeTargetRun configureCommandLine(NodeJsInterpreter nodeInterpreter, NodePackageRef npmPackageRef, String packageJsonPath, NpmCommand command, Project project, VirtualFile packageJson) {
        NodeTargetRun targetRun = new NodeTargetRun(nodeInterpreter, project, null, NodeTargetRunOptions.Companion.of$default((NodeTargetRunOptions.Companion)NodeTargetRunOptions.Companion, (Boolean)true, null, null, (int)6, null), null, 16, null);
        List list2 = CollectionsKt.emptyList();
        EnvironmentVariablesData environmentVariablesData = EnvironmentVariablesData.DEFAULT;
        Intrinsics.checkNotNullExpressionValue((Object)environmentVariablesData, (String)"DEFAULT");
        NpmRunProfileState.Companion.configureCommandLine$default((NpmRunProfileState.Companion)NpmRunProfileState.Companion, (NodeTargetRun)targetRun, (String)"", (NodePackageRef)npmPackageRef, (String)packageJsonPath, (NpmCommand)command, (List)list2, (String)"", (EnvironmentVariablesData)environmentVariablesData, null, null, (int)512, null);
        this.prepareCommandLineYarnLock(packageJson, targetRun);
        return targetRun;
    }

    private final void prepareCommandLineYarnLock(VirtualFile packageJson, NodeTargetRun targetRun) {
        if (Intrinsics.areEqual((Object)packageJson.getName(), (Object)"yarn.lock")) {
            String[] stringArray = new String[]{"--immutable", "--immutable-cache", "--check-cache"};
            targetRun.getCommandLineBuilder().addParameters(stringArray);
        }
    }

    private final VirtualFile detectPackageManagerRefInDirectory(VirtualFile dir) {
        if (dir == null) {
            return null;
        }
        if (this.exists(dir, "yarn.lock")) {
            return dir.findChild("yarn.lock");
        }
        if (this.exists(dir, "package-lock.json")) {
            return dir.findChild("package-lock.json");
        }
        if (this.exists(dir, "npm-shrinkwrap")) {
            return dir.findChild("npm-shrinkwrap");
        }
        return null;
    }

    private final boolean exists(VirtualFile $this$exists, String filename) {
        VirtualFile child = $this$exists.findChild(filename);
        return child != null && !child.isDirectory();
    }
}

