/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.ssh.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remoteDev.util.SshLinkConnectionDetails;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.jetbrains.gateway.ssh.connection.RunInstalledDetails;
import com.jetbrains.gateway.ssh.dialogs.SshConnectionDialog;
import com.jetbrains.gateway.ssh.util.SshConnectStatus;
import com.jetbrains.gateway.ssh.util.SshConnectionCheckUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0086@\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013J0\u0010\u0014\u001a\u0004\u0018\u00010\u00072\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u00162\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/gateway/ssh/util/SshConfigCreationUtil;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "findSshConfig", "Lcom/intellij/ssh/config/unified/SshConfig;", "sshLinkConnectionDetails", "Lcom/intellij/remoteDev/util/SshLinkConnectionDetails;", "(Lcom/intellij/remoteDev/util/SshLinkConnectionDetails;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "runInstalledDetails", "Lcom/jetbrains/gateway/ssh/connection/RunInstalledDetails;", "getSshConfigFromDialogue", "generateSshConfigName", "", "host", "user", "port", "", "findConfigByParams", "configs", "", "intellij.gateway.core"})
@SourceDebugExtension(value={"SMAP\nSshConfigCreationUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshConfigCreationUtil.kt\ncom/jetbrains/gateway/ssh/util/SshConfigCreationUtil\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,75:1\n13#2:76\n*S KotlinDebug\n*F\n+ 1 SshConfigCreationUtil.kt\ncom/jetbrains/gateway/ssh/util/SshConfigCreationUtil\n*L\n11#1:76\n*E\n"})
public final class SshConfigCreationUtil {
    @NotNull
    public static final SshConfigCreationUtil INSTANCE = new SshConfigCreationUtil();
    @NotNull
    private static final Logger LOG;

    private SshConfigCreationUtil() {
    }

    @Nullable
    public final Object findSshConfig(@NotNull SshLinkConnectionDetails sshLinkConnectionDetails, @NotNull Continuation<? super SshConfig> $completion) throws IllegalStateException {
        String host2 = sshLinkConnectionDetails.getHost();
        String user = sshLinkConnectionDetails.getUser();
        int port = sshLinkConnectionDetails.getPort();
        SshConfigManager sshConfigManager = SshConfigManager.getInstance(null);
        Intrinsics.checkNotNullExpressionValue((Object)sshConfigManager, (String)"getInstance(...)");
        SshConfigManager sshConfigManager2 = sshConfigManager;
        List list = sshConfigManager2.getConfigs();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getConfigs(...)");
        SshConfig sshConfig = this.findConfigByParams(list, host2, user, port);
        if (sshConfig == null) {
            return null;
        }
        SshConfig config = sshConfig;
        RemoteCredentials remoteCredentials = config.copyToCredentials();
        Intrinsics.checkNotNullExpressionValue((Object)remoteCredentials, (String)"copyToCredentials(...)");
        RemoteCredentials credentials = remoteCredentials;
        SshConnectStatus connectionStatus = SshConnectionCheckUtil.checkSshConnection$default(SshConnectionCheckUtil.INSTANCE, credentials, false, 2, null);
        if (!connectionStatus.isSucceeded()) {
            return null;
        }
        return config;
    }

    @Nullable
    public final SshConfig findSshConfig(@NotNull RunInstalledDetails runInstalledDetails) {
        Intrinsics.checkNotNullParameter((Object)runInstalledDetails, (String)"runInstalledDetails");
        SshConfigManager sshConfigManager = SshConfigManager.getInstance(null);
        Intrinsics.checkNotNullExpressionValue((Object)sshConfigManager, (String)"getInstance(...)");
        SshConfigManager sshConfigManager2 = sshConfigManager;
        return sshConfigManager2.findConfigById(runInstalledDetails.getSshId());
    }

    @Nullable
    public final SshConfig getSshConfigFromDialogue(@NotNull SshLinkConnectionDetails sshLinkConnectionDetails) {
        Intrinsics.checkNotNullParameter((Object)sshLinkConnectionDetails, (String)"sshLinkConnectionDetails");
        String host2 = sshLinkConnectionDetails.getHost();
        String user = sshLinkConnectionDetails.getUser();
        int port = sshLinkConnectionDetails.getPort();
        SshConnectionDialog dialog2 = new SshConnectionDialog(host2, user, port);
        boolean isOk = dialog2.showAndGet();
        if (isOk) {
            return dialog2.getSshConfig();
        }
        LOG.info("Ssh connection canceled");
        return null;
    }

    @NotNull
    public final String generateSshConfigName(@NotNull String host2, @NotNull String user, int port) {
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        if (port == 22) {
            return user + "@" + host2;
        }
        return user + "@" + host2 + ":" + port;
    }

    private final SshConfig findConfigByParams(List<? extends SshConfig> configs, String host2, String user, int port) {
        for (SshConfig sshConfig : configs) {
            if (!StringsKt.equals((String)sshConfig.getHost(), (String)host2, (boolean)true) || !Intrinsics.areEqual((Object)sshConfig.getUsername(), (Object)user) || sshConfig.getPort() != port) continue;
            LOG.info("Found matching sshConfig '" + sshConfig.getName() + "'");
            return sshConfig;
        }
        LOG.info("SshConfig with username '" + host2 + "', host '" + user + "', port '" + port + "' not found");
        return null;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SshConfigCreationUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

