/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.table;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssMediaFeatureDescriptor;
import com.intellij.psi.css.CssMediaGroupAwareDescriptor;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.descriptor.CssContextType;
import com.intellij.psi.css.descriptor.CssElementDescriptor;
import com.intellij.psi.css.descriptor.CssMediaGroup;
import com.intellij.psi.css.descriptor.CssMediaType;
import com.intellij.psi.css.descriptor.CssPseudoSelectorDescriptor;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtilCore;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssDescriptorsUtil {
    public static final NotNullFunction<CssElementDescriptor, String> GET_DESCRIPTOR_ID_FUNCTION = CssElementDescriptor::getId;

    private CssDescriptorsUtil() {
    }

    public static String @NotNull [] getSimpleSelectors(@NotNull PsiElement context) {
        CssElementDescriptorProvider provider;
        if (context == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(0);
        }
        String[] stringArray = (provider = CssDescriptorsUtilCore.findDescriptorProvider((PsiElement)context)) != null ? provider.getSimpleSelectors(context) : ArrayUtilRt.EMPTY_STRING_ARRAY;
        if (stringArray == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(1);
        }
        return stringArray;
    }

    @NotNull
    public static Collection<? extends CssPropertyDescriptor> getAllPropertyDescriptors(@Nullable PsiElement context) {
        CssElementDescriptorProvider provider = CssDescriptorsUtilCore.findDescriptorProvider((PsiElement)context);
        Collection<Object> collection = provider != null ? provider.getAllPropertyDescriptors(context) : Collections.emptyList();
        if (collection == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    public static Collection<? extends CssPseudoSelectorDescriptor> getPseudoSelectorDescriptors(@NotNull String pseudoSelectorName, @Nullable PsiElement context) {
        CssElementDescriptorProvider provider;
        if (pseudoSelectorName == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(3);
        }
        Collection<Object> collection = (provider = CssDescriptorsUtilCore.findDescriptorProvider((PsiElement)context)) != null ? provider.findPseudoSelectorDescriptors(pseudoSelectorName, context) : Collections.emptyList();
        if (collection == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    public static Collection<? extends CssPropertyDescriptor> getPropertyDescriptors(@NotNull String propertyName, @Nullable PsiElement context) {
        CssElementDescriptorProvider provider;
        if (propertyName == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(5);
        }
        Collection<Object> collection = (provider = CssDescriptorsUtilCore.findDescriptorProvider((PsiElement)context)) != null ? provider.findPropertyDescriptors(propertyName, context) : Collections.emptyList();
        if (collection == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @Nullable
    public static CssPropertyDescriptor getPropertyAllDescriptor(@Nullable PsiElement context) {
        Collection<? extends CssPropertyDescriptor> allDescriptor = CssDescriptorsUtil.getPropertyDescriptors("all", context);
        if (allDescriptor.isEmpty() || !Objects.equals(allDescriptor.iterator().next().getInitialValue(), "see individual properties")) {
            return null;
        }
        return allDescriptor.iterator().next();
    }

    @NotNull
    public static Collection<? extends CssMediaFeatureDescriptor> getAllMediaFeatureDescriptors(@Nullable PsiElement context) {
        CssElementDescriptorProvider provider = CssDescriptorsUtilCore.findDescriptorProvider((PsiElement)context);
        Collection<Object> collection = provider != null ? provider.getAllMediaFeatureDescriptors(context) : Collections.emptyList();
        if (collection == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(7);
        }
        return collection;
    }

    @Deprecated
    @Nullable
    public static CssPropertyDescriptor getPropertyDescriptor(@NotNull String propertyName, @Nullable PsiElement context) {
        CssElementDescriptorProvider provider;
        if (propertyName == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(8);
        }
        return (provider = CssDescriptorsUtilCore.findDescriptorProvider((PsiElement)context)) != null ? provider.getPropertyDescriptor(propertyName, context) : null;
    }

    public static boolean isPossibleSelector(@NotNull String selector, @NotNull PsiElement context) {
        CssElementDescriptorProvider provider;
        if (selector == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(9);
        }
        if (context == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(10);
        }
        return (provider = CssDescriptorsUtilCore.findDescriptorProvider((PsiElement)context)) == null || provider.isPossibleSelector(selector, context);
    }

    @NotNull
    public static Collection<LocalQuickFix> getQuickFixesForUnknownSimpleSelector(@NotNull String selectorName, @NotNull PsiElement context, boolean isOnTheFly) {
        CssElementDescriptorProvider[] providers;
        if (selectorName == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(11);
        }
        if (context == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(12);
        }
        HashSet<LocalQuickFix> result = new HashSet<LocalQuickFix>();
        for (CssElementDescriptorProvider provider : providers = (CssElementDescriptorProvider[])CssElementDescriptorProvider.EP_NAME.getExtensions()) {
            Collections.addAll(result, provider.getQuickFixesForUnknownSimpleSelector(selectorName, context, isOnTheFly));
        }
        HashSet<LocalQuickFix> hashSet = result;
        if (hashSet == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(13);
        }
        return hashSet;
    }

    @NotNull
    public static Collection<LocalQuickFix> getQuickFixesForUnknownProperty(@NotNull String propertyName, @NotNull PsiElement context, boolean isOnTheFly) {
        CssElementDescriptorProvider[] providers;
        if (propertyName == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(14);
        }
        if (context == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(15);
        }
        HashSet<LocalQuickFix> result = new HashSet<LocalQuickFix>();
        for (CssElementDescriptorProvider provider : providers = (CssElementDescriptorProvider[])CssElementDescriptorProvider.EP_NAME.getExtensions()) {
            Collections.addAll(result, provider.getQuickFixesForUnknownProperty(propertyName, context, isOnTheFly));
        }
        HashSet<LocalQuickFix> hashSet = result;
        if (hashSet == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(16);
        }
        return hashSet;
    }

    @NotNull
    public static Collection<? extends CssPseudoSelectorDescriptor> getAllPseudoSelectorDescriptors(@Nullable PsiElement context) {
        CssElementDescriptorProvider provider = CssDescriptorsUtilCore.findDescriptorProvider((PsiElement)context);
        Collection<Object> collection = provider != null ? provider.getAllPseudoSelectorDescriptors(context) : Collections.emptyList();
        if (collection == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(17);
        }
        return collection;
    }

    @NotNull
    @NlsSafe
    public static String getCanonicalPropertyName(@NotNull CssDeclaration declaration) {
        String propertyName;
        CssPropertyDescriptor descriptor;
        if (declaration == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(18);
        }
        String string = (descriptor = CssDescriptorsUtil.getPropertyDescriptor(propertyName = declaration.getPropertyName(), (PsiElement)declaration)) != null ? descriptor.toCanonicalName(propertyName) : propertyName;
        if (string == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(19);
        }
        return string;
    }

    @Nullable
    public static <T extends CssElementDescriptor> T getDescriptorFromLatestSpec(Collection<T> descriptors) {
        CssElementDescriptor result = null;
        for (CssElementDescriptor descriptor : descriptors) {
            if (result != null && descriptor.getCssVersion().value() < result.getCssVersion().value()) continue;
            result = descriptor;
        }
        return (T)result;
    }

    public static String @NotNull [] extractDescriptorsIdsAsArray(Collection<? extends CssElementDescriptor> descriptors) {
        String[] stringArray = (String[])ContainerUtil.map2Array(descriptors, String.class, GET_DESCRIPTOR_ID_FUNCTION);
        if (stringArray == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(20);
        }
        return stringArray;
    }

    @NotNull
    public static <T extends CssMediaGroupAwareDescriptor> Collection<T> filterDescriptorsByMediaType(@NotNull Collection<T> descriptors, @Nullable PsiElement context) {
        Set<CssMediaType> allowedMediaTypes;
        if (descriptors == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(21);
        }
        if ((allowedMediaTypes = CssPsiUtil.getAllowedMediaTypesInContext(context)).contains(CssMediaType.ALL)) {
            Collection<T> collection = descriptors;
            if (collection == null) {
                CssDescriptorsUtil.$$$reportNull$$$0(22);
            }
            return collection;
        }
        boolean insidePageRule = false;
        CssAtRule atRule = (CssAtRule)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{CssAtRule.class});
        while (atRule != null) {
            if (atRule.getType() == CssContextType.PAGE || atRule.getType() == CssContextType.PAGE_MARGIN) {
                insidePageRule = true;
                break;
            }
            atRule = (CssAtRule)PsiTreeUtil.getParentOfType((PsiElement)atRule, CssAtRule.class);
        }
        boolean finalInsidePageRule = insidePageRule;
        List list = ContainerUtil.filter(descriptors, t -> {
            for (CssMediaType mediaType : allowedMediaTypes) {
                CssMediaGroup[] propertyMediaGroups;
                for (CssMediaGroup propertyMediaGroup : propertyMediaGroups = t.getMediaGroups()) {
                    if (propertyMediaGroup != CssMediaGroup.ALL && (!finalInsidePageRule || propertyMediaGroup != CssMediaGroup.PAGED) && !ArrayUtil.contains((Object)propertyMediaGroup, (Object[])mediaType.getSupportedGroups())) continue;
                    return true;
                }
            }
            return false;
        });
        if (list == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(23);
        }
        return list;
    }

    @NotNull
    public static <T extends CssElementDescriptor> Collection<T> filterDescriptorsByContext(@NotNull Collection<T> descriptors, @Nullable PsiElement context) {
        CssElementDescriptorProvider provider;
        CssContextType ruleType;
        if (descriptors == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(24);
        }
        CssContextType cssContextType = ruleType = (provider = CssDescriptorsUtilCore.findDescriptorProvider((PsiElement)context)) != null ? provider.getCssContextType(context) : CssContextType.ANY;
        if (ruleType == CssContextType.ANY) {
            Collection<T> collection = descriptors;
            if (collection == null) {
                CssDescriptorsUtil.$$$reportNull$$$0(25);
            }
            return collection;
        }
        List list = ContainerUtil.filter(descriptors, input -> input.isAllowedInContextType(ruleType));
        if (list == null) {
            CssDescriptorsUtil.$$$reportNull$$$0(26);
        }
        return list;
    }

    public static Collection<CssPseudoSelectorDescriptor> filterPseudoSelectorDescriptorsByColonPrefix(Collection<? extends CssPseudoSelectorDescriptor> descriptors, int prefixLength) {
        return ContainerUtil.filter(descriptors, input -> input.getColonPrefixLength() == prefixLength);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 6, 7, 13, 16, 17, 19, 20, 22, 23, 25, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pseudoSelectorName";
                break;
            }
            case 5: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectorName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/util/table/CssDescriptorsUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimpleSelectors";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPropertyDescriptors";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPseudoSelectorDescriptors";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyDescriptors";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMediaFeatureDescriptors";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixesForUnknownSimpleSelector";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixesForUnknownProperty";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPseudoSelectorDescriptors";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalPropertyName";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "extractDescriptorsIdsAsArray";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "filterDescriptorsByMediaType";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "filterDescriptorsByContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleSelectors";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPseudoSelectorDescriptors";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyDescriptors";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyDescriptor";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isPossibleSelector";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixesForUnknownSimpleSelector";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixesForUnknownProperty";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getCanonicalPropertyName";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "filterDescriptorsByMediaType";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "filterDescriptorsByContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 6, 7, 13, 16, 17, 19, 20, 22, 23, 25, 26 -> new IllegalStateException(string);
        };
    }
}

