/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.Es6MetaProperty;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.frameworks.amd.JSAmdPsiUtil;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCallLikeExpressionCommon;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSImplicitElementProviderImpl;
import com.intellij.lang.javascript.psi.stubs.JSCallExpressionStub;
import com.intellij.lang.javascript.psi.stubs.impl.StubTreeUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.stubs.StubElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSCallExpressionImpl
extends JSImplicitElementProviderImpl<JSCallExpressionStub>
implements JSCallExpression,
JSCallLikeExpressionCommon {
    public JSCallExpressionImpl(ASTNode node) {
        super(node);
    }

    public JSCallExpressionImpl(JSCallExpressionStub stub) {
        super(stub, JSElementTypes.CALL_EXPRESSION);
    }

    @Override
    public JSExpression getMethodExpression() {
        ASTNode node = JSCallExpressionImpl.getMethodExpression(this.getNode());
        return node != null ? (JSExpression)node.getPsi() : null;
    }

    @Nullable
    public static ASTNode getMethodExpression(@NotNull ASTNode callExpression) {
        if (callExpression == null) {
            JSCallExpressionImpl.$$$reportNull$$$0(0);
        }
        return callExpression.findChildByType(JSExtendedLanguagesTokenSetProvider.EXPRESSIONS);
    }

    @Override
    public JSExpression getStubSafeMethodExpression() {
        JSCallExpressionStub stub = (JSCallExpressionStub)this.getStub();
        if (stub != null) {
            if (!stub.keepsMethodExpression()) {
                return null;
            }
            StubElement<?> initializerStub = StubTreeUtil.findChildStubByType(stub, JSExtendedLanguagesTokenSetProvider.EXPRESSIONS, false);
            return initializerStub != null ? (JSExpression)initializerStub.getPsi() : null;
        }
        return this.getMethodExpression();
    }

    @Override
    @Nullable
    public JSArgumentList getArgumentList() {
        ASTNode argumentList = JSCallExpressionImpl.getArgumentList(this.getNode());
        return argumentList != null ? (JSArgumentList)argumentList.getPsi() : null;
    }

    @Nullable
    public static ASTNode getArgumentList(@NotNull ASTNode callExpressionNode) {
        if (callExpressionNode == null) {
            JSCallExpressionImpl.$$$reportNull$$$0(1);
        }
        return callExpressionNode.findChildByType(JSExtendedLanguagesTokenSetProvider.ARGUMENT_LISTS);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSCallExpressionImpl.$$$reportNull$$$0(2);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSCallExpression(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public JSExpression replace(@NotNull JSExpression other) {
        if (other == null) {
            JSCallExpressionImpl.$$$reportNull$$$0(3);
        }
        return JSChangeUtil.replaceExpression(this, other);
    }

    @Override
    public boolean isRequireCall() {
        JSCallExpressionStub stub = (JSCallExpressionStub)this.getGreenStub();
        if (stub != null) {
            return stub.isRequireCall();
        }
        return CommonJSUtil.calculateIsRequireCall(this);
    }

    @Override
    public boolean isDefineCall() {
        JSCallExpressionStub stub = (JSCallExpressionStub)this.getGreenStub();
        if (stub != null) {
            return stub.isDefineCall();
        }
        return JSAmdPsiUtil.isDefineCall(this);
    }

    @Override
    public boolean isElvis() {
        JSCallExpressionStub stub = (JSCallExpressionStub)this.getGreenStub();
        if (stub != null) {
            return stub.isElvisCall();
        }
        return this.getNode().findChildByType(JSTokenTypes.ELVIS) != null;
    }

    @Override
    public boolean isImportPhaseCall() {
        JSCallExpressionStub stub = (JSCallExpressionStub)this.getGreenStub();
        if (stub != null) {
            return stub.isImportPhaseCall();
        }
        JSExpression jSExpression = this.getMethodExpression();
        if (jSExpression instanceof Es6MetaProperty) {
            Es6MetaProperty property = (Es6MetaProperty)jSExpression;
            return property.isImportPhase();
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpressionNode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSCallExpressionImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getMethodExpression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getArgumentList";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "replace";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

