/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.codeInsight.TargetElementEvaluatorEx;
import com.intellij.codeInsight.TargetElementEvaluatorEx2;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbTargetUtil;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolService;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlReference;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DatabaseTargetElementEvaluator
extends TargetElementEvaluatorEx2
implements TargetElementEvaluatorEx {
    public static boolean isLegacyNavigateToSchema() {
        return Registry.is((String)"database.legacy.navigate.to.schema", (boolean)false);
    }

    @Nullable
    public PsiElement getGotoDeclarationTarget(@NotNull PsiElement element, @Nullable PsiElement navElement) {
        if (element == null) {
            DatabaseTargetElementEvaluator.$$$reportNull$$$0(0);
        }
        return (PsiElement)ObjectUtils.tryCast((Object)element, DbElement.class);
    }

    @NotNull
    public static NavigationItem getGotoDeclarationTarget(DbElement dbElement) {
        NavigationItem navigationItem = DatabaseTargetElementEvaluator.isLegacyNavigateToSchema() ? DbNavigationUtils.createToDatabaseViewNavigatable(dbElement) : DbNavigationUtils.createToSourceNavigatable(dbElement);
        if (navigationItem == null) {
            DatabaseTargetElementEvaluator.$$$reportNull$$$0(1);
        }
        return navigationItem;
    }

    public boolean isIdentifierPart(@NotNull PsiFile element, @NotNull CharSequence text, int offset) {
        PsiElement e;
        if (element == null) {
            DatabaseTargetElementEvaluator.$$$reportNull$$$0(2);
        }
        if (text == null) {
            DatabaseTargetElementEvaluator.$$$reportNull$$$0(3);
        }
        PsiElement p = (e = element.findElementAt(offset)) != null ? e.getParent() : null;
        return p instanceof SqlIdentifier || p instanceof SqlReferenceExpression && PsiUtilCore.getElementType((PsiElement)e) == SqlCommonTokens.SQL_ASTERISK;
    }

    @Nullable
    public PsiElement getElementByReference(@NotNull PsiReference ref, int flags) {
        if (ref == null) {
            DatabaseTargetElementEvaluator.$$$reportNull$$$0(4);
        }
        if (ref instanceof SqlReference) {
            SqlReference sqlReference = (SqlReference)ref;
            Symbol symbol = (Symbol)ContainerUtil.getFirstItem((Collection)sqlReference.resolveReference());
            return symbol == null ? null : PsiSymbolService.getInstance().extractElementFromSymbol(symbol);
        }
        return super.getElementByReference(ref, flags);
    }

    @Nullable
    public static OpenFileDescriptor getDescriptor(@NotNull DbElement dbElement) {
        VirtualFile file;
        if (dbElement == null) {
            DatabaseTargetElementEvaluator.$$$reportNull$$$0(5);
        }
        if ((file = DbTargetUtil.getContainingFile((DbElement)dbElement, (boolean)true)) == null) {
            return null;
        }
        Project project = dbElement.getProject();
        int offset = DbTargetUtil.calcTargetOffset((Project)project, (VirtualFile)file, (DasObject)dbElement);
        return new OpenFileDescriptor(project, file, offset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DatabaseTargetElementEvaluator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DatabaseTargetElementEvaluator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGotoDeclarationTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getGotoDeclarationTarget";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isIdentifierPart";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getElementByReference";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

