/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInspection.util.IntentionName;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.inspections.NewLineEraser;
import com.intellij.lang.javascript.intentions.CommentsMover;
import com.intellij.lang.javascript.intentions.JSInitializeFieldsIntentionBase;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSExplicifyFieldsIntention
extends JSInitializeFieldsIntentionBase {
    private static final String MOVE_TO_INITIALIZER = "JSExplicifyFields.moveToInitializer";
    private JCheckBox myCheckBox = null;

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"javascript.intention.explicit.fields", (Object[])new Object[0]);
        if (string == null) {
            JSExplicifyFieldsIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    @IntentionName
    protected String getSingleText() {
        String string = JavaScriptBundle.message((String)"javascript.intention.explicit.fields.single", (Object[])new Object[0]);
        if (string == null) {
            JSExplicifyFieldsIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected String getDialogTitle() {
        return JavaScriptBundle.message((String)"javascript.intention.explicit.fields.dialog.title", (Object[])new Object[0]);
    }

    @Override
    protected JSInitializeFieldsIntentionBase.ImplicitFields includeImplicitFields(PsiElement context2) {
        return JSInitializeFieldsIntentionBase.ImplicitFields.ONLY_IMPLICIT;
    }

    @Override
    protected boolean isPassingDialect(DialectOptionHolder dialect) {
        return dialect.isJavaScript();
    }

    @Override
    protected boolean isPassingLocation(@NotNull PsiElement element2, JSFunction function, JSParameterList parameterList) {
        if (element2 == null) {
            JSExplicifyFieldsIntention.$$$reportNull$$$0(2);
        }
        if (super.isPassingLocation(element2, function, parameterList)) {
            return true;
        }
        JSReferenceExpression ref2 = (JSReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)element2, JSReferenceExpression.class);
        return ref2 != null && ref2.getQualifier() instanceof JSThisExpression;
    }

    @Override
    @NotNull
    protected List<? extends PsiElement> collectNamedElements(JSFunction function, Set<String> names) {
        List list = ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)function).forceIgnore(e -> e instanceof JSFunction)).filter(JSReferenceExpression.class).filter(e -> e.getQualifier() instanceof JSThisExpression && e.getParent() instanceof JSDefinitionExpression).map(e -> e.resolve()).filter(r -> r instanceof JSNamedElement && names.contains(((JSNamedElement)r).getName())).toList();
        if (list == null) {
            JSExplicifyFieldsIntention.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    protected JComponent @Nullable [] getOptionControls() {
        this.myCheckBox = new MyCheckBox();
        return new JComponent[]{this.myCheckBox};
    }

    @Override
    protected void doInvoke(Project project, JSFunction function, List<JSNamedElement> elements) {
        PsiElement anchor = JSExplicifyFieldsIntention.computeClassAnchor(function);
        String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)function);
        JSLanguageDialect dialect = DialectDetector.languageDialectOfElement((PsiElement)function);
        for (JSNamedElement element2 : elements) {
            JSExpression initializer;
            boolean checkDef;
            JSType type2;
            Object text = element2.getName();
            if (dialect != null && dialect.getOptionHolder().hasFeature(JSLanguageFeature.TYPES) && (type2 = JSTypeUtils.getTypeOfElement((PsiElement)element2)) != null && !JSTypeUtils.isAnyType((JSType)type2)) {
                text = (String)text + ": " + type2.getTypeText(JSType.TypeTextFormat.CODE);
            }
            PsiElement statement = element2.getParent().getParent();
            boolean removeStatement = false;
            boolean bl = checkDef = this.myCheckBox != null && this.myCheckBox.isSelected() || this.myCheckBox == null && TRUE.equals(PropertiesComponent.getInstance((Project)project).getValue(MOVE_TO_INITIALIZER, TRUE));
            if (checkDef && element2 instanceof JSDefinitionExpression && (initializer = ((JSDefinitionExpression)element2).getInitializer()) != null && SyntaxTraverser.psiTraverser((PsiElement)initializer).filter(JSReferenceExpression.class).isEmpty()) {
                text = (String)text + " = " + initializer.getText();
                removeStatement = true;
            }
            text = (String)text + semicolon;
            anchor = this.addClassMember(project, anchor, dialect, (String)text);
            if (statement instanceof JSStatement) {
                CommentsMover mover = new CommentsMover((JSSourceElement)statement);
                HashSet set = ContainerUtil.newHashSet((Object[])new PsiElement[]{anchor});
                mover.move(set, set);
            }
            if (!removeStatement) continue;
            JSExplicifyFieldsIntention.removeStatement(statement);
        }
    }

    private static void removeStatement(PsiElement statement) {
        NewLineEraser eraser = new NewLineEraser(statement);
        statement.delete();
        eraser.process();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSExplicifyFieldsIntention";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSingleText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSExplicifyFieldsIntention";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "collectNamedElements";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isPassingLocation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }

    private static final class MyCheckBox
    extends NonFocusableCheckBox
    implements JSInitializeFieldsIntentionBase.OptionComponent {
        private MyCheckBox() {
            super(JavaScriptBundle.message((String)"checkbox.move.simple.expressions.to.field.initializer", (Object[])new Object[0]));
        }

        @Override
        @NotNull
        public String getKey() {
            return JSExplicifyFieldsIntention.MOVE_TO_INITIALIZER;
        }

        @Override
        @NotNull
        public String getValue() {
            String string = this.isSelected() ? JSInitializeFieldsIntentionBase.TRUE : JSInitializeFieldsIntentionBase.FALSE;
            if (string == null) {
                MyCheckBox.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String getDefaultValue() {
            String string = JSInitializeFieldsIntentionBase.TRUE;
            if (string == null) {
                MyCheckBox.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public void init(String value) {
            this.setSelected(JSInitializeFieldsIntentionBase.TRUE.equals(value));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/lang/javascript/intentions/JSExplicifyFieldsIntention$MyCheckBox";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultValue";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

