/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.postcss.descriptors;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssMediaFeature;
import com.intellij.psi.css.CssMediaFeatureDescriptor;
import com.intellij.psi.css.CssPseudoClass;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.descriptor.CssElementDescriptor;
import com.intellij.psi.css.descriptor.CssPseudoSelectorDescriptor;
import com.intellij.psi.css.descriptor.CssPseudoSelectorDescriptorStub;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.intellij.plugins.postcss.descriptors.CssMediaFeatureDescriptorStub;
import org.intellij.plugins.postcss.psi.PostCssCustomMedia;
import org.intellij.plugins.postcss.psi.PostCssCustomMediaAtRule;
import org.intellij.plugins.postcss.psi.PostCssCustomSelector;
import org.intellij.plugins.postcss.psi.PostCssCustomSelectorAtRule;
import org.intellij.plugins.postcss.psi.PostCssPsiUtil;
import org.intellij.plugins.postcss.psi.stubs.PostCssCustomMediaIndex;
import org.intellij.plugins.postcss.psi.stubs.PostCssCustomSelectorIndex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostCssElementDescriptorProvider
extends CssElementDescriptorProvider {
    public boolean isMyContext(@Nullable PsiElement context) {
        return PostCssPsiUtil.isInsidePostCss(context);
    }

    public PsiElement @NotNull [] getDeclarationsForSimpleSelector(@NotNull CssSimpleSelector selector) {
        if (selector == null) {
            PostCssElementDescriptorProvider.$$$reportNull$$$0(0);
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            PostCssElementDescriptorProvider.$$$reportNull$$$0(1);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @NotNull
    public Collection<? extends CssPseudoSelectorDescriptor> findPseudoSelectorDescriptors(@NotNull String name, @Nullable PsiElement context) {
        if (name == null) {
            PostCssElementDescriptorProvider.$$$reportNull$$$0(2);
        }
        if (context instanceof CssPseudoClass) {
            String selectorName;
            if (context.textContains('&') || PostCssPsiUtil.isInsideRulesetWithNestedRulesets(context)) {
                List<CssPseudoSelectorDescriptorStub> list = Collections.singletonList(new CssPseudoSelectorDescriptorStub(name));
                if (list == null) {
                    PostCssElementDescriptorProvider.$$$reportNull$$$0(3);
                }
                return list;
            }
            PsiElement identifier = ((CssPseudoClass)context).getNameIdentifier();
            String string = selectorName = identifier != null ? identifier.getText() : null;
            if (selectorName == null || !selectorName.startsWith("--")) {
                List list = Collections.emptyList();
                if (list == null) {
                    PostCssElementDescriptorProvider.$$$reportNull$$$0(4);
                }
                return list;
            }
            Collection<PostCssCustomSelector> customSelectors = PostCssCustomSelectorIndex.getCustomSelectors(selectorName.substring(2), context);
            if (customSelectors.isEmpty()) {
                List list = Collections.emptyList();
                if (list == null) {
                    PostCssElementDescriptorProvider.$$$reportNull$$$0(5);
                }
                return list;
            }
            List<CssPseudoSelectorDescriptorStub> list = Collections.singletonList(new CssPseudoSelectorDescriptorStub(name));
            if (list == null) {
                PostCssElementDescriptorProvider.$$$reportNull$$$0(6);
            }
            return list;
        }
        if (context instanceof PostCssCustomSelectorAtRule) {
            List<CssPseudoSelectorDescriptorStub> list = Collections.singletonList(new CssPseudoSelectorDescriptorStub(name));
            if (list == null) {
                PostCssElementDescriptorProvider.$$$reportNull$$$0(7);
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            PostCssElementDescriptorProvider.$$$reportNull$$$0(8);
        }
        return list;
    }

    public boolean isPossibleSelector(@NotNull String selector, @NotNull PsiElement context) {
        if (selector == null) {
            PostCssElementDescriptorProvider.$$$reportNull$$$0(9);
        }
        if (context == null) {
            PostCssElementDescriptorProvider.$$$reportNull$$$0(10);
        }
        return PostCssPsiUtil.isInsideRulesetWithNestedRulesets(context);
    }

    @NotNull
    public Collection<? extends CssPseudoSelectorDescriptor> getAllPseudoSelectorDescriptors(@Nullable PsiElement context) {
        if (context == null || DumbService.getInstance((Project)context.getProject()).isDumb()) {
            List list = Collections.emptyList();
            if (list == null) {
                PostCssElementDescriptorProvider.$$$reportNull$$$0(11);
            }
            return list;
        }
        ArrayList result = new ArrayList();
        GlobalSearchScope scope = CssUtil.getCompletionAndResolvingScopeForElement((PsiElement)context);
        Collection selectorNames = StubIndex.getInstance().getAllKeys(PostCssCustomSelectorIndex.KEY, context.getProject());
        for (String name : selectorNames) {
            if (name.isEmpty()) continue;
            StubIndex.getInstance().processElements(PostCssCustomSelectorIndex.KEY, (Object)name, context.getProject(), scope, PostCssCustomSelector.class, selector -> {
                for (CssElementDescriptor descriptor : selector.getDescriptors()) {
                    if (!(descriptor instanceof CssPseudoSelectorDescriptor)) continue;
                    result.add((CssPseudoSelectorDescriptor)descriptor);
                }
                return true;
            });
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            PostCssElementDescriptorProvider.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @NotNull
    public Collection<? extends CssMediaFeatureDescriptor> findMediaFeatureDescriptors(@NotNull String name, @Nullable PsiElement context) {
        if (name == null) {
            PostCssElementDescriptorProvider.$$$reportNull$$$0(13);
        }
        if (context instanceof CssMediaFeature) {
            CssMediaFeature mediaFeature = (CssMediaFeature)context;
            PsiElement identifier = mediaFeature.getNameIdentifier();
            if (identifier == null) {
                List list = Collections.emptyList();
                if (list == null) {
                    PostCssElementDescriptorProvider.$$$reportNull$$$0(14);
                }
                return list;
            }
            boolean isNotTheOnly = identifier.getNextSibling() != null || identifier.getPrevSibling() != null;
            String featureName = identifier.getText();
            if (isNotTheOnly || !StringUtil.startsWith((CharSequence)featureName, (CharSequence)"--")) {
                List list = Collections.emptyList();
                if (list == null) {
                    PostCssElementDescriptorProvider.$$$reportNull$$$0(15);
                }
                return list;
            }
            Collection<PostCssCustomMedia> features = PostCssCustomMediaIndex.getCustomMediaFeatures(featureName.substring(2), identifier);
            if (features.isEmpty()) {
                List list = Collections.emptyList();
                if (list == null) {
                    PostCssElementDescriptorProvider.$$$reportNull$$$0(16);
                }
                return list;
            }
            List<CssMediaFeatureDescriptorStub> list = Collections.singletonList(new CssMediaFeatureDescriptorStub(name));
            if (list == null) {
                PostCssElementDescriptorProvider.$$$reportNull$$$0(17);
            }
            return list;
        }
        if (context instanceof PostCssCustomMediaAtRule) {
            List<CssMediaFeatureDescriptorStub> list = Collections.singletonList(new CssMediaFeatureDescriptorStub(name));
            if (list == null) {
                PostCssElementDescriptorProvider.$$$reportNull$$$0(18);
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            PostCssElementDescriptorProvider.$$$reportNull$$$0(19);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 5, 6, 7, 8, 11, 12, 14, 15, 16, 17, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/postcss/descriptors/PostCssElementDescriptorProvider";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/postcss/descriptors/PostCssElementDescriptorProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationsForSimpleSelector";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findPseudoSelectorDescriptors";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPseudoSelectorDescriptors";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "findMediaFeatureDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationsForSimpleSelector";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findPseudoSelectorDescriptors";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isPossibleSelector";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findMediaFeatureDescriptors";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 5, 6, 7, 8, 11, 12, 14, 15, 16, 17, 18, 19 -> new IllegalStateException(string);
        };
    }
}

