/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.exec;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.utils.ArrayUtils;

public enum DBCLogicalOperator {
    EQUALS("=", 1){

        @Override
        public boolean evaluate(Object srcValue, Object[] arguments) {
            if (arguments == null) {
                return DBUtils.isNullValue(srcValue);
            }
            if (arguments.length == 1) {
                return DBUtils.compareDataValues(srcValue, arguments[0]) == 0;
            }
            if (arguments.length == 2) {
                int min = DBUtils.compareDataValues(srcValue, arguments[0]);
                int max = DBUtils.compareDataValues(srcValue, arguments[1]);
                return min >= 0 && max <= 0;
            }
            return false;
        }
    }
    ,
    NOT_EQUALS("<>", 1){

        @Override
        public boolean evaluate(Object srcValue, Object[] arguments) {
            Object cmpValue;
            Object object = cmpValue = arguments == null ? null : arguments[0];
            return DBUtils.compareDataValues(srcValue, cmpValue) != 0;
        }
    }
    ,
    GREATER(">", 1){

        @Override
        public boolean evaluate(Object srcValue, Object[] arguments) {
            return DBCLogicalOperator.compare(srcValue, arguments) > 0;
        }
    }
    ,
    GREATER_EQUALS(">=", 1){

        @Override
        public boolean evaluate(Object srcValue, Object[] arguments) {
            return DBCLogicalOperator.compare(srcValue, arguments) >= 0;
        }
    }
    ,
    LESS("<", 1){

        @Override
        public boolean evaluate(Object srcValue, Object[] arguments) {
            return DBCLogicalOperator.compare(srcValue, arguments) < 0;
        }
    }
    ,
    LESS_EQUALS("<=", 1){

        @Override
        public boolean evaluate(Object srcValue, Object[] arguments) {
            return DBCLogicalOperator.compare(srcValue, arguments) <= 0;
        }
    }
    ,
    IS_NULL("IS NULL", 0){

        @Override
        public boolean evaluate(Object srcValue, Object[] arguments) {
            return srcValue == null;
        }
    }
    ,
    IS_NOT_NULL("IS NOT NULL", 0){

        @Override
        public boolean evaluate(Object srcValue, Object[] arguments) {
            return srcValue != null;
        }
    }
    ,
    BETWEEN("BETWEEN", 2){

        @Override
        public boolean evaluate(Object srcValue, Object[] arguments) {
            return false;
        }
    }
    ,
    IN("IN", -1){

        @Override
        public boolean evaluate(Object srcValue, Object[] arguments) {
            return ArrayUtils.contains((Object[])arguments, (Object)srcValue);
        }
    }
    ,
    ILIKE("ILIKE", 1){

        @Override
        public boolean evaluate(Object srcValue, Object[] arguments) {
            return srcValue != null && !ArrayUtils.isEmpty((Object[])arguments) && SQLUtils.matchesLike(srcValue.toString(), arguments[0].toString());
        }
    }
    ,
    LIKE("LIKE", 1){

        @Override
        public boolean evaluate(Object srcValue, Object[] arguments) {
            return srcValue != null && !ArrayUtils.isEmpty((Object[])arguments) && SQLUtils.matchesLike(srcValue.toString(), arguments[0].toString());
        }
    }
    ,
    NOT_LIKE("NOT LIKE", 1){

        @Override
        public boolean evaluate(Object srcValue, Object[] arguments) {
            return srcValue != null && !ArrayUtils.isEmpty((Object[])arguments) && !SQLUtils.matchesLike(srcValue.toString(), arguments[0].toString());
        }
    }
    ,
    REGEX("REGEX", 1){

        @Override
        public boolean evaluate(Object srcValue, Object[] arguments) {
            return srcValue != null && !ArrayUtils.isEmpty((Object[])arguments) && srcValue.toString().matches(arguments[0].toString());
        }
    }
    ,
    SOUNDS("SOUNDS", 1){

        @Override
        public boolean evaluate(Object srcValue, Object[] arguments) {
            return false;
        }
    }
    ,
    CONTAINS("CONTAINS", 1){

        @Override
        public boolean evaluate(Object srcValue, Object[] arguments) {
            if (arguments != null) {
                Object cfr_ignored_0 = arguments[0];
            }
            return false;
        }
    }
    ,
    CONTAINS_KEY("CONTAINS KEY", 1){

        @Override
        public boolean evaluate(Object srcValue, Object[] arguments) {
            if (arguments != null) {
                Object cfr_ignored_0 = arguments[0];
            }
            return false;
        }
    };

    private final String stringValue;
    private final int argumentCount;

    private DBCLogicalOperator(String stringValue, int argumentCount) {
        this.stringValue = stringValue;
        this.argumentCount = argumentCount;
    }

    @NotNull
    public String getId() {
        return this.name();
    }

    @NotNull
    public String getExpression() {
        return this.stringValue;
    }

    public int getArgumentCount() {
        return this.argumentCount;
    }

    public boolean isWildcardOperator() {
        return this == LIKE || this == ILIKE || this == NOT_LIKE;
    }

    public abstract boolean evaluate(Object var1, Object[] var2);

    private static int compare(Object srcValue, Object[] arguments) {
        if (srcValue == null && (arguments == null || arguments.length == 0 || arguments[0] == null)) {
            return 0;
        }
        return DBUtils.compareDataValues(srcValue, arguments[0]);
    }
}

