/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.provider;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierListOwner;
import de.plushnikov.intellij.plugin.processor.LombokProcessorManager;
import de.plushnikov.intellij.plugin.processor.LombokPsiElementUsage;
import de.plushnikov.intellij.plugin.processor.Processor;
import de.plushnikov.intellij.plugin.processor.clazz.AbstractClassProcessor;
import de.plushnikov.intellij.plugin.processor.field.AbstractFieldProcessor;
import java.util.EnumSet;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LombokImplicitUsageProvider
implements ImplicitUsageProvider {
    public boolean isImplicitUsage(@NotNull PsiElement element) {
        if (element == null) {
            LombokImplicitUsageProvider.$$$reportNull$$$0(0);
        }
        return LombokImplicitUsageProvider.checkUsage(element, EnumSet.of(LombokPsiElementUsage.READ, LombokPsiElementUsage.WRITE, LombokPsiElementUsage.READ_WRITE));
    }

    public boolean isImplicitRead(@NotNull PsiElement element) {
        if (element == null) {
            LombokImplicitUsageProvider.$$$reportNull$$$0(1);
        }
        return LombokImplicitUsageProvider.checkUsage(element, EnumSet.of(LombokPsiElementUsage.READ, LombokPsiElementUsage.READ_WRITE));
    }

    public boolean isImplicitWrite(@NotNull PsiElement element) {
        if (element == null) {
            LombokImplicitUsageProvider.$$$reportNull$$$0(2);
        }
        return LombokImplicitUsageProvider.checkUsage(element, EnumSet.of(LombokPsiElementUsage.WRITE, LombokPsiElementUsage.READ_WRITE));
    }

    private static boolean checkUsage(@NotNull PsiElement element, EnumSet<LombokPsiElementUsage> elementUsages) {
        block4: {
            block5: {
                if (element == null) {
                    LombokImplicitUsageProvider.$$$reportNull$$$0(3);
                }
                if (!(element instanceof PsiField)) break block4;
                PsiField psiField = (PsiField)element;
                if (LombokImplicitUsageProvider.isUsedByLombokAnnotations(psiField, (PsiModifierListOwner)psiField, AbstractFieldProcessor.class::isInstance, elementUsages)) break block5;
                if (!LombokImplicitUsageProvider.isUsedByLombokAnnotations(psiField, (PsiModifierListOwner)psiField.getContainingClass(), AbstractClassProcessor.class::isInstance, elementUsages)) break block4;
            }
            return true;
        }
        return false;
    }

    private static boolean isUsedByLombokAnnotations(@NotNull PsiField psiField, @Nullable PsiModifierListOwner modifierListOwner, Predicate<Processor> kindOfProcessor, EnumSet<LombokPsiElementUsage> elementUsages) {
        if (psiField == null) {
            LombokImplicitUsageProvider.$$$reportNull$$$0(4);
        }
        if (null != modifierListOwner) {
            for (PsiAnnotation psiAnnotation : modifierListOwner.getAnnotations()) {
                for (Processor processor : LombokProcessorManager.getProcessors(psiAnnotation)) {
                    LombokPsiElementUsage psiElementUsage;
                    if (!kindOfProcessor.test(processor) || !elementUsages.contains((Object)(psiElementUsage = processor.checkFieldUsage(psiField, psiAnnotation)))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
        }
        objectArray2[1] = "de/plushnikov/intellij/plugin/provider/LombokImplicitUsageProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitUsage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitRead";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitWrite";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkUsage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isUsedByLombokAnnotations";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

