/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.clazz.fieldnameconstants;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import de.plushnikov.intellij.plugin.problem.ProblemProcessingSink;
import de.plushnikov.intellij.plugin.problem.ProblemSink;
import de.plushnikov.intellij.plugin.processor.LombokProcessorManager;
import de.plushnikov.intellij.plugin.processor.LombokPsiElementUsage;
import de.plushnikov.intellij.plugin.processor.clazz.AbstractClassProcessor;
import de.plushnikov.intellij.plugin.processor.field.FieldNameConstantsFieldProcessor;
import de.plushnikov.intellij.plugin.util.LombokProcessorUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FieldNameConstantsOldProcessor
extends AbstractClassProcessor {
    public FieldNameConstantsOldProcessor() {
        super((Class<? extends PsiElement>)PsiField.class, "lombok.experimental.FieldNameConstants");
    }

    private static FieldNameConstantsFieldProcessor getFieldNameConstantsFieldProcessor() {
        return LombokProcessorManager.getInstance().getFieldNameConstantsFieldProcessor();
    }

    @Override
    protected boolean supportAnnotationVariant(@NotNull PsiAnnotation psiAnnotation) {
        String prefix;
        if (psiAnnotation == null) {
            FieldNameConstantsOldProcessor.$$$reportNull$$$0(0);
        }
        if (null != psiAnnotation.findDeclaredAttributeValue(prefix = "prefix")) {
            return true;
        }
        return null != psiAnnotation.findAttributeValue(prefix);
    }

    @Override
    protected boolean validate(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @NotNull ProblemSink builder) {
        boolean result;
        if (psiAnnotation == null) {
            FieldNameConstantsOldProcessor.$$$reportNull$$$0(1);
        }
        if (psiClass == null) {
            FieldNameConstantsOldProcessor.$$$reportNull$$$0(2);
        }
        if (builder == null) {
            FieldNameConstantsOldProcessor.$$$reportNull$$$0(3);
        }
        boolean bl = result = FieldNameConstantsOldProcessor.validateAnnotationOnRightType(psiClass, builder) && LombokProcessorUtil.isLevelVisible(psiAnnotation);
        if (result) {
            Collection<PsiField> psiFields = FieldNameConstantsOldProcessor.filterFields(psiClass);
            for (PsiField psiField : psiFields) {
                FieldNameConstantsFieldProcessor.checkIfFieldNameIsValidAndWarn(psiAnnotation, psiField, builder);
            }
        }
        return result;
    }

    private static boolean validateAnnotationOnRightType(@NotNull PsiClass psiClass, @NotNull ProblemSink builder) {
        if (psiClass == null) {
            FieldNameConstantsOldProcessor.$$$reportNull$$$0(4);
        }
        if (builder == null) {
            FieldNameConstantsOldProcessor.$$$reportNull$$$0(5);
        }
        boolean result = true;
        if (psiClass.isAnnotationType() || psiClass.isInterface()) {
            builder.addErrorMessage("inspection.message.field.name.constants.only.supported.on.class.enum.or.field.type", new Object[0]);
            result = false;
        }
        return result;
    }

    @Override
    protected void generatePsiElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull List<? super PsiElement> target, @Nullable String nameHint) {
        if (psiClass == null) {
            FieldNameConstantsOldProcessor.$$$reportNull$$$0(6);
        }
        if (psiAnnotation == null) {
            FieldNameConstantsOldProcessor.$$$reportNull$$$0(7);
        }
        if (target == null) {
            FieldNameConstantsOldProcessor.$$$reportNull$$$0(8);
        }
        Collection<PsiField> psiFields = FieldNameConstantsOldProcessor.filterFields(psiClass);
        for (PsiField psiField : psiFields) {
            if (!FieldNameConstantsFieldProcessor.checkIfFieldNameIsValidAndWarn(psiAnnotation, psiField, new ProblemProcessingSink())) continue;
            target.add((PsiElement)FieldNameConstantsFieldProcessor.createFieldNameConstant(psiField, psiClass, psiAnnotation));
        }
    }

    @NotNull
    private static Collection<PsiField> filterFields(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            FieldNameConstantsOldProcessor.$$$reportNull$$$0(9);
        }
        ArrayList<PsiField> psiFields = new ArrayList<PsiField>();
        FieldNameConstantsFieldProcessor fieldProcessor = FieldNameConstantsOldProcessor.getFieldNameConstantsFieldProcessor();
        for (PsiField psiField : PsiClassUtil.collectClassFieldsIntern(psiClass)) {
            if (!FieldNameConstantsOldProcessor.shouldUseField(psiField, fieldProcessor)) continue;
            psiFields.add(psiField);
        }
        ArrayList<PsiField> arrayList = psiFields;
        if (arrayList == null) {
            FieldNameConstantsOldProcessor.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    private static boolean shouldUseField(@NotNull PsiField psiField, @NotNull FieldNameConstantsFieldProcessor fieldProcessor) {
        if (psiField == null) {
            FieldNameConstantsOldProcessor.$$$reportNull$$$0(11);
        }
        if (fieldProcessor == null) {
            FieldNameConstantsOldProcessor.$$$reportNull$$$0(12);
        }
        boolean useField = true;
        PsiModifierList modifierList = psiField.getModifierList();
        if (null != modifierList) {
            useField = !modifierList.hasModifierProperty("static");
            useField &= PsiAnnotationSearchUtil.isNotAnnotatedWith((PsiModifierListOwner)psiField, fieldProcessor.getSupportedAnnotationClasses());
            useField &= !psiField.getName().startsWith("$");
        }
        return useField;
    }

    @Override
    public LombokPsiElementUsage checkFieldUsage(@NotNull PsiField psiField, @NotNull PsiAnnotation psiAnnotation) {
        if (psiField == null) {
            FieldNameConstantsOldProcessor.$$$reportNull$$$0(13);
        }
        if (psiAnnotation == null) {
            FieldNameConstantsOldProcessor.$$$reportNull$$$0(14);
        }
        if (FieldNameConstantsOldProcessor.shouldUseField(psiField, FieldNameConstantsOldProcessor.getFieldNameConstantsFieldProcessor())) {
            return LombokPsiElementUsage.USAGE;
        }
        return LombokPsiElementUsage.NONE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/clazz/fieldnameconstants/FieldNameConstantsOldProcessor";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/clazz/fieldnameconstants/FieldNameConstantsOldProcessor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "filterFields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "supportAnnotationVariant";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "validateAnnotationOnRightType";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generatePsiElements";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "filterFields";
                break;
            }
            case 10: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "shouldUseField";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkFieldUsage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10 -> new IllegalStateException(string);
        };
    }
}

