/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.inspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import de.plushnikov.intellij.plugin.LombokBundle;
import de.plushnikov.intellij.plugin.inspection.LombokJavaInspectionBase;
import de.plushnikov.intellij.plugin.quickfix.UseSlf4jAnnotationQuickFix;
import org.jetbrains.annotations.NotNull;

public final class RedundantSlf4jDefinitionInspection
extends LombokJavaInspectionBase {
    private static final String LOGGER_SLF4J_FQCN = "org.slf4j.Logger";
    private static final String LOGGER_INITIALIZATION = "LoggerFactory.getLogger(%s.class)";

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RedundantSlf4jDefinitionInspection.$$$reportNull$$$0(0);
        }
        return new LombokDefinitionVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "de/plushnikov/intellij/plugin/inspection/RedundantSlf4jDefinitionInspection", "createVisitor"));
    }

    private static class LombokDefinitionVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder holder;

        LombokDefinitionVisitor(ProblemsHolder holder) {
            this.holder = holder;
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                LombokDefinitionVisitor.$$$reportNull$$$0(0);
            }
            super.visitField(field);
            this.findRedundantDefinition(field);
        }

        private void findRedundantDefinition(@NotNull PsiField field) {
            if (field == null) {
                LombokDefinitionVisitor.$$$reportNull$$$0(1);
            }
            if (field.getType().equalsToText(RedundantSlf4jDefinitionInspection.LOGGER_SLF4J_FQCN)) {
                PsiExpression initializer = field.getInitializer();
                PsiClass containingClass = field.getContainingClass();
                if (initializer != null && containingClass != null && initializer.getText().contains(String.format(RedundantSlf4jDefinitionInspection.LOGGER_INITIALIZATION, containingClass.getQualifiedName()))) {
                    this.holder.registerProblem((PsiElement)field, LombokBundle.message("inspection.message.slf4j.logger.defined.explicitly", new Object[0]), new LocalQuickFix[]{LocalQuickFix.from((ModCommandAction)new UseSlf4jAnnotationQuickFix(field, containingClass))});
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "field";
            objectArray2[1] = "de/plushnikov/intellij/plugin/inspection/RedundantSlf4jDefinitionInspection$LombokDefinitionVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitField";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findRedundantDefinition";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

