/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.pathvars;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.intellij.usageView.UsageInfo;
import java.util.Collection;
import java.util.LinkedHashSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001c\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u0005H\u0016J\b\u0010\u000e\u001a\u00020\u0005H\u0016J3\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0096\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00078\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lcom/intellij/microservices/jvm/pathvars/InplaceRenameQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "namedElement", "Lcom/intellij/psi/PsiNamedElement;", "oldName", "", "namesToSuggest", "", "<init>", "(Lcom/intellij/psi/PsiNamedElement;Ljava/lang/String;Ljava/lang/Iterable;)V", "getFamilyName", "nameToSuggest", "getNameToSuggest", "()Ljava/lang/String;", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "intellij.microservices.jvm"})
@SourceDebugExtension(value={"SMAP\nPathVariableMethodInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathVariableMethodInspection.kt\ncom/intellij/microservices/jvm/pathvars/InplaceRenameQuickFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,237:1\n1#2:238\n*E\n"})
final class InplaceRenameQuickFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    @NotNull
    private final String oldName;
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final Iterable<String> namesToSuggest;

    public InplaceRenameQuickFix(@NotNull PsiNamedElement namedElement, @NotNull String oldName, @NotNull Iterable<String> namesToSuggest) {
        Intrinsics.checkNotNullParameter((Object)namedElement, (String)"namedElement");
        Intrinsics.checkNotNullParameter((Object)oldName, (String)"oldName");
        Intrinsics.checkNotNullParameter(namesToSuggest, (String)"namesToSuggest");
        super((PsiElement)namedElement);
        this.oldName = oldName;
        this.namesToSuggest = namesToSuggest;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"rename.element.family", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private final String getNameToSuggest() {
        String string = (String)CollectionsKt.firstOrNull(this.namesToSuggest);
        if (string == null) {
            string = this.oldName;
        }
        return string;
    }

    @NotNull
    public String getText() {
        Object[] objectArray = new Object[]{this.oldName, this.getNameToSuggest()};
        String string = CodeInsightBundle.message((String)"rename.named.element.text", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        PsiElement psiElement = this.getStartElement();
        PsiNamedElement namedElement = psiElement instanceof PsiNamedElement ? (PsiNamedElement)psiElement : null;
        Editor editor2 = editor;
        Intrinsics.checkNotNull((Object)editor2);
        VariableInplaceRenamer variableInplaceRenamer = new VariableInplaceRenamer(namedElement, editor2, project, this.getNameToSuggest(), this.oldName);
        Iterable<String> iterable = this.namesToSuggest;
        LinkedHashSet linkedHashSet = iterable instanceof LinkedHashSet ? (LinkedHashSet)iterable : null;
        if (linkedHashSet == null) {
            linkedHashSet = (LinkedHashSet)CollectionsKt.toCollection(this.namesToSuggest, (Collection)new LinkedHashSet());
        }
        if (!variableInplaceRenamer.performInplaceRefactoring(linkedHashSet)) {
            InplaceRenameQuickFix $this$invoke_u24lambda_u240 = this;
            boolean bl = false;
            PsiElement psiElement2 = (PsiElement)namedElement;
            String string = (String)CollectionsKt.firstOrNull($this$invoke_u24lambda_u240.namesToSuggest);
            if (string == null) {
                string = "";
            }
            RenameUtil.doRename((PsiElement)psiElement2, (String)string, (UsageInfo[])UsageInfo.EMPTY_ARRAY, (Project)project, null);
        }
    }
}

