/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.dependencies;

import com.intellij.codeInsight.hints.FactoryInlayHintsCollector;
import com.intellij.codeInsight.hints.InlayHintsSink;
import com.intellij.codeInsight.hints.declarative.InlayActionData;
import com.intellij.codeInsight.hints.declarative.InlayActionHandler;
import com.intellij.codeInsight.hints.declarative.InlayActionPayload;
import com.intellij.codeInsight.hints.declarative.StringInlayActionPayload;
import com.intellij.codeInsight.hints.declarative.impl.InlayActionHandlerUsagesCollector;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.ScaleAwarePresentationFactory;
import com.intellij.codeInsight.hints.settings.InlaySettingsPanel;
import com.intellij.microservices.jvm.dependencies.build.BuildFileChecker;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H$J\b\u0010\b\u001a\u00020\tH$J\r\u0010\n\u001a\u00070\u0007\u00a2\u0006\u0002\b\u000bH$J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J-\u0010\u0014\u001a\u00020\u00152\u000b\u0010\u0016\u001a\u00070\u0007\u00a2\u0006\u0002\b\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u00a8\u0006\u001c"}, d2={"Lcom/intellij/microservices/jvm/dependencies/FrameworkDependenciesInlayHintsCollectorBase;", "Lcom/intellij/codeInsight/hints/FactoryInlayHintsCollector;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "getHandlerName", "", "getIcon", "Ljavax/swing/Icon;", "getInlayText", "Lorg/jetbrains/annotations/Nls;", "collect", "", "element", "Lcom/intellij/psi/PsiElement;", "sink", "Lcom/intellij/codeInsight/hints/InlayHintsSink;", "collectForPreview", "collectMain", "addInlineElement", "", "moduleName", "Lcom/intellij/openapi/util/NlsSafe;", "buildPresentation", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "actionData", "Lcom/intellij/codeInsight/hints/declarative/InlayActionData;", "intellij.microservices.jvm"})
public abstract class FrameworkDependenciesInlayHintsCollectorBase
extends FactoryInlayHintsCollector {
    public FrameworkDependenciesInlayHintsCollectorBase(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        super(editor);
    }

    @NotNull
    protected abstract String getHandlerName();

    @NotNull
    protected abstract Icon getIcon();

    @NotNull
    protected abstract String getInlayText();

    public boolean collect(@NotNull PsiElement element, @NotNull Editor editor, @NotNull InlayHintsSink sink) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        return InlaySettingsPanel.PREVIEW_KEY.get((UserDataHolder)element) != null ? this.collectForPreview(element, editor, sink) : this.collectMain(element, editor, sink);
    }

    private final boolean collectForPreview(PsiElement element, Editor editor, InlayHintsSink sink) {
        this.addInlineElement("preview", sink, element, editor);
        return false;
    }

    private final boolean collectMain(PsiElement element, Editor editor, InlayHintsSink sink) {
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return false;
        }
        Module module2 = module;
        BuildFileChecker buildFileChecker = BuildFileChecker.Companion.getInstance(module2);
        if (buildFileChecker == null) {
            return false;
        }
        BuildFileChecker buildFileChecker2 = buildFileChecker;
        if (!buildFileChecker2.isDependenciesElement(element)) {
            return true;
        }
        String string = module2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.addInlineElement(string, sink, element, editor);
        return false;
    }

    private final void addInlineElement(String moduleName, InlayHintsSink sink, PsiElement element, Editor editor) {
        InlayActionData actionData = new InlayActionData((InlayActionPayload)new StringInlayActionPayload(moduleName), this.getHandlerName());
        sink.addInlineElement(element.getTextRange().getEndOffset(), false, this.buildPresentation(editor, actionData), false);
    }

    /*
     * WARNING - void declaration
     */
    private final InlayPresentation buildPresentation(Editor editor, InlayActionData actionData) {
        void $this$buildPresentation_u24lambda_u240;
        ScaleAwarePresentationFactory scaleAwarePresentationFactory = new ScaleAwarePresentationFactory(editor, this.getFactory());
        PresentationFactory presentationFactory = this.getFactory();
        boolean bl = false;
        InlayPresentation[] inlayPresentationArray = new InlayPresentation[]{ScaleAwarePresentationFactory.inset$default((ScaleAwarePresentationFactory)$this$buildPresentation_u24lambda_u240, (InlayPresentation)$this$buildPresentation_u24lambda_u240.icon(this.getIcon()), (int)0, (int)0, (int)2, (int)0, (int)22, null), ScaleAwarePresentationFactory.inset$default((ScaleAwarePresentationFactory)$this$buildPresentation_u24lambda_u240, (InlayPresentation)this.getFactory().smallText(this.getInlayText()), (int)4, (int)0, (int)3, (int)0, (int)20, null)};
        return presentationFactory.referenceOnHover(ScaleAwarePresentationFactory.inset$default((ScaleAwarePresentationFactory)$this$buildPresentation_u24lambda_u240, (InlayPresentation)this.getFactory().roundWithBackground($this$buildPresentation_u24lambda_u240.seq(inlayPresentationArray)), (int)0, (int)0, (int)-2, (int)0, (int)22, null), (arg_0, arg_1) -> FrameworkDependenciesInlayHintsCollectorBase.buildPresentation$lambda$1(actionData, editor, arg_0, arg_1));
    }

    private static final void buildPresentation$lambda$1(InlayActionData $actionData, Editor $editor, MouseEvent event, Point point) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)point, (String)"<unused var>");
        InlayActionHandler handler = InlayActionHandler.Companion.getActionHandler($actionData.getHandlerId());
        if (handler != null) {
            InlayActionHandlerUsagesCollector.INSTANCE.clickHandled($actionData.getHandlerId(), handler.getClass());
            handler.handleClick(new EditorMouseEvent($editor, event, $editor.getMouseEventArea(event)), $actionData.getPayload());
        }
    }
}

