/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.InternalResource;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.instrumentation.ProvidedTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.provider.TruffleLanguageProvider;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.InternalResourceCache;
import com.oracle.truffle.polyglot.ModuleUtils;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.security.CodeSource;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.graalvm.home.HomeFinder;
import org.graalvm.polyglot.SandboxPolicy;

final class LanguageCache
implements Comparable<LanguageCache> {
    private static final Map<String, LanguageCache> nativeImageCache = TruffleOptions.AOT ? new HashMap() : null;
    private static final Map<String, LanguageCache> nativeImageMimes = TruffleOptions.AOT ? new HashMap() : null;
    private static final Set<String> languagesOverridingPatchContext = TruffleOptions.AOT ? new HashSet() : null;
    private static final Map<Collection<EngineAccessor.AbstractClassLoaderSupplier>, Map<String, LanguageCache>> runtimeCaches = new HashMap<Collection<EngineAccessor.AbstractClassLoaderSupplier>, Map<String, LanguageCache>>();
    private static volatile Map<String, LanguageCache> runtimeMimes;
    @CompilerDirectives.CompilationFinal
    private static volatile int maxStaticIndex;
    private final String className;
    private final Set<String> mimeTypes;
    private final Set<String> characterMimeTypes;
    private final String defaultMimeType;
    private final Set<String> dependentLanguages;
    private final String id;
    private final String name;
    private final String implementationName;
    private final String version;
    private final boolean interactive;
    private final boolean internal;
    private final boolean needsAllEncodings;
    private final Set<String> services;
    private final TruffleLanguage.ContextPolicy contextPolicy;
    private final ProviderAdapter providerAdapter;
    private final String website;
    private final SandboxPolicy sandboxPolicy;
    private volatile List<TruffleFile.FileTypeDetector> fileTypeDetectors;
    private volatile Set<Class<? extends Tag>> providedTags;
    private final Map<String, InternalResourceCache> internalResources;
    private int staticIndex;
    private String languageHome;

    private LanguageCache(String id, String name, String implementationName, String version, String className, String languageHome, Set<String> characterMimeTypes, Set<String> byteMimeTypes, String defaultMimeType, Set<String> dependentLanguages, boolean interactive, boolean internal, boolean needsAllEncodings, Set<String> services, TruffleLanguage.ContextPolicy contextPolicy, ProviderAdapter providerAdapter, String website, SandboxPolicy sandboxPolicy, Map<String, InternalResourceCache> internalResources) {
        assert (providerAdapter != null) : "Provider must be non null";
        this.className = className;
        this.name = name;
        this.implementationName = implementationName;
        this.version = version;
        this.characterMimeTypes = characterMimeTypes;
        this.mimeTypes = new TreeSet<String>();
        this.mimeTypes.addAll(characterMimeTypes);
        this.mimeTypes.addAll(byteMimeTypes);
        this.defaultMimeType = this.mimeTypes.size() == 1 && defaultMimeType == null ? this.mimeTypes.iterator().next() : defaultMimeType;
        this.dependentLanguages = dependentLanguages;
        this.id = id;
        this.interactive = interactive;
        this.internal = internal;
        this.needsAllEncodings = needsAllEncodings;
        this.languageHome = languageHome;
        this.services = services;
        this.contextPolicy = contextPolicy;
        this.providerAdapter = providerAdapter;
        this.website = website;
        this.sandboxPolicy = sandboxPolicy;
        this.internalResources = internalResources;
    }

    static int getMaxStaticIndex() {
        return maxStaticIndex;
    }

    static LanguageCache createHostLanguageCache(TruffleLanguage<?> languageInstance, String ... services) {
        HostLanguageProvider hostLanguageProvider = new HostLanguageProvider(languageInstance, services);
        LanguageCache cache = new LanguageCache("host", "Host", "Host", System.getProperty("java.version"), languageInstance.getClass().getName(), null, Collections.emptySet(), Collections.emptySet(), null, Collections.emptySet(), false, false, false, (Set<String>)hostLanguageProvider.getServicesClassNames(), TruffleLanguage.ContextPolicy.SHARED, new ModuleAwareProvider(hostLanguageProvider), "", SandboxPolicy.UNTRUSTED, Map.of());
        cache.staticIndex = 0;
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Map<String, LanguageCache> languageMimes() {
        if (TruffleOptions.AOT) {
            return nativeImageMimes;
        }
        Map<String, LanguageCache> cache = runtimeMimes;
        if (cache != null) return cache;
        Class<LanguageCache> clazz = LanguageCache.class;
        synchronized (LanguageCache.class) {
            cache = runtimeMimes;
            if (cache != null) return cache;
            runtimeMimes = cache = LanguageCache.createMimes();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return cache;
        }
    }

    private static Map<String, LanguageCache> createMimes() {
        LinkedHashMap<String, LanguageCache> mimes = new LinkedHashMap<String, LanguageCache>();
        for (LanguageCache cache : LanguageCache.languages().values()) {
            for (String mime : cache.getMimeTypes()) {
                mimes.put(mime, cache);
            }
        }
        return mimes;
    }

    public static boolean getNeedsAllEncodings() {
        for (LanguageCache cache : LanguageCache.languages().values()) {
            if (!cache.isNeedsAllEncodings()) continue;
            return true;
        }
        return false;
    }

    static Map<String, LanguageCache> languages() {
        return LanguageCache.loadLanguages(EngineAccessor.locatorOrDefaultLoaders());
    }

    static Collection<LanguageCache> internalLanguages() {
        HashSet<LanguageCache> result = new HashSet<LanguageCache>();
        for (Map.Entry<String, LanguageCache> e : LanguageCache.languages().entrySet()) {
            if (!e.getValue().isInternal()) continue;
            result.add(e.getValue());
        }
        return result;
    }

    static Collection<LanguageCache> computeTransitiveLanguageDependencies(String id) {
        Map<String, LanguageCache> languagesById = LanguageCache.languages();
        LanguageCache root = languagesById.get(id);
        if (root == null) {
            throw new IllegalArgumentException(String.format("A language with id '%s' is not installed. Installed languages are: %s.", id, String.join((CharSequence)", ", languagesById.keySet())));
        }
        HashSet<LanguageCache> result = new HashSet<LanguageCache>();
        ArrayDeque<LanguageCache> todo = new ArrayDeque<LanguageCache>();
        todo.add(root);
        while (!todo.isEmpty()) {
            LanguageCache current = (LanguageCache)todo.removeFirst();
            if (!result.add(current)) continue;
            current.getDependentLanguages().stream().map(languagesById::get).filter(Objects::nonNull).forEach(todo::add);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, LanguageCache> loadLanguages(List<EngineAccessor.AbstractClassLoaderSupplier> classLoaders) {
        if (TruffleOptions.AOT) {
            return nativeImageCache;
        }
        Class<LanguageCache> clazz = LanguageCache.class;
        synchronized (LanguageCache.class) {
            Map<String, LanguageCache> cache = runtimeCaches.get(classLoaders);
            if (cache == null) {
                cache = LanguageCache.createLanguages(classLoaders);
                runtimeCaches.put(classLoaders, cache);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return cache;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static synchronized Map<String, LanguageCache> createLanguages(List<EngineAccessor.AbstractClassLoaderSupplier> suppliers) {
        void var4_7;
        ArrayList caches = new ArrayList();
        Map<String, Map<String, Supplier<InternalResourceCache>>> optionalResources = InternalResourceCache.loadOptionalInternalResources(suppliers);
        for (EngineAccessor.AbstractClassLoaderSupplier abstractClassLoaderSupplier : suppliers) {
            ClassLoader loader = (ClassLoader)abstractClassLoaderSupplier.get();
            if (loader == null) continue;
            LanguageCache.loadProviders(loader).filter(p -> abstractClassLoaderSupplier.accepts(p.getProviderClass())).forEach(p -> LanguageCache.loadLanguageImpl(p, caches, optionalResources));
            if (!abstractClassLoaderSupplier.supportsLegacyProviders()) continue;
            LanguageCache.loadLegacyProviders(loader).filter(p -> abstractClassLoaderSupplier.accepts(p.getProviderClass())).forEach(p -> LanguageCache.loadLanguageImpl(p, caches, optionalResources));
        }
        LinkedHashMap<String, LanguageCache> idToCache = new LinkedHashMap<String, LanguageCache>();
        for (LanguageCache languageCache : caches) {
            LanguageCache prev = idToCache.put(languageCache.getId(), languageCache);
            if (prev == null || prev.getClassName().equals(languageCache.getClassName()) && LanguageCache.hasSameCodeSource(prev, languageCache)) continue;
            String message = String.format("Duplicate language id %s. First language [%s]. Second language [%s].", languageCache.getId(), LanguageCache.formatLanguageLocation(prev), LanguageCache.formatLanguageLocation(languageCache));
            throw new IllegalStateException(message);
        }
        boolean bl = false;
        for (LanguageCache cache : idToCache.values()) {
            cache.staticIndex = ++var4_7;
        }
        maxStaticIndex = Math.max(maxStaticIndex, (int)var4_7);
        return idToCache;
    }

    private static Stream<? extends ProviderAdapter> loadLegacyProviders(ClassLoader loader) {
        ModuleUtils.exportToUnnamedModuleOf(loader);
        return StreamSupport.stream(ServiceLoader.load(TruffleLanguage.Provider.class, loader).spliterator(), false).map(LegacyProvider::new);
    }

    private static Stream<? extends ProviderAdapter> loadProviders(ClassLoader loader) {
        return StreamSupport.stream(ServiceLoader.load(TruffleLanguageProvider.class, loader).spliterator(), false).map(ModuleAwareProvider::new);
    }

    private static boolean hasSameCodeSource(LanguageCache first, LanguageCache second) {
        return first.providerAdapter.getProviderClass() == second.providerAdapter.getProviderClass();
    }

    private static void loadLanguageImpl(ProviderAdapter providerAdapter, List<LanguageCache> into, Map<String, Map<String, Supplier<InternalResourceCache>>> optionalResources) {
        Path languageHomePath;
        Class<?> providerClass = providerAdapter.getProviderClass();
        Module providerModule = providerClass.getModule();
        ModuleUtils.exportTransitivelyTo(providerModule);
        TruffleLanguage.Registration reg = providerClass.getAnnotation(TruffleLanguage.Registration.class);
        if (reg == null) {
            LanguageCache.emitWarning("Warning Truffle language ignored: Provider %s is missing @Registration annotation.", providerClass);
            return;
        }
        String className = providerAdapter.getLanguageClassName();
        String name = reg.name();
        String id = reg.id();
        if (id == null || id.isEmpty()) {
            if (name.isEmpty()) {
                int lastIndex = className.lastIndexOf(36);
                if (lastIndex == -1) {
                    lastIndex = className.lastIndexOf(46);
                }
                id = className.substring(lastIndex + 1);
            } else {
                id = name.length() == 1 ? name : name.toLowerCase();
            }
        }
        String languageHome = (languageHomePath = HomeFinder.getInstance().getLanguageHomes().get(id)) != null ? languageHomePath.toString() : null;
        String implementationName = reg.implementationName();
        String version = reg.version();
        TreeSet<String> characterMimes = new TreeSet<String>();
        Collections.addAll(characterMimes, reg.characterMimeTypes());
        TreeSet<String> byteMimeTypes = new TreeSet<String>();
        Collections.addAll(byteMimeTypes, reg.byteMimeTypes());
        String defaultMime = reg.defaultMimeType();
        if (defaultMime.isEmpty()) {
            defaultMime = null;
        }
        TreeSet<String> dependentLanguages = new TreeSet<String>();
        Collections.addAll(dependentLanguages, reg.dependentLanguages());
        boolean interactive = reg.interactive();
        boolean internal = reg.internal();
        boolean needsAllEncodings = reg.needsAllEncodings();
        TreeSet<String> servicesClassNames = new TreeSet<String>(providerAdapter.getServicesClassNames());
        SandboxPolicy sandboxPolicy = reg.sandbox();
        HashMap<String, InternalResourceCache> resources = new HashMap<String, InternalResourceCache>();
        for (String string : providerAdapter.getInternalResourceIds()) {
            resources.put(string, new InternalResourceCache(id, string, () -> providerAdapter.createInternalResource(resourceId)));
        }
        for (Map.Entry entry : optionalResources.getOrDefault(id, Map.of()).entrySet()) {
            InternalResourceCache resource = (InternalResourceCache)((Supplier)entry.getValue()).get();
            InternalResourceCache old = resources.put((String)entry.getKey(), resource);
            if (old == null) continue;
            throw InternalResourceCache.throwDuplicateOptionalResourceException(old, resource);
        }
        into.add(new LanguageCache(id, name, implementationName, version, className, languageHome, characterMimes, byteMimeTypes, defaultMime, dependentLanguages, interactive, internal, needsAllEncodings, servicesClassNames, reg.contextPolicy(), providerAdapter, reg.website(), sandboxPolicy, Collections.unmodifiableMap(resources)));
    }

    private static String formatLanguageLocation(LanguageCache languageCache) {
        URL url;
        StringBuilder sb = new StringBuilder();
        sb.append("Language class ").append(languageCache.getClassName());
        CodeSource source = languageCache.providerAdapter.getProviderClass().getProtectionDomain().getCodeSource();
        URL uRL = url = source != null ? source.getLocation() : null;
        if (url != null) {
            sb.append(", Loaded from " + String.valueOf(url));
        }
        return sb.toString();
    }

    private static String getLanguageHomeFromSystemProperty(String languageId) {
        return LanguageCache.toRealStringPath("org.graalvm.language." + languageId + ".home");
    }

    private static String toRealStringPath(String propertyName) {
        String path = System.getProperty(propertyName);
        if (path != null) {
            try {
                path = Path.of(path, new String[0]).toRealPath(new LinkOption[0]).toString();
            }
            catch (NoSuchFileException nsfe) {
                return path;
            }
            catch (IOException ioe) {
                throw CompilerDirectives.shouldNotReachHere(ioe);
            }
        }
        return path;
    }

    static boolean overridesPathContext(String languageId) {
        assert (TruffleOptions.AOT) : "Only supported in native image";
        return languagesOverridingPatchContext.contains(languageId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void resetNativeImageCacheLanguageHomes() {
        Class<LanguageCache> clazz = LanguageCache.class;
        synchronized (LanguageCache.class) {
            if (nativeImageCache != null) {
                LanguageCache.resetNativeImageCacheLanguageHomes(nativeImageCache);
            }
            for (Map<String, LanguageCache> caches : runtimeCaches.values()) {
                LanguageCache.resetNativeImageCacheLanguageHomes(caches);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void resetNativeImageCacheLanguageHomes(Map<String, LanguageCache> caches) {
        for (LanguageCache cache : caches.values()) {
            cache.languageHome = null;
        }
    }

    private static void initializeNativeImageState(ClassLoader imageClassLoader) {
        assert (TruffleOptions.AOT) : "Only supported during image generation";
        nativeImageCache.putAll(LanguageCache.createLanguages(List.of(new EngineAccessor.StrongClassLoaderSupplier(imageClassLoader))));
        nativeImageMimes.putAll(LanguageCache.createMimes());
        block2: for (LanguageCache languageCache : nativeImageCache.values()) {
            try {
                Class<?> clz = Class.forName(languageCache.className, false, imageClassLoader);
                for (Method m : clz.getDeclaredMethods()) {
                    if (!m.getName().equals("patchContext")) continue;
                    languagesOverridingPatchContext.add(languageCache.id);
                    continue block2;
                }
            }
            catch (ReflectiveOperationException roe) {
                LanguageCache.emitWarning("Failed to lookup patchContext method due to ", roe);
            }
        }
    }

    private static Set<String> collectLanguages() {
        assert (TruffleOptions.AOT) : "Only supported during image generation";
        HashSet<String> toRet = new HashSet<String>();
        for (LanguageCache languageCache : nativeImageCache.values()) {
            toRet.add(languageCache.id);
        }
        return toRet;
    }

    private static void resetNativeImageState() {
        assert (TruffleOptions.AOT) : "Only supported during image generation";
        nativeImageCache.clear();
        nativeImageMimes.clear();
    }

    private static void removeLanguageFromNativeImage(String languageId) {
        assert (TruffleOptions.AOT) : "Only supported during image generation";
        assert (nativeImageCache.containsKey(languageId));
        LanguageCache cache = nativeImageCache.remove(languageId);
        if (cache != null) {
            for (String mime : cache.getMimeTypes()) {
                if (nativeImageCache.get(mime) != cache) continue;
                nativeImageMimes.remove(mime);
            }
        }
    }

    int getStaticIndex() {
        return this.staticIndex;
    }

    @Override
    public int compareTo(LanguageCache o) {
        return this.id.compareTo(o.id);
    }

    String getId() {
        return this.id;
    }

    Set<String> getMimeTypes() {
        return this.mimeTypes;
    }

    String getDefaultMimeType() {
        return this.defaultMimeType;
    }

    boolean isCharacterMimeType(String mimeType) {
        return this.characterMimeTypes.contains(mimeType);
    }

    String getName() {
        return this.name;
    }

    String getImplementationName() {
        return this.implementationName;
    }

    Set<String> getDependentLanguages() {
        return this.dependentLanguages;
    }

    String getVersion() {
        return this.version;
    }

    String getClassName() {
        return this.className;
    }

    boolean isInternal() {
        return this.internal;
    }

    boolean isInteractive() {
        return this.interactive;
    }

    public boolean isNeedsAllEncodings() {
        return this.needsAllEncodings;
    }

    String getLanguageHome() {
        if (this.languageHome == null) {
            this.languageHome = LanguageCache.getLanguageHomeFromSystemProperty(this.id);
        }
        return this.languageHome;
    }

    TruffleLanguage<?> loadLanguage() {
        return this.providerAdapter.create();
    }

    Set<? extends Class<? extends Tag>> getProvidedTags() {
        Set<Class<Tag>> res = this.providedTags;
        if (res == null) {
            ProvidedTags tags = this.providerAdapter.getProviderClass().getAnnotation(ProvidedTags.class);
            if (tags == null) {
                res = Collections.emptySet();
            } else {
                res = new HashSet<Class<? extends Tag>>();
                Collections.addAll(res, tags.value());
                res = Collections.unmodifiableSet(res);
            }
            this.providedTags = res;
        }
        return res;
    }

    TruffleLanguage.ContextPolicy getPolicy() {
        return this.contextPolicy;
    }

    Collection<String> getServices() {
        return this.services;
    }

    boolean supportsService(Class<?> clazz) {
        return this.services.contains(clazz.getName()) || this.services.contains(clazz.getCanonicalName());
    }

    List<? extends TruffleFile.FileTypeDetector> getFileTypeDetectors() {
        List<TruffleFile.FileTypeDetector> result = this.fileTypeDetectors;
        if (result == null) {
            this.fileTypeDetectors = result = this.providerAdapter.createFileTypeDetectors();
        }
        return result;
    }

    InternalResourceCache getResourceCache(String resourceId) {
        return this.internalResources.get(resourceId);
    }

    Collection<String> getResourceIds() {
        return this.internalResources.keySet();
    }

    Collection<InternalResourceCache> getResources() {
        return this.internalResources.values();
    }

    public String toString() {
        return "LanguageCache [id=" + this.id + ", name=" + this.name + ", implementationName=" + this.implementationName + ", version=" + this.version + ", className=" + this.className + ", services=" + String.valueOf(this.services) + "]";
    }

    String getWebsite() {
        return this.website;
    }

    SandboxPolicy getSandboxPolicy() {
        return this.sandboxPolicy;
    }

    private static void emitWarning(String message, Object ... args) {
        PrintStream out = System.err;
        out.printf(message + "%n", args);
    }

    private static interface ProviderAdapter {
        public Class<?> getProviderClass();

        public TruffleLanguage<?> create();

        public String getLanguageClassName();

        public Collection<String> getServicesClassNames();

        public List<TruffleFile.FileTypeDetector> createFileTypeDetectors();

        public List<String> getInternalResourceIds();

        public InternalResource createInternalResource(String var1);
    }

    private static final class HostLanguageProvider
    extends TruffleLanguageProvider {
        private final TruffleLanguage<?> languageInstance;
        private final Set<String> servicesClassNames;

        HostLanguageProvider(TruffleLanguage<?> languageInstance, String ... services) {
            assert (languageInstance != null) : "LanguageInstance must be non null.";
            this.languageInstance = languageInstance;
            if (services.length == 0) {
                this.servicesClassNames = Collections.emptySet();
            } else {
                TreeSet treeSet = new TreeSet();
                Collections.addAll(treeSet, services);
                this.servicesClassNames = Collections.unmodifiableSet(treeSet);
            }
        }

        @Override
        public String getLanguageClassName() {
            return this.languageInstance.getClass().getName();
        }

        @Override
        public Object create() {
            return this.languageInstance;
        }

        public Set<String> getServicesClassNames() {
            return this.servicesClassNames;
        }

        protected List<TruffleLanguageProvider> createFileTypeDetectors() {
            return List.of();
        }
    }

    private static final class ModuleAwareProvider
    implements ProviderAdapter {
        private final TruffleLanguageProvider provider;

        ModuleAwareProvider(TruffleLanguageProvider provider) {
            Objects.requireNonNull(provider, "Provider must be non null");
            this.provider = provider;
        }

        @Override
        public Class<?> getProviderClass() {
            return this.provider.getClass();
        }

        @Override
        public TruffleLanguage<?> create() {
            return (TruffleLanguage)EngineAccessor.LANGUAGE_PROVIDER.create(this.provider);
        }

        @Override
        public String getLanguageClassName() {
            return EngineAccessor.LANGUAGE_PROVIDER.getLanguageClassName(this.provider);
        }

        @Override
        public Collection<String> getServicesClassNames() {
            return EngineAccessor.LANGUAGE_PROVIDER.getServicesClassNames(this.provider);
        }

        @Override
        public List<TruffleFile.FileTypeDetector> createFileTypeDetectors() {
            return EngineAccessor.LANGUAGE_PROVIDER.createFileTypeDetectors(this.provider);
        }

        @Override
        public List<String> getInternalResourceIds() {
            return EngineAccessor.LANGUAGE_PROVIDER.getInternalResourceIds(this.provider);
        }

        @Override
        public InternalResource createInternalResource(String resourceId) {
            return EngineAccessor.LANGUAGE_PROVIDER.createInternalResource(this.provider, resourceId);
        }
    }

    private static final class LegacyProvider
    implements ProviderAdapter {
        private final TruffleLanguage.Provider provider;

        LegacyProvider(TruffleLanguage.Provider provider) {
            Objects.requireNonNull(provider, "Provider must be non null");
            this.provider = provider;
        }

        @Override
        public Class<?> getProviderClass() {
            return this.provider.getClass();
        }

        @Override
        public TruffleLanguage<?> create() {
            return this.provider.create();
        }

        @Override
        public String getLanguageClassName() {
            return this.provider.getLanguageClassName();
        }

        @Override
        public Collection<String> getServicesClassNames() {
            return this.provider.getServicesClassNames();
        }

        @Override
        public List<TruffleFile.FileTypeDetector> createFileTypeDetectors() {
            return this.provider.createFileTypeDetectors();
        }

        @Override
        public List<String> getInternalResourceIds() {
            return List.of();
        }

        @Override
        public InternalResource createInternalResource(String resourceId) {
            throw new UnsupportedOperationException();
        }
    }
}

