/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.styledComponents;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.refactoring.JSNamesValidation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.styledComponents.CustomInjectionsConfiguration;
import com.intellij.styledComponents.StyledComponentsBundle;
import com.intellij.styledComponents.StyledComponentsConfigurable;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.FileContentUtil;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.ItemRemovable;
import com.intellij.util.ui.table.EditorTextFieldJBTableRowRenderer;
import com.intellij.util.ui.table.JBListTable;
import com.intellij.util.ui.table.JBTableRow;
import com.intellij.util.ui.table.JBTableRowEditor;
import com.intellij.util.ui.table.JBTableRowRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Q\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u000e\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\r\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0013\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0014H\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/styledComponents/StyledComponentsConfigurable;", "Lcom/intellij/openapi/options/SearchableConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "myConfiguration", "Lcom/intellij/styledComponents/CustomInjectionsConfiguration;", "tagsModel", "Lcom/intellij/styledComponents/StyledComponentsConfigurable$TagsModel;", "disposable", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/annotations/NotNull;", "createPrefixesField", "com/intellij/styledComponents/StyledComponentsConfigurable$createPrefixesField$1", "()Lcom/intellij/styledComponents/StyledComponentsConfigurable$createPrefixesField$1;", "isModified", "", "getPrefixesFromUi", "", "", "()[Ljava/lang/String;", "getId", "getDisplayName", "apply", "", "reset", "createComponent", "Ljavax/swing/JComponent;", "disposeUIResources", "TagsModel", "intellij.styled.components"})
@SourceDebugExtension(value={"SMAP\nStyledComponentsConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StyledComponentsConfigurable.kt\ncom/intellij/styledComponents/StyledComponentsConfigurable\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,164:1\n37#2,2:165\n*S KotlinDebug\n*F\n+ 1 StyledComponentsConfigurable.kt\ncom/intellij/styledComponents/StyledComponentsConfigurable\n*L\n88#1:165,2\n*E\n"})
final class StyledComponentsConfigurable
implements SearchableConfigurable {
    @NotNull
    private final Project project;
    @NotNull
    private final CustomInjectionsConfiguration myConfiguration;
    @NotNull
    private final TagsModel tagsModel;
    @NotNull
    private final Disposable disposable;

    public StyledComponentsConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.myConfiguration = CustomInjectionsConfiguration.Companion.instance(this.project);
        this.tagsModel = new TagsModel();
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.disposable = disposable;
    }

    private final createPrefixesField.1 createPrefixesField() {
        JBTable jBTable = new JBTable((TableModel)this.tagsModel);
        Disposable disposable = this.disposable;
        return new JBListTable(this, jBTable, disposable){
            final /* synthetic */ StyledComponentsConfigurable this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2);
            }

            protected JBTableRowRenderer getRowRenderer(int p0) {
                Project project = StyledComponentsConfigurable.access$getProject$p(this.this$0);
                PlainTextLanguage plainTextLanguage = PlainTextLanguage.INSTANCE;
                Disposable disposable = StyledComponentsConfigurable.access$getDisposable$p(this.this$0);
                return (JBTableRowRenderer)new EditorTextFieldJBTableRowRenderer(this.this$0, project, plainTextLanguage, disposable){
                    final /* synthetic */ StyledComponentsConfigurable this$0;
                    {
                        this.this$0 = $receiver;
                        super($super_call_param$1, (Language)$super_call_param$2, $super_call_param$3);
                    }

                    protected String getText(JTable p0, int index) {
                        return StyledComponentsConfigurable.access$getTagsModel$p(this.this$0).getMyTags().get(index);
                    }
                };
            }

            protected JBTableRowEditor getRowEditor(int p0) {
                return new JBTableRowEditor(this.this$0){
                    final /* synthetic */ StyledComponentsConfigurable this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public JBTableRow getValue() {
                        return arg_0 -> createPrefixesField.getRowEditor.1.getValue$lambda$0(this, arg_0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public void prepareEditor(JTable p0, int p1) {
                        ValidationInfo validationInfo;
                        this.setLayout(new BorderLayout());
                        EditorTextField editor = new EditorTextField(StyledComponentsConfigurable.access$getTagsModel$p(this.this$0).getMyTags().get(p1));
                        editor.addDocumentListener((DocumentListener)new JBTableRowEditor.RowEditorChangeListener((JBTableRowEditor)this, 0));
                        ComponentValidator validator = new ComponentValidator(StyledComponentsConfigurable.access$getDisposable$p(this.this$0));
                        editor.addDocumentListener(new DocumentListener(validator, this, editor){
                            final /* synthetic */ ComponentValidator $validator;
                            final /* synthetic */ createPrefixesField.getRowEditor.1 this$0;
                            final /* synthetic */ EditorTextField $editor;
                            {
                                this.$validator = $validator;
                                this.this$0 = $receiver;
                                this.$editor = $editor;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public void documentChanged(DocumentEvent event) {
                                ValidationInfo validationInfo;
                                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                                ComponentValidator componentValidator = this.$validator;
                                String string = this.this$0.getErrorText(this.$editor.getText());
                                if (string != null) {
                                    void it;
                                    String string2 = string;
                                    EditorTextField editorTextField = this.$editor;
                                    String string3 = string2;
                                    ComponentValidator componentValidator2 = componentValidator;
                                    boolean bl = false;
                                    validationInfo = new ValidationInfo((String)it, (JComponent)editorTextField);
                                    componentValidator = componentValidator2;
                                } else {
                                    validationInfo = null;
                                }
                                componentValidator.updateInfo(validationInfo);
                            }
                        });
                        this.add((Component)editor, "North");
                        ComponentValidator componentValidator = validator;
                        String string = this.getErrorText(editor.getText());
                        if (string != null) {
                            void it;
                            String string2 = string;
                            ComponentValidator componentValidator2 = componentValidator;
                            boolean bl = false;
                            validationInfo = new ValidationInfo((String)it, (JComponent)editor);
                            componentValidator = componentValidator2;
                        } else {
                            validationInfo = null;
                        }
                        componentValidator.updateInfo(validationInfo);
                    }

                    public JComponent[] getFocusableComponents() {
                        JComponent[] jComponentArray = new JComponent[]{this.getPreferredFocusedComponent()};
                        return jComponentArray;
                    }

                    public JComponent getPreferredFocusedComponent() {
                        Component component = this.getComponent(0);
                        Intrinsics.checkNotNull((Object)component, (String)"null cannot be cast to non-null type javax.swing.JComponent");
                        return (JComponent)component;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final String getErrorText(String value) {
                        void $this$foldIndexed$iv;
                        void initial$iv;
                        String string = value;
                        if (string == null || (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) == null) {
                            string = "";
                        }
                        String trimmed = string;
                        Object object = new String[]{"."};
                        List names = StringsKt.split$default((CharSequence)trimmed, (String[])object, (boolean)false, (int)0, (int)6, null);
                        if (StringsKt.isBlank((CharSequence)trimmed) || names.isEmpty()) {
                            return StyledComponentsBundle.INSTANCE.message("styled.components.configurable.error.value.is.empty", new Object[0]);
                        }
                        object = names;
                        Object var5_5 = null;
                        StyledComponentsConfigurable styledComponentsConfigurable = this.this$0;
                        boolean $i$f$foldIndexed = false;
                        int index$iv = 0;
                        void accumulator$iv = initial$iv;
                        for (T element$iv : $this$foldIndexed$iv) {
                            void string2;
                            String string3;
                            void previous;
                            int n;
                            if ((n = index$iv++) < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            String string4 = (String)element$iv;
                            void var14_14 = accumulator$iv;
                            int index = n;
                            boolean bl = false;
                            if (previous != null) {
                                string3 = previous;
                            } else if (index == 0 && !LanguageNamesValidation.INSTANCE.forLanguage((Language)JavascriptLanguage.INSTANCE).isIdentifier((String)string2, StyledComponentsConfigurable.access$getProject$p(styledComponentsConfigurable))) {
                                var17_17 = new Object[]{string2};
                                string3 = StyledComponentsBundle.INSTANCE.message("styled.components.configurable.not.valid.identifier", var17_17);
                            } else if (!JSNamesValidation.isIdentifierName((String)string2)) {
                                var17_17 = new Object[]{string2};
                                string3 = StyledComponentsBundle.INSTANCE.message("styled.components.configurable.not.valid.property.name", var17_17);
                            } else {
                                string3 = null;
                            }
                            accumulator$iv = string3;
                        }
                        return accumulator$iv;
                    }

                    private static final Object getValue$lambda$0(createPrefixesField.getRowEditor.1 this$0, int it) {
                        Component component = this$0.getComponent(0);
                        Intrinsics.checkNotNull((Object)component, (String)"null cannot be cast to non-null type com.intellij.ui.EditorTextField");
                        return ((EditorTextField)component).getText();
                    }
                };
            }
        };
    }

    public boolean isModified() {
        return !Arrays.equals(this.getPrefixesFromUi(), this.myConfiguration.getTagPrefixes());
    }

    private final String[] getPrefixesFromUi() {
        Collection $this$toTypedArray$iv = this.tagsModel.getMyTags();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    @NotNull
    public String getId() {
        return "styled-components";
    }

    @NotNull
    public String getDisplayName() {
        return StyledComponentsBundle.INSTANCE.message("styled.components.configurable.title", new Object[0]);
    }

    public void apply() {
        this.myConfiguration.setTagPrefixes(this.getPrefixesFromUi());
        FileContentUtil.reparseFiles((Project)this.project, (Collection)CollectionsKt.emptyList(), (boolean)true);
    }

    public void reset() {
        this.tagsModel.setTags(this.myConfiguration.getTagPrefixes());
    }

    @NotNull
    public JComponent createComponent() {
        createPrefixesField.1 tagPrefixesField = this.createPrefixesField();
        JPanel jPanel = ToolbarDecorator.createDecorator((JTable)((JTable)tagPrefixesField.getTable())).disableUpDownActions().createPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createPanel(...)");
        JPanel table = jPanel;
        LabeledComponent labeledComponent = LabeledComponent.create((JComponent)table, (String)StyledComponentsBundle.INSTANCE.message("styled.components.configurable.label.tag.prefixes", new Object[0]));
        Intrinsics.checkNotNullExpressionValue((Object)labeledComponent, (String)"create(...)");
        LabeledComponent component = labeledComponent;
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)component, "North");
        return panel;
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.disposable);
    }

    public static final /* synthetic */ TagsModel access$getTagsModel$p(StyledComponentsConfigurable $this) {
        return $this.tagsModel;
    }

    public static final /* synthetic */ Project access$getProject$p(StyledComponentsConfigurable $this) {
        return $this.project;
    }

    public static final /* synthetic */ Disposable access$getDisposable$p(StyledComponentsConfigurable $this) {
        return $this.disposable;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\"\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\b\u0010\u0017\u001a\u00020\u0015H\u0016J\u0018\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000eH\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000eH\u0016J\u0010\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u000eH\u0016J\u0019\u0010\u001f\u001a\u00020\u00152\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\b0!\u00a2\u0006\u0002\u0010\"R \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006#"}, d2={"Lcom/intellij/styledComponents/StyledComponentsConfigurable$TagsModel;", "Ljavax/swing/table/AbstractTableModel;", "Lcom/intellij/util/ui/ItemRemovable;", "Lcom/intellij/util/ui/EditableModel;", "<init>", "()V", "myTags", "", "", "getMyTags", "()Ljava/util/List;", "setMyTags", "(Ljava/util/List;)V", "getRowCount", "", "getColumnCount", "getValueAt", "", "row", "column", "setValueAt", "", "o", "addRow", "exchangeRows", "oldIndex", "newIndex", "canExchangeRows", "", "removeRow", "idx", "setTags", "tags", "", "([Ljava/lang/String;)V", "intellij.styled.components"})
    private static final class TagsModel
    extends AbstractTableModel
    implements ItemRemovable,
    EditableModel {
        @NotNull
        private List<String> myTags = new ArrayList();

        @NotNull
        public final List<String> getMyTags() {
            return this.myTags;
        }

        public final void setMyTags(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.myTags = list;
        }

        @Override
        public int getRowCount() {
            return this.myTags.size();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        @NotNull
        public Object getValueAt(int row, int column) {
            return this.myTags.get(row);
        }

        @Override
        public void setValueAt(@Nullable Object o, int row, int column) {
            Intrinsics.checkNotNull((Object)o, (String)"null cannot be cast to non-null type kotlin.String");
            this.myTags.set(row, (String)o);
            this.fireTableCellUpdated(row, column);
        }

        public void addRow() {
            this.myTags.add("");
            int row = this.myTags.size() - 1;
            this.fireTableRowsInserted(row, row);
        }

        public void exchangeRows(int oldIndex, int newIndex) {
        }

        public boolean canExchangeRows(int oldIndex, int newIndex) {
            return false;
        }

        public void removeRow(int idx) {
            this.myTags.remove(idx);
            this.fireTableRowsDeleted(idx, idx);
        }

        public final void setTags(@NotNull String[] tags) {
            Intrinsics.checkNotNullParameter((Object)tags, (String)"tags");
            this.myTags.clear();
            CollectionsKt.addAll((Collection)this.myTags, (Object[])tags);
            this.fireTableStructureChanged();
        }
    }
}

