/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.stubs.factories;

import com.intellij.database.model.ObjectKind;
import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.stubs.elementStubs.SqlNamedElementStub;
import com.intellij.sql.psi.stubs.elementTypes.SqlDefinitionStubElementType;
import com.intellij.sql.psi.stubs.elementTypes.SqlNamedStubElementType;
import com.intellij.sql.psi.stubs.elementTypes.SqlStubElementType;
import com.intellij.sql.psi.stubs.factories.SqlStubElementFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlNamedStubElementFactory<S extends SqlNamedElementStub<T>, T extends SqlElement>
extends SqlStubElementFactory<S, T> {
    @NotNull
    protected final SqlNamedStubElementType elementType;

    public SqlNamedStubElementFactory(@NotNull SqlNamedStubElementType elementType) {
        if (elementType == null) {
            SqlNamedStubElementFactory.$$$reportNull$$$0(0);
        }
        this.elementType = elementType;
    }

    @Nullable
    protected SqlReferenceElementType getTargetReferenceType() {
        return this.elementType.getTargetReferenceType();
    }

    @Override
    public boolean shouldCreateStub(ASTNode node) {
        SqlDefinitionStubElementType pType;
        IElementType nodeElementType = PsiUtilCore.getElementType((ASTNode)node);
        SqlReferenceElementType referenceElementType = this.getTargetReferenceType();
        if (nodeElementType == SqlCompositeElementTypes.SQL_RETURNS_CLAUSE) {
            SqlStubElementType stubType;
            ASTNode parent = node.getTreeParent();
            IElementType pType2 = PsiUtilCore.getElementType((ASTNode)parent);
            return pType2 instanceof SqlStubElementType && (stubType = (SqlStubElementType)pType2).shouldCreateStubForNode(parent);
        }
        if (nodeElementType == SqlCompositeElementTypes.SQL_TYPE_DEFINITION || nodeElementType == SqlCompositeElementTypes.SQL_ALIAS_TYPE_DEFINITION || nodeElementType == SqlCompositeElementTypes.SQL_COLLECTION_TYPE_DEFINITION) {
            ASTNode parent = SqlNamedStubElementFactory.getSqlParent(node);
            IElementType elementType = PsiUtilCore.getElementType((ASTNode)parent);
            ObjectKind pKind = SqlNamedStubElementFactory.getDefKind(parent);
            return pKind != ObjectKind.BODY && pKind != ObjectKind.ROUTINE && pKind != null && elementType != SqlCompositeElementTypes.SQL_BLOCK_STATEMENT;
        }
        if (referenceElementType == null) {
            return false;
        }
        if (referenceElementType.getTargetKind() == ObjectKind.EXCEPTION) {
            return SqlNamedStubElementFactory.getDefKind(SqlNamedStubElementFactory.getSqlParent(node)) == ObjectKind.PACKAGE;
        }
        if (referenceElementType.getTargetKind() == ObjectKind.ARGUMENT) {
            SqlStubElementType stubType;
            ASTNode parent = SqlNamedStubElementFactory.getSqlParent(node);
            ASTNode gParent = SqlNamedStubElementFactory.getSqlParent(parent);
            IElementType gpType = PsiUtilCore.getElementType((ASTNode)gParent);
            return PsiUtilCore.getElementType((ASTNode)parent) == SqlCompositeElementTypes.SQL_PARAMETER_LIST && gpType instanceof SqlStubElementType && (stubType = (SqlStubElementType)gpType).shouldCreateStubForNode(gParent);
        }
        if (referenceElementType.getTargetKind() == SqlDbElementType.CURSOR) {
            return false;
        }
        if (referenceElementType.getTargetKind() == ObjectKind.VARIABLE) {
            ASTNode stubParent = SqlNamedStubElementFactory.getSqlStubParent(node);
            ObjectKind pKind = SqlNamedStubElementFactory.getDefKind(stubParent);
            if (pKind != null) {
                return pKind == ObjectKind.PACKAGE && SqlNamedStubElementFactory.shouldCreateStubFor(stubParent);
            }
            return false;
        }
        if (this.isInType(node)) {
            return false;
        }
        ASTNode parent = SqlNamedStubElementFactory.getSqlParent(node);
        IElementType iElementType = PsiUtilCore.getElementType((ASTNode)parent);
        return !(iElementType instanceof SqlDefinitionStubElementType) || (pType = (SqlDefinitionStubElementType)iElementType).shouldCreateStubForNode(parent);
    }

    protected boolean isInType(ASTNode node) {
        ASTNode p2 = SqlNamedStubElementFactory.getSqlParent(node);
        IElementType pType = PsiUtilCore.getElementType((ASTNode)p2);
        if (SqlCompositeElementTypes.SQL_TYPE_ELEMENT.contains(pType)) {
            return true;
        }
        if (pType != SqlCompositeElementTypes.SQL_TABLE_ELEMENT_LIST) {
            return false;
        }
        ASTNode gp = SqlNamedStubElementFactory.getSqlParent(p2);
        return SqlCompositeElementTypes.SQL_TYPE_ELEMENT.contains(PsiUtilCore.getElementType((ASTNode)gp));
    }

    @Nullable
    private static ObjectKind getDefKind(ASTNode node) {
        return SqlNamedStubElementFactory.getDefKind(PsiUtilCore.getElementType((ASTNode)node));
    }

    @Nullable
    private static ObjectKind getDefKind(IElementType elementType) {
        if (!(elementType instanceof SqlDefinitionStubElementType)) {
            return null;
        }
        SqlDefinitionStubElementType type = (SqlDefinitionStubElementType)elementType;
        SqlReferenceElementType refType = type.getTargetReferenceType();
        return refType == null ? null : refType.getTargetKind();
    }

    private static boolean shouldCreateStubFor(ASTNode node) {
        SqlStubElementType stubType;
        IElementType type = PsiUtilCore.getElementType((ASTNode)node);
        return type instanceof SqlStubElementType && (stubType = (SqlStubElementType)type).shouldCreateStubForNode(node);
    }

    @Nullable
    protected static ASTNode getSqlParent(@Nullable ASTNode node) {
        ASTNode aSTNode = node = node == null ? null : node.getTreeParent();
        while (node != null && node.getElementType() == SqlElementTypes.SQL_DUMMY_BLOCK) {
            node = node.getTreeParent();
        }
        return node;
    }

    @Nullable
    protected static ASTNode getSqlStubParent(@Nullable ASTNode node) {
        ASTNode aSTNode = node = node == null ? null : node.getTreeParent();
        while (node != null) {
            if (PsiUtilCore.getElementType((ASTNode)node) instanceof SqlStubElementType) {
                return node;
            }
            node = node.getTreeParent();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/sql/psi/stubs/factories/SqlNamedStubElementFactory", "<init>"));
    }
}

