/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.util;

import com.openhtmltopdf.layout.Layer;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.InlineLayoutBox;
import com.openhtmltopdf.util.DescendantBoxSpliterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class LambdaUtil {
    private LambdaUtil() {
    }

    public static Stream<Box> ancestors(Box bx) {
        ArrayList<Box> list = new ArrayList<Box>();
        while (bx != null && bx.getParent() != null) {
            list.add(bx.getParent());
            bx = bx.getParent();
        }
        return list.stream();
    }

    public static Stream<Box> descendants(Box parent) {
        return StreamSupport.stream(new DescendantBoxSpliterator(parent), false);
    }

    public static List<Box> descendantsList(Box parent) {
        return LambdaUtil.descendants(parent).collect(Collectors.toList());
    }

    public static String objectId(Object obj) {
        return obj == null ? "null" : Integer.toHexString(System.identityHashCode(obj));
    }

    public static String boxDescription(Box box) {
        if (box != null) {
            return String.format("%s => %s, layer = %s, containing = %s, class = %s", LambdaUtil.objectId(box), box, LambdaUtil.objectId(box.getLayer()), LambdaUtil.objectId(box.getContainingLayer()), box.getClass().getName());
        }
        return "[null box]";
    }

    public static String layerDescription(Layer layer) {
        if (layer != null) {
            return String.format("%s, master = %s, parent = %s", LambdaUtil.objectId(layer), LambdaUtil.boxDescription(layer.getMaster()), LambdaUtil.objectId(layer.getParent()));
        }
        return "[null layer]";
    }

    public static String ancestorDump(Box bx) {
        return LambdaUtil.boxDescription(bx) + LambdaUtil.ancestors(bx).map(LambdaUtil::boxDescription).collect(Collectors.joining("\n    ", "\nANCESTORS = [\n    ", "\n]")) + Stream.concat(Stream.of(bx.getLayer(), bx.getContainingLayer()), LambdaUtil.ancestors(bx).flatMap(box -> Stream.of(box.getLayer(), box.getContainingLayer()))).filter(Objects::nonNull).distinct().map(LambdaUtil::layerDescription).collect(Collectors.joining("\n    ", "\nREFED LAYERS = [\n    ", "\n]"));
    }

    private static void descendantDump(Box parent, int indent, List<DescendantContent> out) {
        out.add(new DescendantContent(parent, indent));
        ++indent;
        for (Box box : parent.getChildren()) {
            LambdaUtil.descendantDump(box, indent, out);
        }
        if (parent instanceof BlockBox && ((BlockBox)parent).getInlineContent() != null) {
            for (Object object : ((BlockBox)parent).getInlineContent()) {
                if (object instanceof Box) {
                    LambdaUtil.descendantDump((Box)object, indent, out);
                    continue;
                }
                out.add(new DescendantContent(object, indent));
            }
        }
        if (parent instanceof InlineLayoutBox) {
            for (Object object : ((InlineLayoutBox)parent).getInlineChildren()) {
                if (object instanceof Box) {
                    LambdaUtil.descendantDump((Box)object, indent, out);
                    continue;
                }
                out.add(new DescendantContent(object, indent));
            }
        }
    }

    public static String descendantDump(Box root) {
        StringBuilder spaces = new StringBuilder(100);
        IntStream.range(0, 100).forEach(unused -> spaces.append(' '));
        char[] space = new char[100];
        spaces.getChars(0, spaces.length(), space, 0);
        StringBuilder sb = new StringBuilder();
        ArrayList<DescendantContent> renderObjects = new ArrayList<DescendantContent>();
        LambdaUtil.descendantDump(root, 0, renderObjects);
        for (DescendantContent content : renderObjects) {
            sb.append(space, 0, Math.min(100, content.indent * 4));
            sb.append(content.object.toString() + " => " + Integer.toHexString(System.identityHashCode(content.object)));
            sb.append('\n');
        }
        return sb.toString();
    }

    public static <T> Predicate<T> alwaysTrue() {
        return unused -> true;
    }

    public static <T> Predicate<T> alwaysFalse() {
        return unused -> false;
    }

    private static class DescendantContent {
        final Object object;
        final int indent;

        DescendantContent(Object obj, int indent) {
            this.object = obj;
            this.indent = indent;
        }
    }
}

