/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.utils;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class XMLRefactoringUtil {
    public static final String CDATA_PREFIX = "<![CDATA[";
    public static final String CDATA_SUFFIX = "]]>";
    public static final String EMPTY_STR = "";
    private static final Pattern tagPattern = Pattern.compile("[A-Za-z_][A-Za-z0-9_.-]*");
    private static final Pattern attributePattern = Pattern.compile("[A-Za-z_:][A-Za-z0-9_:.-]*");

    private XMLRefactoringUtil() {
    }

    public static boolean tagNameIsValid(String tagName) {
        Matcher matcher = tagPattern.matcher(tagName);
        return matcher.matches();
    }

    public static boolean attributeNameIsValid(String attributeName) {
        Matcher matcher = attributePattern.matcher(attributeName);
        return matcher.matches();
    }

    public static String XMLEscape(String s) {
        if (s == null) {
            return s;
        }
        int len = s.length();
        StringBuilder sb = new StringBuilder(len);
        block7: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public static String stripCDataWrapper(String str) {
        if (str == null) {
            return null;
        }
        String trimmedStr = str.trim();
        if (!trimmedStr.startsWith(CDATA_PREFIX)) {
            return str;
        }
        if (!(trimmedStr = trimmedStr.substring(CDATA_PREFIX.length())).endsWith(CDATA_SUFFIX)) {
            return str;
        }
        if (trimmedStr.length() == CDATA_SUFFIX.length()) {
            return EMPTY_STR;
        }
        return trimmedStr.substring(0, trimmedStr.lastIndexOf(CDATA_SUFFIX));
    }

    public static boolean isWhitespace(String contents) {
        for (int i = 0; i < contents.length(); ++i) {
            char ch = contents.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsOuterElements(PsiElement elt) {
        final boolean[] result = new boolean[]{false};
        elt.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitOuterLanguageElement(@NotNull OuterLanguageElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                result[0] = true;
            }

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!result[0]) {
                    super.visitElement(element);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "element";
                objectArray2[1] = "com/sixrr/xrp/utils/XMLRefactoringUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitOuterLanguageElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return result[0];
    }

    @NlsSafe
    public static String attributeNameFromTag(String tagName, String attributeName) {
        int colonIndex = tagName.indexOf(58);
        if (colonIndex >= 0) {
            String prefix = tagName.substring(0, colonIndex + 1);
            String suffix = tagName.substring(colonIndex + 1);
            return prefix + XMLRefactoringUtil.matchCase(suffix, attributeName);
        }
        return XMLRefactoringUtil.matchCase(tagName, attributeName);
    }

    private static String matchCase(String stringToMatch, String stringMatched) {
        if (stringMatched == null || stringMatched.isEmpty()) {
            return StringUtil.toLowerCase((String)stringToMatch);
        }
        if (XMLRefactoringUtil.isAllLowerCase(stringMatched)) {
            return StringUtil.toLowerCase((String)stringToMatch);
        }
        if (XMLRefactoringUtil.isAllUpperCase(stringMatched)) {
            return StringUtil.toUpperCase((String)stringToMatch);
        }
        char startingChar = stringMatched.charAt(0);
        if (Character.isLowerCase(startingChar)) {
            return Character.toLowerCase(stringToMatch.charAt(0)) + stringToMatch.substring(1);
        }
        if (Character.isUpperCase(startingChar)) {
            return Character.toUpperCase(stringToMatch.charAt(0)) + stringToMatch.substring(1);
        }
        return stringToMatch;
    }

    private static boolean isAllLowerCase(String string) {
        char[] chars;
        for (char c : chars = string.toCharArray()) {
            if (!Character.isLetter(c) || Character.isLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAllUpperCase(String string) {
        char[] chars;
        for (char c : chars = string.toCharArray()) {
            if (!Character.isLetter(c) || Character.isUpperCase(c)) continue;
            return false;
        }
        return true;
    }
}

