/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.diagrams.contexts;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.facet.ProjectWideFacetAdapter;
import com.intellij.facet.ProjectWideFacetListenersRegistry;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.graph.builder.NodeGroupDescriptor;
import com.intellij.openapi.graph.builder.NodesGroup;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.diagrams.SpringGraphBundle;
import com.intellij.spring.diagrams.contexts.SpringLocalModelDiagramNodeContentManager;
import com.intellij.spring.diagrams.contexts.SpringLocalModelsRelatedVisitor;
import com.intellij.spring.diagrams.contexts.SpringNodeGroupRealizer;
import com.intellij.spring.diagrams.contexts.beans.LocalModelGraphElementWrapper;
import com.intellij.spring.diagrams.contexts.beans.LocalModelWrapper;
import com.intellij.spring.diagrams.contexts.beans.SpringLocalModelDependencyEdge;
import com.intellij.spring.diagrams.contexts.beans.SpringLocalModelDiagramNode;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.xml.DomEventListener;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.events.DomEvent;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class SpringLocalModelsDataModel
extends DiagramDataModel<LocalModelGraphElementWrapper<?>> {
    private final ProjectWideFacetAdapter<SpringFacet> myProjectWideFacetAdapter;
    @NotNull
    private final LocalModelGraphElementWrapper<?> myModel;
    @NotNull
    private final SpringLocalModelDiagramNode myRootNode;
    private final boolean myShowModuleFilesetNodes;
    private final Collection<SpringLocalModelDiagramNode> myNodes;
    private final Collection<SpringLocalModelDependencyEdge> myEdges;
    private final Map<String, NodesGroup> myNodesGroups;

    public SpringLocalModelsDataModel(@NotNull Project project, @NotNull DiagramProvider<LocalModelGraphElementWrapper<?>> provider, @NotNull LocalModelGraphElementWrapper<?> model, boolean showModuleFilesetNodes) {
        if (project == null) {
            SpringLocalModelsDataModel.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            SpringLocalModelsDataModel.$$$reportNull$$$0(1);
        }
        if (model == null) {
            SpringLocalModelsDataModel.$$$reportNull$$$0(2);
        }
        super(project, provider);
        this.myNodes = new LinkedHashSet<SpringLocalModelDiagramNode>();
        this.myEdges = new LinkedHashSet<SpringLocalModelDependencyEdge>();
        this.myNodesGroups = new LinkedHashMap<String, NodesGroup>();
        this.myModel = model;
        this.myRootNode = new SpringLocalModelDiagramNode(model, provider);
        this.myShowModuleFilesetNodes = showModuleFilesetNodes;
        DomEventListener domEventListener = new DomEventListener(){

            public void eventOccured(@NotNull DomEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                SpringLocalModelsDataModel.this.incModificationCount();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/spring/diagrams/contexts/SpringLocalModelsDataModel$1", "eventOccured"));
            }
        };
        DomManager.getDomManager((Project)project).addDomEventListener(domEventListener, (Disposable)this);
        this.myProjectWideFacetAdapter = new ProjectWideFacetAdapter<SpringFacet>(){

            public void facetConfigurationChanged(@NotNull SpringFacet facet) {
                if (facet == null) {
                    2.$$$reportNull$$$0(0);
                }
                SpringLocalModelsDataModel.this.incModificationCount();
            }

            public void facetRemoved(@NotNull SpringFacet facet) {
                if (facet == null) {
                    2.$$$reportNull$$$0(1);
                }
                SpringLocalModelsDataModel.this.incModificationCount();
            }

            public void facetAdded(@NotNull SpringFacet facet) {
                if (facet == null) {
                    2.$$$reportNull$$$0(2);
                }
                SpringLocalModelsDataModel.this.incModificationCount();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "facet";
                objectArray2[1] = "com/intellij/spring/diagrams/contexts/SpringLocalModelsDataModel$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetConfigurationChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetAdded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ProjectWideFacetListenersRegistry.getInstance((Project)this.getProject()).registerListener(SpringFacet.FACET_TYPE_ID, this.myProjectWideFacetAdapter, (Disposable)this);
        MessageBusConnection messageBusConnection = this.getProject().getMessageBus().connect((Disposable)this);
        messageBusConnection.setDefaultHandler(() -> this.incModificationCount());
        messageBusConnection.subscribe(ModuleRootListener.TOPIC);
        messageBusConnection.subscribe(ModuleListener.TOPIC);
        messageBusConnection.subscribe(PsiModificationTracker.TOPIC);
    }

    @NotNull
    public Collection<? extends DiagramNode<LocalModelGraphElementWrapper<?>>> getNodes() {
        Collection<SpringLocalModelDiagramNode> collection = this.myNodes;
        if (collection == null) {
            SpringLocalModelsDataModel.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @NotNull
    public Collection<? extends DiagramEdge<LocalModelGraphElementWrapper<?>>> getEdges() {
        Collection<SpringLocalModelDependencyEdge> collection = this.myEdges;
        if (collection == null) {
            SpringLocalModelsDataModel.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    public String getNodeName(@NotNull DiagramNode<LocalModelGraphElementWrapper<?>> n) {
        if (n == null) {
            SpringLocalModelsDataModel.$$$reportNull$$$0(5);
        }
        String string = ((LocalModelGraphElementWrapper)n.getIdentifyingElement()).getTitle();
        if (string == null) {
            SpringLocalModelsDataModel.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public DiagramNode<LocalModelGraphElementWrapper<?>> addElement(@Nullable LocalModelGraphElementWrapper element) {
        return null;
    }

    @NotNull
    public CompletableFuture<Void> refreshDataModelAsync(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            SpringLocalModelsDataModel.$$$reportNull$$$0(7);
        }
        this.clearAll();
        CancellablePromise promise = ReadAction.nonBlocking(() -> {
            SpringLocalModelsRelatedVisitor visitor = new SpringLocalModelsRelatedVisitor(this.getProject(), this.myRootNode, this.getProvider(), this.showLibraryConfigs(), this.myShowModuleFilesetNodes);
            this.myModel.accept(visitor);
            return visitor;
        }).expireWith((Disposable)this).inSmartMode(this.getProject()).wrapProgress(indicator).coalesceBy(new Object[]{this}).finishOnUiThread(ModalityState.any(), visitor -> {
            this.myNodes.addAll(visitor.getNodes());
            this.myEdges.addAll(visitor.getEdges());
        }).submit((Executor)AppExecutorUtil.getAppExecutorService());
        CompletableFuture completableFuture = Promises.asCompletableFuture((Promise)promise.then(updater -> null));
        if (completableFuture == null) {
            SpringLocalModelsDataModel.$$$reportNull$$$0(8);
        }
        return completableFuture;
    }

    private void clearAll() {
        this.myEdges.clear();
        this.myNodes.clear();
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        SpringLocalModelsDataModel springLocalModelsDataModel = this;
        if (springLocalModelsDataModel == null) {
            SpringLocalModelsDataModel.$$$reportNull$$$0(9);
        }
        return springLocalModelsDataModel;
    }

    public void dispose() {
        ProjectWideFacetListenersRegistry.getInstance((Project)this.getProject()).unregisterListener(SpringFacet.FACET_TYPE_ID, this.myProjectWideFacetAdapter);
    }

    @NotNull
    public SpringLocalModelDiagramNode getRootNode() {
        SpringLocalModelDiagramNode springLocalModelDiagramNode = this.myNodes.iterator().next();
        if (springLocalModelDiagramNode == null) {
            SpringLocalModelsDataModel.$$$reportNull$$$0(10);
        }
        return springLocalModelDiagramNode;
    }

    private boolean showLibraryConfigs() {
        return Objects.requireNonNull(this.getNodeContentManager()).isCategoryEnabled(SpringLocalModelDiagramNodeContentManager.SHOW_LIBRARY_CONFIGS);
    }

    private boolean showFilesetsAsGroups() {
        return Objects.requireNonNull(this.getNodeContentManager()).isCategoryEnabled(SpringLocalModelDiagramNodeContentManager.SHOW_GROUPS);
    }

    @Nullable
    public NodeGroupDescriptor getGroup(@NotNull DiagramNode<LocalModelGraphElementWrapper<?>> n) {
        SpringFileSet localModelFileSet;
        LocalModelGraphElementWrapper elementWrapper;
        if (n == null) {
            SpringLocalModelsDataModel.$$$reportNull$$$0(11);
        }
        if (!this.myShowModuleFilesetNodes && this.showFilesetsAsGroups() && (elementWrapper = (LocalModelGraphElementWrapper)n.getIdentifyingElement()) instanceof LocalModelWrapper && (localModelFileSet = SpringLocalModelsDataModel.getFileSetLocalModelConfiguredIn(((LocalModelWrapper)elementWrapper).getElement())) != null) {
            String fileSetName = localModelFileSet.getName();
            NodesGroup group = this.myNodesGroups.get(fileSetName);
            if (group == null) {
                group = new SpringNodeGroupRealizer(fileSetName);
                this.myNodesGroups.put(fileSetName, group);
            }
            return group;
        }
        return super.getGroup(n);
    }

    public void removeEdge(@NotNull DiagramEdge<LocalModelGraphElementWrapper<?>> edge) {
        if (edge == null) {
            SpringLocalModelsDataModel.$$$reportNull$$$0(12);
        }
        if (edge instanceof SpringLocalModelDependencyEdge) {
            SpringLocalModelDependencyEdge localModelDependencyEdge = (SpringLocalModelDependencyEdge)edge;
            PsiElement dependencyIdentifyingElement = localModelDependencyEdge.getDependency().getIdentifyingElement();
            if (dependencyIdentifyingElement == null) {
                return;
            }
            List<SpringLocalModelDependencyEdge> edges = this.getEdgesByIdentifyingElement(dependencyIdentifyingElement);
            if (edges.size() > 1) {
                return;
            }
            Runnable runnable = () -> ((PsiElement)dependencyIdentifyingElement).delete();
            DiagramAction.performCommand((DiagramBuilder)this.getBuilder(), (Runnable)runnable, (String)SpringGraphBundle.message("spring.diagrams.remove.edge.action", new Object[0]), null, (PsiElement[])new PsiElement[]{dependencyIdentifyingElement.getContainingFile()});
        }
    }

    private List<SpringLocalModelDependencyEdge> getEdgesByIdentifyingElement(@NotNull PsiElement dependencyIdentifyingElement) {
        if (dependencyIdentifyingElement == null) {
            SpringLocalModelsDataModel.$$$reportNull$$$0(13);
        }
        PsiElement myNavigationElement = dependencyIdentifyingElement.getNavigationElement();
        return ContainerUtil.filter(this.myEdges, edge -> {
            PsiElement otherElement = edge.getDependency().getIdentifyingElement();
            return otherElement != null && myNavigationElement.equals((Object)otherElement.getNavigationElement());
        });
    }

    private static SpringFileSet getFileSetLocalModelConfiguredIn(@NotNull LocalModel<?> localModel) {
        SpringFacet facet;
        Module module;
        if (localModel == null) {
            SpringLocalModelsDataModel.$$$reportNull$$$0(14);
        }
        if ((module = localModel.getModule()) != null && (facet = SpringFacet.getInstance((Module)module)) != null) {
            Set fileSets = SpringFileSetService.getInstance().getAllSets(facet);
            for (SpringFileSet fileSet : fileSets) {
                if (!fileSet.hasFile(localModel.getConfig().getContainingFile().getVirtualFile())) continue;
                return fileSet;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/diagrams/contexts/SpringLocalModelsDataModel";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "n";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edge";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyIdentifyingElement";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/diagrams/contexts/SpringLocalModelsDataModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "refreshDataModelAsync";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNodeName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "refreshDataModelAsync";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getGroup";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeEdge";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getEdgesByIdentifyingElement";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFileSetLocalModelConfiguredIn";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6, 8, 9, 10 -> new IllegalStateException(string);
        };
    }
}

