/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.prettierjs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.idea.AppMode;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.json.psi.JsonFile;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonCommonUtil;
import com.intellij.lang.javascript.linter.JSLinterConfigFileUtil;
import com.intellij.lang.javascript.linter.JSLinterConfigLangSubstitutor;
import com.intellij.lang.javascript.psi.util.JSPluginPathManager;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.BaseProjectDirectories;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.prettierjs.PrettierConfig;
import com.intellij.prettierjs.PrettierConfiguration;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.ui.LightweightHint;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import icons.JavaScriptLanguageIcons;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;

public final class PrettierUtil {
    public static final Icon ICON = JavaScriptLanguageIcons.FileTypes.Prettier;
    public static final String PACKAGE_NAME = "prettier";
    public static final String CONFIG_SECTION_NAME = "prettier";
    public static final String RC_FILE_NAME = ".prettierrc";
    public static final String CONFIG_FILE_NAME = "prettier.config";
    public static final String EDITOR_CONFIG_FILE_NAME = ".editorconfig";
    static final String IGNORE_FILE_NAME = ".prettierignore";
    private static final List<String> CONFIG_FILE_NAMES = List.of(".prettierrc", ".prettierrc.json", ".prettierrc.yml", ".prettierrc.yaml", ".prettierrc.json5", ".prettierrc.js", "prettier.config.js", ".prettierrc.mjs", "prettier.config.mjs", ".prettierrc.cjs", "prettier.config.cjs", ".prettierrc.ts", "prettier.config.ts", ".prettierrc.mts", "prettier.config.mts", ".prettierrc.cts", "prettier.config.cts", ".prettierrc.toml");
    private static final List<String> CONFIG_FILE_NAMES_WITH_PACKAGE_JSON = ContainerUtil.append(CONFIG_FILE_NAMES, (Object[])new String[]{"package.json"});
    public static final SemVer MIN_VERSION = new SemVer("1.13.0", 1, 13, 0);
    public static final SemVer NODE_MIN_VERSION_FOR_STRIP_TYPES_FLAG = new SemVer("22.6.0", 22, 6, 0);
    public static final SemVer NODE_MAX_VERSION_FOR_STRIP_TYPES_FLAG = new SemVer("23.6.0", 23, 6, 0);
    private static final Logger LOG = Logger.getInstance(PrettierUtil.class);

    private PrettierUtil() {
    }

    public static boolean isConfigFile(@NotNull PsiElement element) {
        PsiFile file;
        if (element == null) {
            PrettierUtil.$$$reportNull$$$0(0);
        }
        PsiFile psiFile = file = element instanceof PsiFile ? (PsiFile)element : null;
        if (file == null || file.isDirectory() || !file.isValid()) {
            return false;
        }
        return PrettierUtil.isConfigFile(file.getVirtualFile());
    }

    public static boolean isConfigFileOrPackageJson(@Nullable VirtualFile virtualFile) {
        return PackageJsonCommonUtil.isPackageJsonFile((VirtualFile)virtualFile) || PrettierUtil.isConfigFile(virtualFile);
    }

    @Contract(value="null -> false")
    public static boolean isJSConfigFile(@Nullable VirtualFile virtualFile) {
        return PrettierUtil.isConfigFile(virtualFile) && ArrayUtil.contains((String)StringUtil.toLowerCase((String)virtualFile.getExtension()), (String[])new String[]{"js", "mjs", "cjs"});
    }

    @Contract(value="null -> false")
    public static boolean isNonJSConfigFile(@Nullable VirtualFile virtualFile) {
        return PrettierUtil.isConfigFile(virtualFile) && !ArrayUtil.contains((String)StringUtil.toLowerCase((String)virtualFile.getExtension()), (String[])new String[]{"js", "mjs", "cjs", "ts", "mts", "cts"});
    }

    @Contract(value="null -> false")
    public static boolean isConfigFile(@Nullable VirtualFile virtualFile) {
        return virtualFile != null && CONFIG_FILE_NAMES.contains(virtualFile.getName());
    }

    @NotNull
    public static Collection<VirtualFile> lookupPossibleConfigFiles(@NotNull List<VirtualFile> from, @NotNull Project project) {
        if (from == null) {
            PrettierUtil.$$$reportNull$$$0(1);
        }
        if (project == null) {
            PrettierUtil.$$$reportNull$$$0(2);
        }
        HashSet<VirtualFile> results = new HashSet<VirtualFile>();
        Set baseDirs = BaseProjectDirectories.getBaseDirectories((Project)project);
        if (baseDirs.isEmpty()) {
            HashSet<VirtualFile> hashSet = results;
            if (hashSet == null) {
                PrettierUtil.$$$reportNull$$$0(3);
            }
            return hashSet;
        }
        for (VirtualFile file : from) {
            PrettierUtil.addPossibleConfigsForFile(file, results, baseDirs);
        }
        HashSet<VirtualFile> hashSet = results;
        if (hashSet == null) {
            PrettierUtil.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    private static void addPossibleConfigsForFile(@NotNull VirtualFile from, @NotNull Set<VirtualFile> result, @NotNull Set<VirtualFile> baseDirs) {
        if (from == null) {
            PrettierUtil.$$$reportNull$$$0(5);
        }
        if (result == null) {
            PrettierUtil.$$$reportNull$$$0(6);
        }
        if (baseDirs == null) {
            PrettierUtil.$$$reportNull$$$0(7);
        }
        for (VirtualFile current = from.getParent(); current != null && current.isValid() && current.isDirectory(); current = current.getParent()) {
            for (String name : CONFIG_FILE_NAMES_WITH_PACKAGE_JSON) {
                VirtualFile file = current.findChild(name);
                if (file == null || !file.isValid() || file.isDirectory()) continue;
                result.add(file);
            }
            if (!baseDirs.contains(current)) continue;
            return;
        }
    }

    @Nullable
    public static VirtualFile findSingleConfigInContentRoots(@NotNull Project project) {
        if (project == null) {
            PrettierUtil.$$$reportNull$$$0(8);
        }
        return JSLinterConfigFileUtil.findDistinctConfigInContentRoots((Project)project, CONFIG_FILE_NAMES_WITH_PACKAGE_JSON, file -> {
            if (PackageJsonCommonUtil.isPackageJsonFile((VirtualFile)file)) {
                PackageJsonData data = PackageJsonData.getOrCreate((VirtualFile)file);
                return data.getTopLevelProperties().contains("prettier");
            }
            return true;
        });
    }

    @Nullable
    public static VirtualFile findSingleConfigInDirectory(@NotNull VirtualFile dir) {
        if (dir == null) {
            PrettierUtil.$$$reportNull$$$0(9);
        }
        if (!dir.isDirectory()) {
            return null;
        }
        List configs = ContainerUtil.mapNotNull(CONFIG_FILE_NAMES, name -> dir.findChild(name));
        return configs.size() == 1 ? (VirtualFile)configs.getFirst() : null;
    }

    @Nullable
    public static VirtualFile findFileConfig(@NotNull Project project, @NotNull VirtualFile from) {
        if (project == null) {
            PrettierUtil.$$$reportNull$$$0(10);
        }
        if (from == null) {
            PrettierUtil.$$$reportNull$$$0(11);
        }
        Ref result = Ref.create();
        JSProjectUtil.processDirectoriesUpToContentRoot((Project)project, (VirtualFile)from, directory -> {
            VirtualFile config = PrettierUtil.findChildConfigFile(directory);
            if (config != null) {
                result.set((Object)config);
                return false;
            }
            return true;
        });
        return (VirtualFile)result.get();
    }

    @Nullable
    public static VirtualFile findChildConfigFile(@Nullable VirtualFile dir) {
        if (dir != null && dir.isValid()) {
            for (String name : CONFIG_FILE_NAMES_WITH_PACKAGE_JSON) {
                VirtualFile file = dir.findChild(name);
                if (file == null || !file.isValid() || file.isDirectory()) continue;
                if (PackageJsonCommonUtil.isPackageJsonFile((VirtualFile)file)) {
                    PackageJsonData data = PackageJsonData.getOrCreate((VirtualFile)file);
                    if (!data.getTopLevelProperties().contains("prettier")) continue;
                    return file;
                }
                return file;
            }
        }
        return null;
    }

    @Nullable
    public static PrettierConfig parseConfig(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        if (project == null) {
            PrettierUtil.$$$reportNull$$$0(12);
        }
        if (virtualFile == null) {
            PrettierUtil.$$$reportNull$$$0(13);
        }
        return (PrettierConfig)ReadAction.compute(() -> {
            if (!PrettierUtil.isConfigFileOrPackageJson(virtualFile)) {
                return null;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
            if (psiFile == null) {
                return null;
            }
            return (PrettierConfig)CachedValuesManager.getCachedValue((PsiElement)psiFile, () -> CachedValueProvider.Result.create((Object)PrettierUtil.parseConfigInternal(psiFile), (Object[])new Object[]{psiFile}));
        });
    }

    @Nullable
    private static PrettierConfig parseConfigInternal(@NotNull PsiFile file) {
        if (file == null) {
            PrettierUtil.$$$reportNull$$$0(14);
        }
        try {
            if (PackageJsonCommonUtil.isPackageJsonFile((PsiFile)file)) {
                PackageJsonData packageJsonData = PackageJsonData.getOrCreate((VirtualFile)file.getVirtualFile());
                if (!packageJsonData.isDependencyOfAnyType("prettier")) {
                    return null;
                }
                Object prettierProperty = ((Map)ObjectUtils.coalesce((Object)((Map)Holder.OUR_GSON_SERIALIZER.fromJson(file.getText(), Map.class)), Collections.emptyMap())).get("prettier");
                return prettierProperty instanceof Map ? PrettierConfig.createFromMap((Map)prettierProperty) : null;
            }
            if (file instanceof JsonFile) {
                return PrettierUtil.parseConfigFromJsonText(file.getText());
            }
            if (JSLinterConfigLangSubstitutor.YamlLanguageHolder.INSTANCE.equals(file.getLanguage())) {
                return PrettierConfig.createFromMap((Map)new Yaml().load(file.getText()));
            }
        }
        catch (Exception e) {
            LOG.info(String.format("Could not read config data from file [%s]", file.getVirtualFile().getPath()), (Throwable)e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static PrettierConfig parseConfigFromJsonText(String text) {
        try (JsonReader reader = new JsonReader((Reader)new StringReader(text));){
            if (reader.peek() == JsonToken.STRING) {
                PrettierConfig prettierConfig2 = null;
                return prettierConfig2;
            }
            PrettierConfig prettierConfig3 = PrettierConfig.createFromMap((Map)Holder.OUR_GSON_SERIALIZER.fromJson(reader, Map.class));
            return prettierConfig3;
        }
        catch (IOException e) {
            LOG.info("Could not parse config from text", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static VirtualFile findIgnoreFile(@NotNull Project project, @NotNull VirtualFile source) {
        PrettierConfiguration configuration;
        if (project == null) {
            PrettierUtil.$$$reportNull$$$0(15);
        }
        if (source == null) {
            PrettierUtil.$$$reportNull$$$0(16);
        }
        if ((configuration = PrettierConfiguration.getInstance(project)).isDisabled()) {
            return null;
        }
        String ignorePath = configuration.getCustomIgnorePath();
        if (configuration.isAutomatic() || ignorePath.isBlank()) {
            return PrettierUtil.findAutoIgnoreFile(project, source);
        }
        return LocalFileSystem.getInstance().findFileByPath(ignorePath);
    }

    @Nullable
    private static VirtualFile findAutoIgnoreFile(@NotNull Project project, @NotNull VirtualFile source) {
        VirtualFile fileDir;
        if (project == null) {
            PrettierUtil.$$$reportNull$$$0(17);
        }
        if (source == null) {
            PrettierUtil.$$$reportNull$$$0(18);
        }
        if ((fileDir = source.getParent()) == null) {
            return null;
        }
        return JSProjectUtil.findFileUpToContentRoot((Project)project, (VirtualFile)fileDir, (String[])new String[]{IGNORE_FILE_NAME});
    }

    public static void showHintLater(@NotNull Editor editor, @NotNull @Nls String text, boolean isError, @Nullable HyperlinkListener hyperlinkListener) {
        if (editor == null) {
            PrettierUtil.$$$reportNull$$$0(19);
        }
        if (text == null) {
            PrettierUtil.$$$reportNull$$$0(20);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            JComponent component = isError ? HintUtil.createErrorLabel((String)text, (HyperlinkListener)hyperlinkListener, null) : HintUtil.createInformationLabel((String)text, (HyperlinkListener)hyperlinkListener, null, null);
            LightweightHint hint = new LightweightHint(component);
            HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, (short)2, 42, 0, false);
        }, ModalityState.nonModal(), o -> editor.isDisposed() || !editor.getComponent().isShowing());
    }

    public static void addExperimentalStripTypesIfNeeded(@NotNull NodeTargetRun targetRun, @NotNull String serviceName) {
        SemVer nodeVersion;
        if (targetRun == null) {
            PrettierUtil.$$$reportNull$$$0(21);
        }
        if (serviceName == null) {
            PrettierUtil.$$$reportNull$$$0(22);
        }
        NodeJsInterpreter interpreter = targetRun.getInterpreter();
        try {
            nodeVersion = (SemVer)interpreter.provideCachedVersionOrFetch().blockingGet(1500, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            nodeVersion = null;
        }
        if (nodeVersion != null && nodeVersion.compareTo(NODE_MIN_VERSION_FOR_STRIP_TYPES_FLAG) >= 0 && nodeVersion.compareTo(NODE_MAX_VERSION_FOR_STRIP_TYPES_FLAG) < 0) {
            JSLanguageServiceUtil.addNodeProcessArguments((TargetedCommandLineBuilder)targetRun.getCommandLineBuilder(), (String)serviceName, (String)"--experimental-strip-types");
        }
    }

    static Path getPrettierLanguageServicePath() throws IOException {
        return JSPluginPathManager.getPluginResource(PrettierUtil.class, (String)"prettierLanguageService", (String)(AppMode.isRunningFromDevBuild() ? "prettierJS" : "prettierJS/gen"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 2: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/prettierjs/PrettierUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDirs";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRun";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/prettierjs/PrettierUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "lookupPossibleConfigFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isConfigFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "lookupPossibleConfigFiles";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addPossibleConfigsForFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findSingleConfigInContentRoots";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findSingleConfigInDirectory";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findFileConfig";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseConfig";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parseConfigInternal";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findIgnoreFile";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findAutoIgnoreFile";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "showHintLater";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addExperimentalStripTypesIfNeeded";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }

    private static final class Holder {
        static final Gson OUR_GSON_SERIALIZER = new GsonBuilder().create();

        private Holder() {
        }
    }
}

