/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen;

import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen.NotebookGraphicsConfigurationManager;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen.raster.JcefOffScreenRaster;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen.raster.JcefOffScreenViewComponent;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen.raster.JcefOffscreenPopupComponent;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.awt.AnchoredPoint;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.nio.ByteBuffer;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0016\u001a\u00020\rH\u0002J\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006!"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/NotebookPopupManager;", "", "raster", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/JcefOffScreenRaster;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "<init>", "(Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/JcefOffScreenRaster;Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "setEditor", "(Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "popupComponent", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/JcefOffscreenPopupComponent;", "popup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "currentComponent", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/JcefOffScreenViewComponent;", "getCurrentComponent", "()Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/JcefOffScreenViewComponent;", "setCurrentComponent", "(Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/JcefOffScreenViewComponent;)V", "createOrGetPopup", "tryHide", "", "setPopupRect", "size", "Ljava/awt/Rectangle;", "updatePopupImage", "rect", "buffer", "Ljava/nio/ByteBuffer;", "tryShow", "intellij.jupyter.core"})
public final class NotebookPopupManager {
    @NotNull
    private final JcefOffScreenRaster raster;
    @Nullable
    private EditorImpl editor;
    @Nullable
    private JcefOffscreenPopupComponent popupComponent;
    @Nullable
    private JBPopup popup;
    @Nullable
    private JcefOffScreenViewComponent currentComponent;

    public NotebookPopupManager(@NotNull JcefOffScreenRaster raster, @Nullable EditorImpl editor) {
        Intrinsics.checkNotNullParameter((Object)raster, (String)"raster");
        this.raster = raster;
        this.editor = editor;
    }

    @Nullable
    public final EditorImpl getEditor() {
        return this.editor;
    }

    public final void setEditor(@Nullable EditorImpl editorImpl) {
        this.editor = editorImpl;
    }

    @Nullable
    public final JcefOffScreenViewComponent getCurrentComponent() {
        return this.currentComponent;
    }

    public final void setCurrentComponent(@Nullable JcefOffScreenViewComponent jcefOffScreenViewComponent) {
        this.currentComponent = jcefOffScreenViewComponent;
    }

    private final JcefOffscreenPopupComponent createOrGetPopup() {
        JcefOffscreenPopupComponent newPopup;
        JcefOffscreenPopupComponent jcefOffscreenPopupComponent;
        JcefOffscreenPopupComponent popupComponent = this.popupComponent;
        if (popupComponent != null) {
            return popupComponent;
        }
        JcefOffscreenPopupComponent $this$createOrGetPopup_u24lambda_u240 = jcefOffscreenPopupComponent = new JcefOffscreenPopupComponent();
        boolean bl = false;
        EditorImpl editor = this.editor;
        if (editor != null && !editor.isDisposed()) {
            $this$createOrGetPopup_u24lambda_u240.setScreenScale$intellij_jupyter_core(NotebookGraphicsConfigurationManager.Companion.getScreenScale((Editor)editor));
        }
        this.popupComponent = newPopup = jcefOffscreenPopupComponent;
        return newPopup;
    }

    public final void tryHide() {
        ActionsKt.invokeLater$default(null, () -> NotebookPopupManager.tryHide$lambda$0(this), (int)1, null);
    }

    public final void setPopupRect(@NotNull Rectangle size) {
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        this.createOrGetPopup().setPopupRect(size);
        this.tryShow();
    }

    public final void updatePopupImage(@NotNull Rectangle rect, @NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.createOrGetPopup().updatePopupImage(rect, buffer);
    }

    public final void tryShow() {
        JBPopup popup;
        if (this.popup != null) {
            JcefOffscreenPopupComponent jcefOffscreenPopupComponent = this.popupComponent;
            if (jcefOffscreenPopupComponent != null) {
                jcefOffscreenPopupComponent.repaint();
            }
            return;
        }
        JcefOffScreenViewComponent jcefOffScreenViewComponent = this.currentComponent;
        if (jcefOffScreenViewComponent == null) {
            return;
        }
        JcefOffScreenViewComponent currentComponent = jcefOffScreenViewComponent;
        JcefOffscreenPopupComponent jcefOffscreenPopupComponent = this.popupComponent;
        if (jcefOffscreenPopupComponent == null) {
            return;
        }
        JcefOffscreenPopupComponent popupComponent = jcefOffscreenPopupComponent;
        if (popupComponent.getPopupImage() == null) {
            return;
        }
        Rectangle rectangle = popupComponent.getPopupRect();
        if (rectangle == null) {
            return;
        }
        Rectangle popupRect = rectangle;
        popupComponent.setEventsTarget(currentComponent);
        ComponentPopupBuilder componentPopupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)popupComponent, (JComponent)popupComponent);
        Intrinsics.checkNotNullExpressionValue((Object)componentPopupBuilder, (String)"createComponentPopupBuilder(...)");
        ComponentPopupBuilder popupBuilder = componentPopupBuilder;
        JBPopup jBPopup = popupBuilder.createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"createPopup(...)");
        this.popup = popup = jBPopup;
        SwingUtilities.invokeLater(() -> NotebookPopupManager.tryShow$lambda$0(this, currentComponent, popupRect, popup, popupComponent));
    }

    private static final Unit tryHide$lambda$0(NotebookPopupManager this$0) {
        JBPopup jBPopup = this$0.popup;
        if (jBPopup != null) {
            jBPopup.cancel();
        }
        this$0.popupComponent = null;
        this$0.popup = null;
        return Unit.INSTANCE;
    }

    private static final void tryShow$lambda$0(NotebookPopupManager this$0, JcefOffScreenViewComponent $currentComponent, Rectangle $popupRect, JBPopup $popup, JcefOffscreenPopupComponent $popupComponent) {
        EditorImpl editor = this$0.editor;
        if (editor == null || editor.isDisposed()) {
            return;
        }
        Point point = new Point($currentComponent.getX(), $currentComponent.getY());
        Point currentComponentSwingViewportPosition = SwingUtilities.convertPoint($currentComponent, point, editor.getScrollPane().getViewport());
        int currentComponentCEFViewportPosition = $currentComponent.getViewPort().getBounds().y - this$0.raster.getCefScrollY();
        int yPos = $popupRect.y + currentComponentSwingViewportPosition.y - currentComponentCEFViewportPosition;
        JViewport jViewport = editor.getScrollPane().getViewport();
        Intrinsics.checkNotNullExpressionValue((Object)jViewport, (String)"getViewport(...)");
        $popup.show((RelativePoint)new AnchoredPoint(AnchoredPoint.Anchor.TOP_LEFT, (Component)jViewport, new Point($popupRect.x, yPos)));
        $popupComponent.setMousePointShift(new Point($popupRect.x, $popupRect.y - currentComponentCEFViewportPosition));
        $popupComponent.requestFocus();
    }
}

