/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.basic;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.database.model.BaseModel;
import com.intellij.database.model.DasOperator;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ModelUtil;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicArgument;
import com.intellij.database.model.basic.BasicArrangedElement;
import com.intellij.database.model.basic.BasicCheck;
import com.intellij.database.model.basic.BasicColumniation;
import com.intellij.database.model.basic.BasicConstraint;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicHierarchicalObject;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicIntrospectableArea;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.basic.BasicModColumniation;
import com.intellij.database.model.basic.BasicModConstraint;
import com.intellij.database.model.basic.BasicModDatabase;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModForeignKey;
import com.intellij.database.model.basic.BasicModIndex;
import com.intellij.database.model.basic.BasicModKey;
import com.intellij.database.model.basic.BasicModMateNamespace;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModNamespace;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicModSequence;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicModTableColumn;
import com.intellij.database.model.basic.BasicModTableOrView;
import com.intellij.database.model.basic.BasicModTableOrViewColumn;
import com.intellij.database.model.basic.BasicModToggleable;
import com.intellij.database.model.basic.BasicModTrigger;
import com.intellij.database.model.basic.BasicModTypedElement;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicOverloadable;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.basic.BasicSynonym;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTableColumn;
import com.intellij.database.model.basic.BasicTableOrView;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import com.intellij.database.model.basic.BasicToggleable;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.basic.BasicTypedElement;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaReference;
import com.intellij.database.model.meta.BasicMetaReferenceDesc;
import com.intellij.database.model.meta.BasicMetaReferenceId;
import com.intellij.database.model.meta.BasicMetaReferenceList;
import com.intellij.database.model.meta.BasicMetaReferenceListId;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.meta.RawMetaReferenceDesc;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.BasicReferenceInfo;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.model.properties.Level;
import com.intellij.database.model.properties.SourceError;
import com.intellij.database.model.properties.references.BasicByColumnNamesReference;
import com.intellij.database.model.properties.references.BasicByColumnPositionsOrNamesReference;
import com.intellij.database.model.properties.references.BasicByColumnPositionsReference;
import com.intellij.database.model.properties.references.BasicIdOrNameReference;
import com.intellij.database.model.properties.references.BasicIdReference;
import com.intellij.database.model.properties.references.BasicKeyByIndexReference;
import com.intellij.database.model.properties.references.BasicRefImporter;
import com.intellij.database.types.DasTypeSystem;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbUtil;
import com.intellij.database.util.ObjectNamePart;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneratedModelUtil {
    public static void setSourceText(@NotNull BasicModSourceAware element, @Nullable CompositeText sourceText) {
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(0);
        }
        BasicModModel model = element.getModel();
        element.setSourceTextLength(sourceText != null ? sourceText.getLength() : 0);
        model.saveSourceText(element, sourceText);
    }

    @Nullable
    public static CompositeText getSourceText(@NotNull BasicSourceAware element) {
        BasicModModel model;
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(1);
        }
        if ((model = (BasicModModel)element.getModel()) == null) {
            return null;
        }
        return model.loadSourceText(element);
    }

    public static void setSourceTextLength(@NotNull BasicModSourceAware element, int sourceTextLength) {
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(2);
        }
    }

    public static int getSourceTextLength(@NotNull BasicSourceAware element) {
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(3);
        }
        return 0;
    }

    @NotNull
    public static JBIterable<BasicElement> getPredecessors(@NotNull BasicElement element) {
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(4);
        }
        JBIterable jBIterable = BasicMetaUtils.getMetaObject(element).getAllProperties().filterMap(BasicMetaReference::asRef).filterMap(r -> r.isAbstract() || r.getReferenceDesc().isBackRef() || r.id == BasicModKey.UNDERLYING_INDEX_REF ? null : (BasicElement)BasicMetaUtils.resolve(element, r));
        if (jBIterable == null) {
            GeneratedModelUtil.$$$reportNull$$$0(5);
        }
        return jBIterable;
    }

    @NotNull
    public static Iterable<? extends BasicElement> getPredecessors(@NotNull BasicColumniation element) {
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(6);
        }
        JBIterable jBIterable = GeneratedModelUtil.getPredecessors((BasicElement)element).append((Iterable)element.getCols());
        if (jBIterable == null) {
            GeneratedModelUtil.$$$reportNull$$$0(7);
        }
        return jBIterable;
    }

    @NotNull
    public static Iterable<? extends BasicElement> getPredecessors(@NotNull BasicForeignKey element) {
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(8);
        }
        JBIterable jBIterable = JBIterable.of((Object[])new BasicElement[]{element.getRefTable(), element.getRefKey()}).append(GeneratedModelUtil.getPredecessors((BasicColumniation)element)).append((Iterable)element.getRefCols());
        if (jBIterable == null) {
            GeneratedModelUtil.$$$reportNull$$$0(9);
        }
        return jBIterable;
    }

    @NotNull
    public static Iterable<? extends BasicElement> getPredecessors(@NotNull BasicSynonym element) {
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(10);
        }
        JBIterable jBIterable = JBIterable.of((Object)element.getTargetObject());
        if (jBIterable == null) {
            GeneratedModelUtil.$$$reportNull$$$0(11);
        }
        return jBIterable;
    }

    public static void handleRename(@NotNull BasicModElement e, @NotNull ObjectNamePart oldName) {
        if (e == null) {
            GeneratedModelUtil.$$$reportNull$$$0(12);
        }
        if (oldName == null) {
            GeneratedModelUtil.$$$reportNull$$$0(13);
        }
        BasicHierarchicalObject base = (BasicHierarchicalObject)e;
        ((BaseModel)base.getModel()).handleRename(base, oldName);
    }

    public static List<String> getColNames(BasicKey key) {
        return GeneratedModelUtil.getRefColNamesByUnderlyingIndex(key);
    }

    public static void setColNames(BasicModKey key, List<String> names) {
        GeneratedModelUtil.setColNamesByUnderlyingIndex(key, names);
    }

    public static List<String> getRefColNamesByKey(BasicForeignKey fk) {
        return GeneratedModelUtil.getColNames(fk.getRefKeyRefInfo(), fk.getRefTable());
    }

    public static List<String> getRefColNamesByUnderlyingIndex(BasicKey key) {
        return GeneratedModelUtil.getColNames(key.getUnderlyingIndexRefInfo(), null);
    }

    @NotNull
    protected static List<String> getColNames(BasicReferenceInfo<? extends BasicColumniation> info, BasicTable targetTable) {
        List<String> res;
        BasicReferenceInfo<BasicIndex> indexRefInfo;
        if (info == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                GeneratedModelUtil.$$$reportNull$$$0(14);
            }
            return list;
        }
        BasicReference ref = info.getReference();
        BasicByColumnNamesReference byNamesRef = (BasicByColumnNamesReference)ObjectUtils.tryCast((Object)ref, BasicByColumnNamesReference.class);
        if (byNamesRef != null) {
            List<String> list = byNamesRef.getColNames();
            if (list == null) {
                GeneratedModelUtil.$$$reportNull$$$0(15);
            }
            return list;
        }
        BasicColumniation c2 = info.getTargetOrInlineData();
        if (c2 != null) {
            List<String> list = c2.getColNames();
            if (list == null) {
                GeneratedModelUtil.$$$reportNull$$$0(16);
            }
            return list;
        }
        BasicKeyByIndexReference kiRef = (BasicKeyByIndexReference)ObjectUtils.tryCast((Object)ref, BasicKeyByIndexReference.class);
        if (kiRef != null && (indexRefInfo = GeneratedModelUtil.joinWithIndex(info.tryCast(BasicKey.class), kiRef.indexRef)) != null) {
            return GeneratedModelUtil.getColNames(indexRefInfo, null);
        }
        BasicByColumnNamesReference byOrNamesRef = GeneratedModelUtil.getByColumnNamesReference(ref);
        if (byOrNamesRef != null) {
            List<String> list = byOrNamesRef.getColNames();
            if (list == null) {
                GeneratedModelUtil.$$$reportNull$$$0(17);
            }
            return list;
        }
        BasicByColumnPositionsReference byPositionsRef = GeneratedModelUtil.getByColumnPositionsReference(ref);
        if (byPositionsRef != null && targetTable != null && (res = byPositionsRef.getColNames(targetTable)) != null) {
            List<String> list = res;
            if (list == null) {
                GeneratedModelUtil.$$$reportNull$$$0(18);
            }
            return list;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            GeneratedModelUtil.$$$reportNull$$$0(19);
        }
        return list;
    }

    @Nullable
    private static BasicReferenceInfo<BasicIndex> joinWithIndex(@Nullable BasicReferenceInfo<BasicKey> info, @NotNull BasicReference ref) {
        BasicMetaObject<BasicKey> target;
        if (ref == null) {
            GeneratedModelUtil.$$$reportNull$$$0(20);
        }
        if (info == null) {
            return null;
        }
        BasicMetaObject<BasicKey> anyTgt = null;
        BasicMetaObject<? extends T>[] basicMetaObjectArray = info.getReferenceDesc().targets;
        int n = basicMetaObjectArray.length;
        for (int j = 0; j < n && (anyTgt = (target = basicMetaObjectArray[j]).tryCast(BasicKey.class)) == null; ++j) {
        }
        BasicMetaReference idxMetaRef = anyTgt == null ? null : anyTgt.getReference(BasicModKey.UNDERLYING_INDEX_REF);
        return idxMetaRef == null ? null : info.dummyJoin(idxMetaRef.getReferenceDesc(), ref);
    }

    public static BasicReference getRefKeyByColNames(BasicForeignKey fk) {
        return BasicByColumnNamesReference.create(fk.getRefColNames());
    }

    public static BasicReference getRefKeyRef(BasicForeignKey fk) {
        return GeneratedModelUtil.getRefKeyByColNames(fk);
    }

    public static void setRefKeyRef(BasicModForeignKey fk, BasicReference ref) {
    }

    public static BasicReference getUnderlyingIndexRef(BasicKey key) {
        List colNames = key.getColNames();
        return colNames.isEmpty() ? null : BasicByColumnNamesReference.create(colNames);
    }

    public static void setUnderlyingIndexRef(BasicKey key, BasicReference ref) {
    }

    public static void setRefColNamesByKey(BasicModForeignKey fk, @NotNull List<String> refColNames) {
        if (refColNames == null) {
            GeneratedModelUtil.$$$reportNull$$$0(21);
        }
        if (refColNames.equals(fk.getRefColNames())) {
            return;
        }
        fk.setRefKeyRef(BasicByColumnNamesReference.create(refColNames));
    }

    public static void setColNamesByUnderlyingIndex(BasicModKey key, @NotNull List<String> colNames) {
        if (colNames == null) {
            GeneratedModelUtil.$$$reportNull$$$0(22);
        }
        if (colNames.equals(key.getColNames())) {
            return;
        }
        key.setUnderlyingIndexRef(BasicByColumnNamesReference.create(colNames));
    }

    public static boolean isComputed(BasicTableOrViewColumn column) {
        return false;
    }

    public static void setComputed(BasicModTableOrViewColumn column, boolean computed) {
    }

    public static CascadeRule getOnUpdate(BasicForeignKey key) {
        return CascadeRule.no_action;
    }

    public static CascadeRule getOnDelete(BasicForeignKey key) {
        return CascadeRule.no_action;
    }

    public static void setOnUpdate(BasicModForeignKey key, CascadeRule update) {
    }

    public static void setOnDelete(BasicModForeignKey key, CascadeRule delete) {
    }

    public static boolean isUnique(BasicModIndex index) {
        return false;
    }

    public static void setUnique(BasicModIndex index, boolean unique) {
    }

    public static DasRoutine.Kind getRoutineKind(BasicRoutine aggregate) {
        return DasRoutine.Kind.NONE;
    }

    public static void setRoutineKind(BasicModRoutine aggregate, DasRoutine.Kind kind) {
    }

    public static boolean isDeterministic(BasicRoutine function) {
        return false;
    }

    public static void setDeterministic(BasicModRoutine function, boolean deterministic) {
    }

    public static boolean isDeferrable(BasicConstraint c2) {
        return false;
    }

    public static void setDeferrable(BasicModConstraint c2, boolean deferrable) {
    }

    public static boolean isAutoInc(BasicTableColumn column) {
        return column.getSequenceIdentity() != null;
    }

    public static void setAutoInc(BasicModTableColumn column, boolean inc) {
        column.setSequenceIdentity(inc ? SequenceIdentity.UNKNOWN : null);
    }

    public static Set<String> getReverseColNames(BasicIndex index) {
        return Collections.emptySet();
    }

    public static void setReverseColNames(BasicIndex index, Set<String> names) {
    }

    public static BigInteger getStartValue(BasicSequence sequence) {
        return null;
    }

    public static void setStartValue(BasicModSequence sequence, BigInteger startValue) {
    }

    public static SequenceIdentity getSequenceIdentity(BasicModTableColumn column) {
        return null;
    }

    public static void setSequenceIdentity(BasicModTableColumn column, SequenceIdentity identity) {
    }

    public static boolean isInitiallyDeferred(BasicModConstraint c2) {
        return false;
    }

    public static void setInitiallyDeferred(BasicModConstraint c2, boolean deferred) {
    }

    public static boolean isInvalid(BasicSourceAware sa) {
        return false;
    }

    public static void setInvalid(BasicModSourceAware sa, boolean invalid) {
    }

    public static boolean isObfuscated(BasicSourceAware sa) {
        return false;
    }

    public static void setObfuscated(BasicModSourceAware sa, boolean obfuscated) {
    }

    public static List<SourceError> getErrors(BasicSourceAware sa) {
        return Collections.emptyList();
    }

    public static void setErrors(BasicModSourceAware sa, List<SourceError> errors) {
    }

    public static boolean isWithDebugInfo(BasicSourceAware sa) {
        return false;
    }

    public static void setWithDebugInfo(BasicModSourceAware sa, boolean withDebugInfo) {
    }

    @Nullable
    public static String getComment(@NotNull BasicModNamedElement e) {
        if (e == null) {
            GeneratedModelUtil.$$$reportNull$$$0(23);
        }
        return null;
    }

    public static void setComment(@NotNull BasicModNamedElement e, @Nullable String comment) {
        if (e == null) {
            GeneratedModelUtil.$$$reportNull$$$0(24);
        }
    }

    @NotNull
    public static List<String> getColNames(BasicColumniation columniation) {
        List<String> list = Collections.emptyList();
        if (list == null) {
            GeneratedModelUtil.$$$reportNull$$$0(25);
        }
        return list;
    }

    public static void setColNames(BasicModColumniation columniation, @NotNull List<String> names) {
        if (names == null) {
            GeneratedModelUtil.$$$reportNull$$$0(26);
        }
    }

    public static boolean isDisabled(BasicToggleable toggleable) {
        return false;
    }

    public static void setDisabled(BasicModToggleable toggleable, boolean disabled) {
    }

    public static boolean isNotNull(BasicTypedElement typed) {
        return false;
    }

    public static void setNotNull(BasicModTypedElement typed, boolean notNull) {
    }

    @Nullable
    public static String getCondition(BasicIndex index) {
        return null;
    }

    public static void setCondition(BasicModIndex index, @Nullable String condition) {
    }

    @Nullable
    public static String getCondition(BasicTrigger index) {
        return null;
    }

    public static void setCondition(BasicModTrigger index, @Nullable String condition) {
    }

    @Nullable
    public static String getDefaultExpression(BasicTypedElement typed) {
        return null;
    }

    public static void setDefaultExpression(BasicModTypedElement typed, @Nullable String def) {
    }

    public static boolean isClustering(BasicIndex index) {
        return false;
    }

    public static void setClustering(BasicModIndex index, boolean clustering) {
    }

    public static boolean isTemporary(BasicTableOrView table) {
        return false;
    }

    public static void setTemporary(BasicModTableOrView table, boolean temp) {
    }

    public static boolean isSystem(BasicTableOrView table) {
        return false;
    }

    public static void setSystem(BasicModTableOrView table, boolean sys) {
    }

    public static boolean isFunctionBased(BasicIndex index) {
        return false;
    }

    public static void setFunctionBased(BasicModIndex index, boolean functionBased) {
    }

    public static void setSubstituted(@NotNull BasicModNamespace nsp) {
        if (nsp == null) {
            GeneratedModelUtil.$$$reportNull$$$0(27);
        }
    }

    public static void setSubstituted(@NotNull BasicModSchema nsp) {
        if (nsp == null) {
            GeneratedModelUtil.$$$reportNull$$$0(28);
        }
        nsp.getModel().setSchemaSourcesVersion(nsp, null);
    }

    public static boolean isCurrent(@NotNull BasicMateNamespace nsp) {
        if (nsp == null) {
            GeneratedModelUtil.$$$reportNull$$$0(29);
        }
        return false;
    }

    public static void setCurrent(@NotNull BasicModMateNamespace nsp, boolean current) {
        if (nsp == null) {
            GeneratedModelUtil.$$$reportNull$$$0(30);
        }
    }

    public static boolean isAllowConnections(@NotNull BasicDatabase db) {
        if (db == null) {
            GeneratedModelUtil.$$$reportNull$$$0(31);
        }
        return true;
    }

    public static void setAllowConnections(@NotNull BasicModDatabase db, boolean allowConnections) {
        if (db == null) {
            GeneratedModelUtil.$$$reportNull$$$0(32);
        }
    }

    public static boolean isElementSurrogate(@NotNull BasicElement element) {
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(33);
        }
        return false;
    }

    public static int compareSignatures(@NotNull BasicRoutine e1, @NotNull BasicRoutine e2) {
        if (e1 == null) {
            GeneratedModelUtil.$$$reportNull$$$0(34);
        }
        if (e2 == null) {
            GeneratedModelUtil.$$$reportNull$$$0(35);
        }
        Iterable args1 = e1.getArguments();
        Iterable args2 = e2.getArguments();
        Iterator it1 = args1.iterator();
        Iterator it2 = args2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            BasicArgument c1 = (BasicArgument)it1.next();
            BasicArgument c2 = (BasicArgument)it2.next();
            int r = Comparing.compare((Comparable)((Object)DasTypeUtilsKt.getTypeName(c1.getDasType())), (Comparable)((Object)DasTypeUtilsKt.getTypeName(c2.getDasType())));
            if (r == 0) continue;
            return r;
        }
        return -Integer.compare(args1.size(), args2.size());
    }

    public static int getDisplayOrder(@NotNull BasicElement e1, @NotNull BasicElement e2) {
        if (e1 == null) {
            GeneratedModelUtil.$$$reportNull$$$0(36);
        }
        if (e2 == null) {
            GeneratedModelUtil.$$$reportNull$$$0(37);
        }
        String n1 = e1.getName();
        String n2 = e2.getName();
        if (n1.isEmpty() || n2.isEmpty()) {
            return -Integer.compare(n1.length(), n2.length());
        }
        return Comparing.compare((Comparable)((Object)n1), (Comparable)((Object)n2));
    }

    public static int getDisplayOrder(@NotNull BasicArrangedElement e1, @NotNull BasicArrangedElement e2) {
        if (e1 == null) {
            GeneratedModelUtil.$$$reportNull$$$0(38);
        }
        if (e2 == null) {
            GeneratedModelUtil.$$$reportNull$$$0(39);
        }
        short p1 = e1.getPosition();
        short p2 = e2.getPosition();
        return Integer.compare(p1, p2);
    }

    public static int getDisplayOrder(@NotNull BasicCheck e1, @NotNull BasicCheck e2) {
        String p2;
        String p1;
        int res;
        if (e1 == null) {
            GeneratedModelUtil.$$$reportNull$$$0(40);
        }
        if (e2 == null) {
            GeneratedModelUtil.$$$reportNull$$$0(41);
        }
        return (res = Comparing.compare((Comparable)((Object)(p1 = e1.getPredicate())), (Comparable)((Object)(p2 = e2.getPredicate())))) == 0 ? GeneratedModelUtil.getDisplayOrder((BasicColumniation)e1, (BasicColumniation)e2) : res;
    }

    public static int getDisplayOrder(@NotNull BasicIndex e1, @NotNull BasicIndex e2) {
        boolean u2;
        boolean u1;
        int res;
        if (e1 == null) {
            GeneratedModelUtil.$$$reportNull$$$0(42);
        }
        if (e2 == null) {
            GeneratedModelUtil.$$$reportNull$$$0(43);
        }
        return (res = -Boolean.compare(u1 = e1.isUnique(), u2 = e2.isUnique())) == 0 ? GeneratedModelUtil.getDisplayOrder((BasicColumniation)e1, (BasicColumniation)e2) : res;
    }

    public static int getDisplayOrder(@NotNull BasicKey e1, @NotNull BasicKey e2) {
        boolean p2;
        boolean p1;
        int res;
        if (e1 == null) {
            GeneratedModelUtil.$$$reportNull$$$0(44);
        }
        if (e2 == null) {
            GeneratedModelUtil.$$$reportNull$$$0(45);
        }
        return (res = -Boolean.compare(p1 = e1.isPrimary(), p2 = e2.isPrimary())) == 0 ? GeneratedModelUtil.getDisplayOrder((BasicColumniation)e1, (BasicColumniation)e2) : res;
    }

    public static int getDisplayOrder(@NotNull BasicColumniation e1, @NotNull BasicColumniation e2) {
        int res;
        if (e1 == null) {
            GeneratedModelUtil.$$$reportNull$$$0(46);
        }
        if (e2 == null) {
            GeneratedModelUtil.$$$reportNull$$$0(47);
        }
        List cols1 = e1.getCols();
        List cols2 = e2.getCols();
        int e = Math.min(cols1.size(), cols2.size());
        for (int i2 = 0; i2 < e; ++i2) {
            BasicLikeColumn c1 = (BasicLikeColumn)cols1.get(i2);
            BasicLikeColumn c2 = (BasicLikeColumn)cols2.get(i2);
            int n = c1 == null || c2 == null ? Boolean.compare(c1 == null, c2 == null) : (res = c1.getDisplayOrder(c2));
            if (res == 0) continue;
            return res;
        }
        res = -Integer.compare(cols1.size(), cols2.size());
        return res == 0 ? GeneratedModelUtil.getDisplayOrder((BasicNamedElement)((Object)e1), (BasicElement)e2) : res;
    }

    public static int getDisplayOrder(@NotNull BasicOverloadable e1, @NotNull BasicOverloadable e2) {
        if (e1 == null) {
            GeneratedModelUtil.$$$reportNull$$$0(48);
        }
        if (e2 == null) {
            GeneratedModelUtil.$$$reportNull$$$0(49);
        }
        String id1 = e1.identity();
        String id2 = e2.identity();
        return Comparing.compare((Comparable)((Object)id1), (Comparable)((Object)id2));
    }

    public static int getDisplayOrder(@NotNull BasicTrigger e1, @NotNull BasicTrigger e2) {
        TrigTurn t2;
        int res;
        if (e1 == null) {
            GeneratedModelUtil.$$$reportNull$$$0(50);
        }
        if (e2 == null) {
            GeneratedModelUtil.$$$reportNull$$$0(51);
        }
        Set<TrigEvent> ev1 = e1.getEvents();
        Set<TrigEvent> ev2 = e2.getEvents();
        for (TrigEvent value : TrigEvent.values()) {
            res = -Boolean.compare(ev1.contains(value), ev2.contains(value));
            if (res == 0) continue;
            return res;
        }
        TrigTurn t1 = e1.getTurn();
        res = Comparing.compare((Comparable)t1, (Comparable)(t2 = e2.getTurn()));
        if (res != 0) {
            return res;
        }
        return GeneratedModelUtil.getDisplayOrder((BasicElement)e1, (BasicElement)e2);
    }

    @NotNull
    public static String identity(@NotNull BasicElement element, boolean includingSurrogate, boolean forPath, boolean normalize) {
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(52);
        }
        if (element instanceof BasicNamedElement) {
            String name;
            BasicNamedElement e = (BasicNamedElement)element;
            String string = name = includingSurrogate ? e.getRealName() : e.getNaturalName();
            if (name != null) {
                String string2 = forPath ? "" : name;
                if (string2 == null) {
                    GeneratedModelUtil.$$$reportNull$$$0(53);
                }
                return string2;
            }
        }
        String string = "#" + Integer.toString(GeneratedModelUtil.getPositionInFamily(element));
        if (string == null) {
            GeneratedModelUtil.$$$reportNull$$$0(54);
        }
        return string;
    }

    @NotNull
    public static String identity(@NotNull BasicOverloadable element, boolean includingSurrogate, boolean forPath, boolean normalize) {
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(55);
        }
        if (forPath) {
            if (element instanceof DasOperator) {
                DasTypeSystem normalizer = ModelUtil.getNormalizer(DbImplUtilCore.getDbms(element), normalize);
                String string = ModelUtil.calculateRoutineIdentityByType("", ((DasOperator)element).getArgumentTypes(), normalizer);
                if (string == null) {
                    GeneratedModelUtil.$$$reportNull$$$0(56);
                }
                return string;
            }
            if (element instanceof DasRoutine) {
                DasTypeSystem normalizer = ModelUtil.getNormalizer(DbImplUtilCore.getDbms(element), normalize);
                String string = ModelUtil.calculateRoutineIdentity("", ((DasRoutine)element).getArguments(), normalizer);
                if (string == null) {
                    GeneratedModelUtil.$$$reportNull$$$0(57);
                }
                return string;
            }
            return "";
        }
        String string = ModelUtil.calculateOverloadableIdentity(element, includingSurrogate, false);
        if (string == null) {
            GeneratedModelUtil.$$$reportNull$$$0(58);
        }
        return string;
    }

    @NotNull
    public static String identity(@NotNull BasicRoot element, boolean includingSurrogate, boolean forPath, boolean normalize) {
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(59);
        }
        return forPath ? "" : "#ROOT";
    }

    @NotNull
    public static String getDisplayName(@NotNull BasicElement element) {
        String name;
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(60);
        }
        Object object = DasUtil.isNoName((String)(name = element.getName())) ? element.getKind().code() + " " + element.identity() : name;
        if (object == null) {
            GeneratedModelUtil.$$$reportNull$$$0(61);
        }
        return object;
    }

    @NotNull
    public static String getDisplayName(@NotNull BasicNode node) {
        if (node == null) {
            GeneratedModelUtil.$$$reportNull$$$0(62);
        }
        String string = node.getClass().getSimpleName();
        if (string == null) {
            GeneratedModelUtil.$$$reportNull$$$0(63);
        }
        return string;
    }

    public static JBIterable<@NotNull ? extends BasicModElement> getDasChildren(@NotNull BasicModElement element, @Nullable ObjectKind kind) {
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(64);
        }
        return kind == null || kind == ObjectKind.NONE ? element.getChildren() : JBIterable.from((Iterable)element.familyOf(kind));
    }

    @NotNull
    public static @NotNull JBIterable<@NotNull ? extends BasicModElement> getDasChildren(@NotNull BasicModNamespace element, @Nullable ObjectKind kind) {
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(65);
        }
        JBIterable<? extends BasicModElement> jBIterable = GeneratedModelUtil.getDasChildren((BasicModElement)element, kind);
        if (jBIterable == null) {
            GeneratedModelUtil.$$$reportNull$$$0(66);
        }
        return jBIterable;
    }

    @Nullable
    public static String getRealName(@NotNull BasicElement element) {
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(67);
        }
        return null;
    }

    @Nullable
    public static String getRealName(@NotNull BasicNamedElement element) {
        String name;
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(68);
        }
        return (name = element.getName()).isEmpty() ? null : name;
    }

    @Nullable
    public static String getNaturalName(@NotNull BasicElement element) {
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(69);
        }
        return null;
    }

    @Nullable
    public static String getNaturalName(@NotNull BasicNamedElement element) {
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(70);
        }
        return element.isNameSurrogate() ? null : element.getRealName();
    }

    public static boolean getAutoCreated(@NotNull BasicElement element) {
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(71);
        }
        return element.isElementSurrogate();
    }

    private static int getPositionInFamily(@NotNull BasicElement element) {
        Family<? extends BasicElement> f;
        if (element == null) {
            GeneratedModelUtil.$$$reportNull$$$0(72);
        }
        if ((f = element.getParentFamily()) != null) {
            int index = f.indexOf(element);
            return index >= 0 ? index + 1 : Integer.MAX_VALUE;
        }
        return 0;
    }

    public static BasicRefImporter refImporter() {
        return BasicRefImporter.INSTANCE;
    }

    public static Level getExplicitIntrospectionLevel(BasicIntrospectableArea area) {
        return null;
    }

    @Nullable
    public static BasicByColumnPositionsReference getByColumnPositionsReference(@Nullable BasicReference ref) {
        if (ref instanceof BasicByColumnPositionsReference) {
            return (BasicByColumnPositionsReference)ref;
        }
        if (ref instanceof BasicByColumnPositionsOrNamesReference) {
            return ((BasicByColumnPositionsOrNamesReference)ref).byPositions;
        }
        return null;
    }

    @Nullable
    public static BasicIdReference getIdReference(@Nullable BasicReference ref) {
        if (ref instanceof BasicIdReference) {
            return (BasicIdReference)ref;
        }
        if (ref instanceof BasicIdOrNameReference) {
            return ((BasicIdOrNameReference)ref).byId;
        }
        return null;
    }

    @Nullable
    public static BasicByColumnNamesReference getByColumnNamesReference(@Nullable BasicReference ref) {
        if (ref instanceof BasicByColumnNamesReference) {
            return (BasicByColumnNamesReference)ref;
        }
        if (ref instanceof BasicByColumnPositionsOrNamesReference) {
            return ((BasicByColumnPositionsOrNamesReference)ref).byNames;
        }
        return null;
    }

    @SafeVarargs
    public static <S extends BasicElement, T extends BasicElement> void bind(BasicMetaReference<S, T> ref, boolean backRef, BasicMetaObject<?> scope, BasicMetaObject<? extends T> ... targets) {
        ref.bind(new BasicMetaReferenceDesc(((BasicMetaReferenceId)ref.getId()).getTargetClass(), scope, targets, backRef));
    }

    @SafeVarargs
    public static <S extends BasicElement, T extends BasicElement> void bind(BasicMetaReference<S, T> ref, boolean backRef, BasicMetaReference<S, ?> baseRef, BasicMetaObject<? extends T> ... targets) {
        ref.bind(new BasicMetaReferenceDesc<S, T>(((BasicMetaReferenceId)ref.getId()).getTargetClass(), baseRef, targets, backRef));
    }

    public static <S extends BasicElement, T extends BasicElement> void bind(BasicMetaReference<S, T> ref, boolean backRef, Class<? extends BasicElement> scopeClass) {
        ref.bind(new RawMetaReferenceDesc(((BasicMetaReferenceId)ref.getId()).getTargetClass(), RawMetaReferenceDesc.RawMetaObject.rawMeta(scopeClass), (RawMetaReferenceDesc.RawMetaObject[])ContainerUtil.ar((Object[])new RawMetaReferenceDesc.RawMetaObject[]{RawMetaReferenceDesc.RawMetaObject.rawMeta(((BasicMetaReferenceId)ref.getId()).getTargetClass())}), backRef));
    }

    @SafeVarargs
    public static <S extends BasicElement, T extends BasicElement> void bind(BasicMetaReferenceList<S, T> ref, boolean backRef, BasicMetaObject<?> scope, BasicMetaObject<? extends T> ... targets) {
        ref.bind(new BasicMetaReferenceDesc(((BasicMetaReferenceListId)ref.getId()).getTargetClass(), scope, targets, backRef));
    }

    public static boolean eq(@Nullable Object value1, @Nullable Object value2) {
        if (value1 == value2) {
            return true;
        }
        if (value1 == null || value2 == null) {
            return false;
        }
        return value1.equals(value2);
    }

    public static boolean eq(@Nullable String value1, @Nullable String value2) {
        return GeneratedModelUtil.eq((Object)StringUtil.nullize((String)value1), (Object)StringUtil.nullize((String)value2));
    }

    public static <B extends ImmutableCollection.Builder<T>, T> B deduplicateStrings(@NotNull Collection<T> v, B builder) {
        if (v == null) {
            GeneratedModelUtil.$$$reportNull$$$0(73);
        }
        for (T t : v) {
            builder.add(GeneratedModelUtil.deduplicateIfString(t));
        }
        return builder;
    }

    public static <B extends ImmutableMap.Builder<K, V>, K, V> B deduplicateStrings(@NotNull Map<K, V> v, B builder) {
        if (v == null) {
            GeneratedModelUtil.$$$reportNull$$$0(74);
        }
        for (Map.Entry<K, V> t : v.entrySet()) {
            builder.put(GeneratedModelUtil.deduplicateIfString(t.getKey()), GeneratedModelUtil.deduplicateIfString(t.getValue()));
        }
        return builder;
    }

    public static <T> T deduplicateIfString(T t) {
        return (T)(t instanceof String ? DbUtil.intern((String)((String)t)) : t);
    }

    @NotNull
    public static <T> List<T> immutable(@Nullable List<T> v) {
        if (v == null || v.isEmpty()) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                GeneratedModelUtil.$$$reportNull$$$0(75);
            }
            return immutableList;
        }
        if (v instanceof ImmutableList || !(v.get(0) instanceof String)) {
            ImmutableList immutableList = ImmutableList.copyOf(v);
            if (immutableList == null) {
                GeneratedModelUtil.$$$reportNull$$$0(76);
            }
            return immutableList;
        }
        ImmutableList immutableList = GeneratedModelUtil.deduplicateStrings(v, ImmutableList.builderWithExpectedSize((int)v.size())).build();
        if (immutableList == null) {
            GeneratedModelUtil.$$$reportNull$$$0(77);
        }
        return immutableList;
    }

    @NotNull
    public static <T> Set<T> immutable(@Nullable Set<T> v) {
        if (v == null || v.isEmpty()) {
            ImmutableSet immutableSet = ImmutableSet.of();
            if (immutableSet == null) {
                GeneratedModelUtil.$$$reportNull$$$0(78);
            }
            return immutableSet;
        }
        if (v instanceof ImmutableSet || !(v.iterator().next() instanceof String)) {
            ImmutableSet immutableSet = ImmutableSet.copyOf(v);
            if (immutableSet == null) {
                GeneratedModelUtil.$$$reportNull$$$0(79);
            }
            return immutableSet;
        }
        ImmutableSet immutableSet = GeneratedModelUtil.deduplicateStrings(v, ImmutableSet.builderWithExpectedSize((int)v.size())).build();
        if (immutableSet == null) {
            GeneratedModelUtil.$$$reportNull$$$0(80);
        }
        return immutableSet;
    }

    @NotNull
    public static <K, V> Map<K, V> immutable(@Nullable Map<K, V> v) {
        if (v == null || v.isEmpty()) {
            ImmutableMap immutableMap = ImmutableMap.of();
            if (immutableMap == null) {
                GeneratedModelUtil.$$$reportNull$$$0(81);
            }
            return immutableMap;
        }
        if (v instanceof ImmutableMap || !(v.keySet().iterator().next() instanceof String) && !(v.values().iterator().next() instanceof String)) {
            ImmutableMap immutableMap = ImmutableMap.copyOf(v);
            if (immutableMap == null) {
                GeneratedModelUtil.$$$reportNull$$$0(82);
            }
            return immutableMap;
        }
        ImmutableMap immutableMap = GeneratedModelUtil.deduplicateStrings(v, ImmutableMap.builderWithExpectedSize((int)v.size())).build();
        if (immutableMap == null) {
            GeneratedModelUtil.$$$reportNull$$$0(83);
        }
        return immutableMap;
    }

    @NotNull
    public static String deduplicate(@NotNull String str) {
        if (str == null) {
            GeneratedModelUtil.$$$reportNull$$$0(84);
        }
        String string = str.isEmpty() ? ModelConsts.NO_NAME : DbUtil.intern2((String)str);
        if (string == null) {
            GeneratedModelUtil.$$$reportNull$$$0(85);
        }
        return string;
    }

    public static String deduplicateNullable(@Nullable String str) {
        return StringUtil.isEmpty((String)str) ? null : DbUtil.intern2((String)str);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 9, 11, 14, 15, 16, 17, 18, 19, 25, 53, 54, 56, 57, 58, 61, 63, 66, 75, 76, 77, 78, 79, 80, 81, 82, 83, 85 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 25: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 61: 
            case 63: 
            case 66: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/basic/GeneratedModelUtil";
                break;
            }
            case 12: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refColNames";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colNames";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nsp";
                break;
            }
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "db";
                break;
            }
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e1";
                break;
            }
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e2";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 73: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/basic/GeneratedModelUtil";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredecessors";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getColNames";
                break;
            }
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "identity";
                break;
            }
            case 61: 
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasChildren";
                break;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "immutable";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "deduplicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setSourceText";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSourceText";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setSourceTextLength";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSourceTextLength";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPredecessors";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 25: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 61: 
            case 63: 
            case 66: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 85: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "handleRename";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "joinWithIndex";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setRefColNamesByKey";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setColNamesByUnderlyingIndex";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getComment";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setComment";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setColNames";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setSubstituted";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isCurrent";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "setCurrent";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isAllowConnections";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setAllowConnections";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isElementSurrogate";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "compareSignatures";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayOrder";
                break;
            }
            case 52: 
            case 55: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "identity";
                break;
            }
            case 60: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayName";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getDasChildren";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getRealName";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getNaturalName";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getAutoCreated";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getPositionInFamily";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "deduplicateStrings";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "deduplicate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7, 9, 11, 14, 15, 16, 17, 18, 19, 25, 53, 54, 56, 57, 58, 61, 63, 66, 75, 76, 77, 78, 79, 80, 81, 82, 83, 85 -> new IllegalStateException(string);
        };
    }
}

