/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.run;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.ui.VmOptionsEditor;
import com.intellij.micronaut.config.MnConfigUtilsKt;
import com.intellij.micronaut.config.MnMetaConfigKeyManager;
import com.intellij.micronaut.config.MnParametrizedConfigKeyPrefixMatcher;
import com.intellij.micronaut.config.hints.MnHintReferencesProvider;
import com.intellij.micronaut.run.MnRunConfiguration;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.MetaConfigKeyReference;
import com.intellij.microservices.jvm.config.properties.ApplicationPropertiesAutoCompletionListProvider;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u001a"}, d2={"Lcom/intellij/micronaut/run/MnVmOptionsCompletionContributor;", "Lcom/intellij/codeInsight/completion/CompletionContributor;", "<init>", "()V", "fillCompletionVariants", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "fillConfigKeyPathCompletionVariants", "", "optionText", "", "module", "Lcom/intellij/openapi/module/Module;", "getOptionText", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "", "getCompletionVariants", "", "", "key", "Lcom/intellij/microservices/jvm/config/MetaConfigKey;", "intellij.micronaut"})
@SourceDebugExtension(value={"SMAP\nMnVmOptionsCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MnVmOptionsCompletionContributor.kt\ncom/intellij/micronaut/run/MnVmOptionsCompletionContributor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,103:1\n3919#2:104\n4434#2,2:105\n*S KotlinDebug\n*F\n+ 1 MnVmOptionsCompletionContributor.kt\ncom/intellij/micronaut/run/MnVmOptionsCompletionContributor\n*L\n101#1:104\n101#1:105,2\n*E\n"})
public final class MnVmOptionsCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Document document = parameters.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        Object object = document2.getUserData(VmOptionsEditor.SETTINGS_KEY);
        MnRunConfiguration mnRunConfiguration = object instanceof MnRunConfiguration ? (MnRunConfiguration)((Object)object) : null;
        if (mnRunConfiguration == null) {
            return;
        }
        MnRunConfiguration configuration = mnRunConfiguration;
        Module module = ((JavaRunConfigurationModule)configuration.getConfigurationModule()).getModule();
        if (module == null) {
            return;
        }
        Module module2 = module;
        String string = this.getOptionText(document2, parameters.getOffset());
        if (string == null) {
            return;
        }
        String optionText = string;
        int separatorIndex = StringsKt.indexOf$default((CharSequence)optionText, (char)'=', (int)0, (boolean)false, (int)6, null);
        if (separatorIndex < 0) {
            if (this.fillConfigKeyPathCompletionVariants(result, optionText, module2)) {
                return;
            }
            PrefixMatcher prefixMatcher = result.getPrefixMatcher();
            Intrinsics.checkNotNullExpressionValue((Object)prefixMatcher, (String)"getPrefixMatcher(...)");
            CompletionResultSet completionResultSet = result.withPrefixMatcher((PrefixMatcher)new MnParametrizedConfigKeyPrefixMatcher(prefixMatcher));
            Intrinsics.checkNotNullExpressionValue((Object)completionResultSet, (String)"withPrefixMatcher(...)");
            CompletionResultSet resultWithMatcher = completionResultSet;
            resultWithMatcher.runRemainingContributors(parameters, true);
            return;
        }
        String string2 = optionText.substring(0, separatorIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String keyText = string2;
        MetaConfigKey metaConfigKey = MnMetaConfigKeyManager.Companion.getInstance().findApplicationMetaConfigKey(module2, keyText);
        if (metaConfigKey == null) {
            return;
        }
        MetaConfigKey key = metaConfigKey;
        List<Object> variants = this.getCompletionVariants(key, module2);
        new ApplicationPropertiesAutoCompletionListProvider((Collection)variants).fillCompletionVariants(parameters, "", result);
    }

    private final boolean fillConfigKeyPathCompletionVariants(CompletionResultSet result, String optionText, Module module) {
        if (!StringsKt.contains$default((CharSequence)optionText, (char)'.', (boolean)false, (int)2, null)) {
            return false;
        }
        Object keyText = StringsKt.endsWith$default((String)optionText, (String)".", (boolean)false, (int)2, null) ? optionText + "a" : optionText;
        PsiElement keyNode = ApplicationPropertiesAutoCompletionListProvider.Companion.createFakeKeyNode(module, "application.properties", (String)keyText);
        keyNode.getContainingFile().putUserData(MnConfigUtilsKt.getCONFIGURATION_FILE_MARKER_KEY(), (Object)true);
        TextRange textRange = TextRange.create((int)(StringsKt.lastIndexOf$default((CharSequence)((CharSequence)keyText), (char)'.', (int)0, (boolean)false, (int)6, null) + 1), (int)((String)keyText).length());
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(...)");
        TextRange range = textRange;
        boolean filled = false;
        PsiReference[] psiReferenceArray = keyNode.getReferences();
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
        for (PsiReference reference : psiReferenceArray) {
            Object[] variants;
            if (reference instanceof MetaConfigKeyReference || !range.contains(reference.getRangeInElement())) continue;
            Intrinsics.checkNotNullExpressionValue((Object)reference.getVariants(), (String)"getVariants(...)");
            for (Object variant : variants) {
                if (!(variant instanceof LookupElement)) continue;
                result.addElement((LookupElement)variant);
                filled = true;
            }
        }
        return filled;
    }

    private final String getOptionText(Document document, int offset) {
        int optionStart;
        String string = document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String text = string;
        for (optionStart = offset; optionStart > 0 && !Character.isWhitespace(text.charAt(optionStart - 1)); --optionStart) {
        }
        String string2 = text.substring(optionStart, offset);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String optionText = string2;
        if (!StringsKt.startsWith$default((String)optionText, (String)"-D", (boolean)false, (int)2, null)) {
            return null;
        }
        String string3 = optionText.substring(2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        return string3;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Object> getCompletionVariants(MetaConfigKey key, Module module) {
        void $this$filterTo$iv$iv;
        PsiElement dummyValueNode = ApplicationPropertiesAutoCompletionListProvider.Companion.createFakeValueNode(module, "application.properties");
        List valueTextRanges = CollectionsKt.listOf((Object)ElementManipulators.getValueTextRange((PsiElement)dummyValueNode));
        Object[] references = MnHintReferencesProvider.Companion.getInstance().getValueReferences(key, null, dummyValueNode, valueTextRanges, new ProcessingContext());
        PsiReference psiReference = (PsiReference)ArraysKt.firstOrNull((Object[])references);
        if (psiReference == null) {
            return CollectionsKt.emptyList();
        }
        PsiReference reference = psiReference;
        if (reference instanceof JavaClassReference) {
            List list = ((JavaClassReference)reference).getSuperClasses();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSuperClasses(...)");
            List names = list;
            PsiElement context = ((JavaClassReference)reference).getCompletionContext();
            if (!names.isEmpty() && context instanceof PsiPackage) {
                ArrayList variants = new ArrayList();
                ((JavaClassReference)reference).processSubclassVariants((PsiPackage)context, ArrayUtilRt.toStringArray((Collection)names), arg_0 -> MnVmOptionsCompletionContributor.getCompletionVariants$lambda$0(variants, arg_0));
                return variants;
            }
        }
        Object[] objectArray = reference.getVariants();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getVariants(...)");
        Object[] $this$filter$iv = objectArray;
        boolean $i$f$filter = false;
        Object[] variants = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!(!(it instanceof PsiNamedElement) || ((PsiNamedElement)it).getName() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final void getCompletionVariants$lambda$0(ArrayList $variants, LookupElement it) {
        $variants.add(it);
    }
}

