/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.provider.mq;

import com.intellij.micronaut.provider.mq.MnMqUtilsKt;
import com.intellij.micronaut.provider.mq.MnRabbitModel;
import com.intellij.microservices.jvm.mq.MQResolver;
import com.intellij.microservices.jvm.mq.MQResolverFactory;
import com.intellij.microservices.jvm.mq.MQTargetInfo;
import com.intellij.microservices.jvm.mq.MQType;
import com.intellij.microservices.jvm.mq.MQTypes;
import com.intellij.microservices.jvm.mq.NamedMQType;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/micronaut/provider/mq/MnRabbitResolverFactory;", "Lcom/intellij/microservices/jvm/mq/MQResolverFactory;", "<init>", "()V", "forProject", "", "Lcom/intellij/microservices/jvm/mq/MQResolver;", "project", "Lcom/intellij/openapi/project/Project;", "MnRabbitResolver", "intellij.micronaut"})
public final class MnRabbitResolverFactory
implements MQResolverFactory {
    @NotNull
    public List<MQResolver> forProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!MnMqUtilsKt.hasMnRabbitInProject(project)) {
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.listOf((Object)new MnRabbitResolver(project));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lcom/intellij/micronaut/provider/mq/MnRabbitResolverFactory$MnRabbitResolver;", "Lcom/intellij/microservices/jvm/mq/MQResolver;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "supportedTypes", "", "Lcom/intellij/microservices/jvm/mq/MQType;", "getSupportedTypes", "()Ljava/util/List;", "getVariants", "", "Lcom/intellij/microservices/jvm/mq/MQTargetInfo;", "typeHint", "intellij.micronaut"})
    private static final class MnRabbitResolver
    implements MQResolver {
        @NotNull
        private final Project project;
        @NotNull
        private final List<MQType> supportedTypes;

        public MnRabbitResolver(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
            Object[] objectArray = new NamedMQType[]{MQTypes.RABBIT_MQ_EXCHANGE_TYPE, MQTypes.RABBIT_MQ_QUEUE_TYPE};
            this.supportedTypes = CollectionsKt.listOf((Object[])objectArray);
        }

        @NotNull
        public List<MQType> getSupportedTypes() {
            return this.supportedTypes;
        }

        @NotNull
        public Iterable<MQTargetInfo> getVariants(@NotNull MQType typeHint) {
            Intrinsics.checkNotNullParameter((Object)typeHint, (String)"typeHint");
            return MQTypes.RABBIT_MQ_EXCHANGE_TYPE.isCompatibleWith(typeHint) ? MnRabbitModel.INSTANCE.getExchanges(this.project) : (MQTypes.RABBIT_MQ_QUEUE_TYPE.isCompatibleWith(typeHint) ? MnRabbitModel.INSTANCE.getQueues(this.project) : (Iterable<MQTargetInfo>)CollectionsKt.emptyList());
        }
    }
}

