/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.amper;

import com.intellij.amper.ModuleUtilsKt;
import com.intellij.amper.codeInsight.PsiUtilsKt;
import com.intellij.amper.project.entities.AmperModel;
import com.intellij.java.library.MavenCoordinates;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.packageChecker.amper.AmperFilesModificationTracker;
import com.intellij.packageChecker.api.PackageDeclaration;
import com.intellij.packageChecker.model.Package;
import com.intellij.packageChecker.model.PackageType;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.workspaceModel.ide.VirtualFileUrlManagerUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000f\u001a\u00020\nH\u0002\u001a\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"createPackage", "Lcom/intellij/packageChecker/model/Package;", "project", "Lcom/intellij/openapi/project/Project;", "dependency", "Lcom/intellij/amper/project/entities/AmperModel$Fragment$Notation$MavenDependency;", "getOrFindDeclaredDependenciesInFileOnly", "", "Lcom/intellij/packageChecker/api/PackageDeclaration;", "psiFile", "Lcom/intellij/psi/PsiFile;", "findDeclaredDependenciesFollowingLinks", "buildFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "findDeclaredDependenciesInFile", "file", "parseCoordinates", "Lcom/intellij/java/library/MavenCoordinates;", "coordinates", "", "intellij.packageChecker.amper"})
@SourceDebugExtension(value={"SMAP\nAmperPackageCheckerUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AmperPackageCheckerUtil.kt\ncom/intellij/packageChecker/amper/AmperPackageCheckerUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n1563#2:77\n1634#2,3:78\n*S KotlinDebug\n*F\n+ 1 AmperPackageCheckerUtil.kt\ncom/intellij/packageChecker/amper/AmperPackageCheckerUtilKt\n*L\n45#1:77\n45#1:78,3\n*E\n"})
public final class AmperPackageCheckerUtilKt {
    @Nullable
    public static final Package createPackage(@NotNull Project project, @NotNull AmperModel.Fragment.Notation.MavenDependency dependency) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        MavenCoordinates mavenCoordinates = AmperPackageCheckerUtilKt.parseCoordinates(dependency.getCoordinates());
        if (mavenCoordinates == null) {
            return null;
        }
        MavenCoordinates coordinates = mavenCoordinates;
        return Package.Companion.create(project, PackageType.maven, coordinates.getGroupId(), coordinates.getArtifactId(), coordinates.getVersion());
    }

    @NotNull
    public static final List<PackageDeclaration> getOrFindDeclaredDependenciesInFileOnly(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)psiFile), () -> AmperPackageCheckerUtilKt.getOrFindDeclaredDependenciesInFileOnly$lambda$0(psiFile));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (List)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<PackageDeclaration> findDeclaredDependenciesFollowingLinks(@NotNull Project project, @NotNull VirtualFile buildFile) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)buildFile, (String)"buildFile");
        List dependencyElements = new ArrayList();
        PsiFile psiFile = (PsiFile)ActionsKt.runReadAction(() -> AmperPackageCheckerUtilKt.findDeclaredDependenciesFollowingLinks$lambda$0(buildFile, project));
        if (psiFile == null) {
            return CollectionsKt.emptyList();
        }
        PsiFile psiFile2 = psiFile;
        List<PackageDeclaration> declarationInBuildFile = AmperPackageCheckerUtilKt.findDeclaredDependenciesInFile(psiFile2);
        CollectionsKt.addAll((Collection)dependencyElements, (Iterable)declarationInBuildFile);
        AmperModel.Module module = ModuleUtilsKt.findAmperModuleForModuleFile((Project)project, (VirtualFile)buildFile);
        if (module == null) {
            return CollectionsKt.emptyList();
        }
        AmperModel.Module amperModule = module;
        Iterable $this$map$iv = amperModule.getTemplates();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualFileUrl virtualFileUrl = (VirtualFileUrl)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(VirtualFileUrlManagerUtil.toPath((VirtualFileUrl)it));
        }
        List templatePaths = (List)destination$iv$iv;
        for (Path templatePath : templatePaths) {
            PsiFile templatePsiFile;
            VirtualFile templateFile;
            if (VfsUtil.findFile((Path)templatePath, (boolean)false) == null || (PsiFile)ActionsKt.runReadAction(() -> AmperPackageCheckerUtilKt.findDeclaredDependenciesFollowingLinks$lambda$2(templateFile, project)) == null) continue;
            List<PackageDeclaration> declarationsInTemplate = AmperPackageCheckerUtilKt.findDeclaredDependenciesInFile(templatePsiFile);
            CollectionsKt.addAll((Collection)dependencyElements, (Iterable)declarationsInTemplate);
        }
        return dependencyElements;
    }

    private static final List<PackageDeclaration> findDeclaredDependenciesInFile(PsiFile file) {
        List result = new ArrayList();
        ActionsKt.runReadAction(() -> AmperPackageCheckerUtilKt.findDeclaredDependenciesInFile$lambda$0(file, result));
        return result;
    }

    private static final MavenCoordinates parseCoordinates(String coordinates) {
        String[] stringArray = new String[]{":"};
        List parts = StringsKt.split$default((CharSequence)coordinates, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (parts.size() < 3) {
            return null;
        }
        return new MavenCoordinates((String)parts.get(0), (String)parts.get(1), (String)parts.get(2), null, null, parts.size() > 3 ? (String)parts.get(3) : null, 24, null);
    }

    private static final CachedValueProvider.Result getOrFindDeclaredDependenciesInFileOnly$lambda$0(PsiFile $psiFile) {
        List<PackageDeclaration> list = AmperPackageCheckerUtilKt.findDeclaredDependenciesInFile($psiFile);
        Object[] objectArray = new Object[3];
        objectArray[0] = ProjectRootManager.getInstance((Project)$psiFile.getProject());
        Project project = $psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        objectArray[1] = AmperFilesModificationTracker.Companion.getInstance(project);
        objectArray[2] = $psiFile;
        return CachedValueProvider.Result.create(list, (Object[])objectArray);
    }

    private static final PsiFile findDeclaredDependenciesFollowingLinks$lambda$0(VirtualFile $buildFile, Project $project) {
        return VirtualFileUtil.findPsiFile((VirtualFile)$buildFile, (Project)$project);
    }

    private static final PsiFile findDeclaredDependenciesFollowingLinks$lambda$2(VirtualFile $templateFile, Project $project) {
        return VirtualFileUtil.findPsiFile((VirtualFile)$templateFile, (Project)$project);
    }

    private static final Unit findDeclaredDependenciesInFile$lambda$0(PsiFile $file, List $result) {
        List dependenciesInFile = PsiUtilsKt.findAllDependenciesValues((PsiFile)$file);
        for (PsiElement dependency : dependenciesInFile) {
            MavenCoordinates coordinates;
            String dependencyText;
            if (PsiUtilsKt.getDependencyText((PsiElement)dependency) == null || AmperPackageCheckerUtilKt.parseCoordinates(dependencyText) == null) continue;
            Project project = $file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Package pkg = Package.Companion.create(project, PackageType.maven, coordinates.getGroupId(), coordinates.getArtifactId(), coordinates.getVersion());
            ((Collection)$result).add(new PackageDeclaration(pkg, dependency, null));
        }
        return Unit.INSTANCE;
    }
}

